/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.Query;
import org.elasticsearch.Version;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractLatLonPointDVIndexFieldData;
import org.elasticsearch.index.mapper.BaseGeoPointFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public class LatLonPointFieldMapper
extends BaseGeoPointFieldMapper {
    public static final String CONTENT_TYPE = "geo_point";
    public static final Version LAT_LON_FIELD_VERSION = Version.fromString("5.0.0-beta1");

    public LatLonPointFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, null, null, null, multiFields, ignoreMalformed, copyTo);
    }

    @Override
    protected void parse(ParseContext originalContext, GeoPoint point, String geoHash) throws IOException {
        ParseContext context = originalContext.setIncludeInAllDefault(false);
        if (!((Boolean)this.ignoreMalformed.value()).booleanValue()) {
            if (point.lat() > 90.0 || point.lat() < -90.0) {
                throw new IllegalArgumentException("illegal latitude value [" + point.lat() + "] for " + this.name());
            }
            if (point.lon() > 180.0 || point.lon() < -180.0) {
                throw new IllegalArgumentException("illegal longitude value [" + point.lon() + "] for " + this.name());
            }
        } else {
            GeoUtils.normalizePoint(point);
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE) {
            context.doc().add((IndexableField)new LatLonPoint(this.fieldType().name(), point.lat(), point.lon()));
        }
        if (this.fieldType().stored()) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), point.toString()));
        }
        if (this.fieldType.hasDocValues()) {
            context.doc().add((IndexableField)new LatLonDocValuesField(this.fieldType().name(), point.lat(), point.lon()));
        }
        if (this.multiFields.iterator().hasNext()) {
            this.multiFields.parse(this, context.createExternalValueContext(point.geohash()));
        }
    }

    public static class LatLonPointFieldType
    extends BaseGeoPointFieldMapper.GeoPointFieldType {
        LatLonPointFieldType() {
        }

        LatLonPointFieldType(LatLonPointFieldType ref) {
            super(ref);
        }

        @Override
        public String typeName() {
            return LatLonPointFieldMapper.CONTENT_TYPE;
        }

        @Override
        public MappedFieldType clone() {
            return new LatLonPointFieldType(this);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            this.failIfNoDocValues();
            return new AbstractLatLonPointDVIndexFieldData.Builder();
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Geo fields do not support exact searching, use dedicated geo queries instead: [" + this.name() + "]", new Object[0]);
        }

        @Override
        public FieldStats.GeoPoint stats(IndexReader reader) throws IOException {
            String field = this.name();
            FieldInfo fi = MultiFields.getMergedFieldInfos((IndexReader)reader).fieldInfo(this.name());
            if (fi == null) {
                return null;
            }
            long size = PointValues.size((IndexReader)reader, (String)field);
            if (size == 0L) {
                return new FieldStats.GeoPoint(reader.maxDoc(), -1L, -1L, -1L, this.isSearchable(), this.isAggregatable());
            }
            int docCount = PointValues.getDocCount((IndexReader)reader, (String)field);
            byte[] min2 = PointValues.getMinPackedValue((IndexReader)reader, (String)field);
            byte[] max = PointValues.getMaxPackedValue((IndexReader)reader, (String)field);
            GeoPoint minPt = new GeoPoint(GeoEncodingUtils.decodeLatitude((byte[])min2, (int)0), GeoEncodingUtils.decodeLongitude((byte[])min2, (int)4));
            GeoPoint maxPt = new GeoPoint(GeoEncodingUtils.decodeLatitude((byte[])max, (int)0), GeoEncodingUtils.decodeLongitude((byte[])max, (int)4));
            return new FieldStats.GeoPoint(reader.maxDoc(), docCount, -1L, size, this.isSearchable(), this.isAggregatable(), minPt, maxPt);
        }
    }

    public static class TypeParser
    extends BaseGeoPointFieldMapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            return super.parse(name, node, parserContext);
        }
    }

    public static class Builder
    extends BaseGeoPointFieldMapper.Builder<Builder, LatLonPointFieldMapper> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
        }

        @Override
        public LatLonPointFieldMapper build(Mapper.BuilderContext context, String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper latMapper, FieldMapper lonMapper, FieldMapper geoHashMapper, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, FieldMapper.CopyTo copyTo) {
            this.setupFieldType(context);
            return new LatLonPointFieldMapper(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, ignoreMalformed, copyTo);
        }

        @Override
        public LatLonPointFieldMapper build(Mapper.BuilderContext context) {
            return (LatLonPointFieldMapper)super.build(context);
        }
    }

    public static class Defaults
    extends BaseGeoPointFieldMapper.Defaults {
        public static final LatLonPointFieldType FIELD_TYPE = new LatLonPointFieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setHasDocValues(true);
            FIELD_TYPE.setDimensions(2, 4);
            FIELD_TYPE.freeze();
        }
    }
}

