/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SingletonMultiGeoPointValues;
import org.elasticsearch.index.fielddata.SingletonSortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SingletonSortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortableLongBitsNumericDocValues;
import org.elasticsearch.index.fielddata.SortableLongBitsSortedNumericDocValues;
import org.elasticsearch.index.fielddata.SortableLongBitsToNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortableLongBitsToSortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortingBinaryDocValues;

public final class FieldData
extends Enum<FieldData> {
    private static final /* synthetic */ FieldData[] $VALUES;

    public static FieldData[] values() {
        return (FieldData[])$VALUES.clone();
    }

    public static FieldData valueOf(String name) {
        return Enum.valueOf(FieldData.class, name);
    }

    public static SortedBinaryDocValues emptySortedBinary(int maxDoc) {
        return FieldData.singleton(DocValues.emptyBinary(), (Bits)new Bits.MatchNoBits(maxDoc));
    }

    public static NumericDoubleValues emptyNumericDouble() {
        return new NumericDoubleValues(){

            @Override
            public double get(int docID) {
                return 0.0;
            }
        };
    }

    public static SortedNumericDoubleValues emptySortedNumericDoubles(int maxDoc) {
        return FieldData.singleton(FieldData.emptyNumericDouble(), (Bits)new Bits.MatchNoBits(maxDoc));
    }

    public static GeoPointValues emptyGeoPoint() {
        final GeoPoint point = new GeoPoint();
        return new GeoPointValues(){

            @Override
            public GeoPoint get(int docID) {
                return point;
            }
        };
    }

    public static MultiGeoPointValues emptyMultiGeoPoints(int maxDoc) {
        return FieldData.singleton(FieldData.emptyGeoPoint(), (Bits)new Bits.MatchNoBits(maxDoc));
    }

    public static Bits docsWithValue(final SortedBinaryDocValues dv, final int maxDoc) {
        return new Bits(){

            public boolean get(int index) {
                dv.setDocument(index);
                return dv.count() != 0;
            }

            public int length() {
                return maxDoc;
            }
        };
    }

    public static Bits docsWithValue(final MultiGeoPointValues dv, final int maxDoc) {
        return new Bits(){

            public boolean get(int index) {
                dv.setDocument(index);
                return dv.count() != 0;
            }

            public int length() {
                return maxDoc;
            }
        };
    }

    public static Bits docsWithValue(final SortedNumericDoubleValues dv, final int maxDoc) {
        return new Bits(){

            public boolean get(int index) {
                dv.setDocument(index);
                return dv.count() != 0;
            }

            public int length() {
                return maxDoc;
            }
        };
    }

    public static SortedNumericDocValues toSortableLongBits(SortedNumericDoubleValues values) {
        NumericDoubleValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            Object longBits = singleton instanceof SortableLongBitsToNumericDoubleValues ? ((SortableLongBitsToNumericDoubleValues)singleton).getLongValues() : new SortableLongBitsNumericDocValues(singleton);
            Bits docsWithField = FieldData.unwrapSingletonBits(values);
            return DocValues.singleton((NumericDocValues)longBits, (Bits)docsWithField);
        }
        if (values instanceof SortableLongBitsToSortedNumericDoubleValues) {
            return ((SortableLongBitsToSortedNumericDoubleValues)values).getLongValues();
        }
        return new SortableLongBitsSortedNumericDocValues(values);
    }

    public static SortedNumericDoubleValues sortableLongBitsToDoubles(SortedNumericDocValues values) {
        NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        if (singleton != null) {
            NumericDoubleValues doubles = singleton instanceof SortableLongBitsNumericDocValues ? ((SortableLongBitsNumericDocValues)singleton).getDoubleValues() : new SortableLongBitsToNumericDoubleValues(singleton);
            Bits docsWithField = DocValues.unwrapSingletonBits((SortedNumericDocValues)values);
            return FieldData.singleton(doubles, docsWithField);
        }
        if (values instanceof SortableLongBitsSortedNumericDocValues) {
            return ((SortableLongBitsSortedNumericDocValues)values).getDoubleValues();
        }
        return new SortableLongBitsToSortedNumericDoubleValues(values);
    }

    public static SortedNumericDoubleValues castToDouble(SortedNumericDocValues values) {
        NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        if (singleton != null) {
            Bits docsWithField = DocValues.unwrapSingletonBits((SortedNumericDocValues)values);
            return FieldData.singleton(new DoubleCastedValues(singleton), docsWithField);
        }
        return new SortedDoubleCastedValues(values);
    }

    public static SortedNumericDocValues castToLong(SortedNumericDoubleValues values) {
        NumericDoubleValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            Bits docsWithField = FieldData.unwrapSingletonBits(values);
            return DocValues.singleton((NumericDocValues)new LongCastedValues(singleton), (Bits)docsWithField);
        }
        return new SortedLongCastedValues(values);
    }

    public static SortedNumericDoubleValues singleton(NumericDoubleValues values, Bits docsWithField) {
        return new SingletonSortedNumericDoubleValues(values, docsWithField);
    }

    public static NumericDoubleValues unwrapSingleton(SortedNumericDoubleValues values) {
        if (values instanceof SingletonSortedNumericDoubleValues) {
            return ((SingletonSortedNumericDoubleValues)values).getNumericDoubleValues();
        }
        return null;
    }

    public static Bits unwrapSingletonBits(SortedNumericDoubleValues dv) {
        if (dv instanceof SingletonSortedNumericDoubleValues) {
            return ((SingletonSortedNumericDoubleValues)dv).getDocsWithField();
        }
        return null;
    }

    public static MultiGeoPointValues singleton(GeoPointValues values, Bits docsWithField) {
        return new SingletonMultiGeoPointValues(values, docsWithField);
    }

    public static GeoPointValues unwrapSingleton(MultiGeoPointValues values) {
        if (values instanceof SingletonMultiGeoPointValues) {
            return ((SingletonMultiGeoPointValues)values).getGeoPointValues();
        }
        return null;
    }

    public static Bits unwrapSingletonBits(MultiGeoPointValues values) {
        if (values instanceof SingletonMultiGeoPointValues) {
            return ((SingletonMultiGeoPointValues)values).getDocsWithField();
        }
        return null;
    }

    public static SortedBinaryDocValues singleton(BinaryDocValues values, Bits docsWithField) {
        return new SingletonSortedBinaryDocValues(values, docsWithField);
    }

    public static BinaryDocValues unwrapSingleton(SortedBinaryDocValues values) {
        if (values instanceof SingletonSortedBinaryDocValues) {
            return ((SingletonSortedBinaryDocValues)values).getBinaryDocValues();
        }
        return null;
    }

    public static Bits unwrapSingletonBits(SortedBinaryDocValues values) {
        if (values instanceof SingletonSortedBinaryDocValues) {
            return ((SingletonSortedBinaryDocValues)values).getDocsWithField();
        }
        return null;
    }

    public static boolean isMultiValued(SortedSetDocValues values) {
        return DocValues.unwrapSingleton((SortedSetDocValues)values) == null;
    }

    public static boolean isMultiValued(SortedNumericDocValues values) {
        return DocValues.unwrapSingleton((SortedNumericDocValues)values) == null;
    }

    public static boolean isMultiValued(SortedNumericDoubleValues values) {
        return FieldData.unwrapSingleton(values) == null;
    }

    public static boolean isMultiValued(SortedBinaryDocValues values) {
        return FieldData.unwrapSingleton(values) != null;
    }

    public static boolean isMultiValued(MultiGeoPointValues values) {
        return FieldData.unwrapSingleton(values) == null;
    }

    public static SortedBinaryDocValues toString(final SortedNumericDocValues values) {
        return FieldData.toString(new ToStringValues(){

            @Override
            public void get(int docID, List<CharSequence> list) {
                values.setDocument(docID);
                int count = values.count();
                for (int i = 0; i < count; ++i) {
                    list.add(Long.toString(values.valueAt(i)));
                }
            }
        });
    }

    public static SortedBinaryDocValues toString(final SortedNumericDoubleValues values) {
        return FieldData.toString(new ToStringValues(){

            @Override
            public void get(int docID, List<CharSequence> list) {
                values.setDocument(docID);
                int count = values.count();
                for (int i = 0; i < count; ++i) {
                    list.add(Double.toString(values.valueAt(i)));
                }
            }
        });
    }

    public static SortedBinaryDocValues toString(final RandomAccessOrds values) {
        return new SortedBinaryDocValues(){

            @Override
            public BytesRef valueAt(int index) {
                return values.lookupOrd(values.ordAt(index));
            }

            @Override
            public void setDocument(int docId) {
                values.setDocument(docId);
            }

            @Override
            public int count() {
                return values.cardinality();
            }
        };
    }

    public static SortedBinaryDocValues toString(final MultiGeoPointValues values) {
        return FieldData.toString(new ToStringValues(){

            @Override
            public void get(int docID, List<CharSequence> list) {
                values.setDocument(docID);
                int count = values.count();
                for (int i = 0; i < count; ++i) {
                    list.add(values.valueAt(i).toString());
                }
            }
        });
    }

    public static RandomAccessOrds maybeSlowRandomAccessOrds(final SortedSetDocValues dv) {
        if (dv instanceof RandomAccessOrds) {
            return (RandomAccessOrds)dv;
        }
        assert (DocValues.unwrapSingleton((SortedSetDocValues)dv) == null) : "this method expect singleton to return random-access ords";
        return new RandomAccessOrds(){
            int cardinality;
            long[] ords = new long[0];
            int ord;

            public void setDocument(int docID) {
                this.cardinality = 0;
                dv.setDocument(docID);
                long ord = dv.nextOrd();
                while (ord != -1L) {
                    this.ords = ArrayUtil.grow((long[])this.ords, (int)(this.cardinality + 1));
                    this.ords[this.cardinality++] = ord;
                    ord = dv.nextOrd();
                }
                this.ord = 0;
            }

            public long nextOrd() {
                return this.ords[this.ord++];
            }

            public BytesRef lookupOrd(long ord) {
                return dv.lookupOrd(ord);
            }

            public long getValueCount() {
                return dv.getValueCount();
            }

            public long ordAt(int index) {
                return this.ords[index];
            }

            public int cardinality() {
                return this.cardinality;
            }
        };
    }

    private static SortedBinaryDocValues toString(final ToStringValues toStringValues) {
        return new SortingBinaryDocValues(){
            final List<CharSequence> list = new ArrayList<CharSequence>();

            @Override
            public void setDocument(int docID) {
                this.list.clear();
                toStringValues.get(docID, this.list);
                this.count = this.list.size();
                this.grow();
                for (int i = 0; i < this.count; ++i) {
                    CharSequence s2 = this.list.get(i);
                    this.values[i].copyChars(s2);
                }
                this.sort();
            }
        };
    }

    static {
        $VALUES = new FieldData[0];
    }

    private static class SortedLongCastedValues
    extends SortedNumericDocValues {
        private final SortedNumericDoubleValues values;

        SortedLongCastedValues(SortedNumericDoubleValues in) {
            this.values = in;
        }

        public long valueAt(int index) {
            return (long)this.values.valueAt(index);
        }

        public void setDocument(int doc) {
            this.values.setDocument(doc);
        }

        public int count() {
            return this.values.count();
        }
    }

    private static class LongCastedValues
    extends NumericDocValues {
        private final NumericDoubleValues values;

        LongCastedValues(NumericDoubleValues values) {
            this.values = values;
        }

        public long get(int docID) {
            return (long)this.values.get(docID);
        }
    }

    private static class SortedDoubleCastedValues
    extends SortedNumericDoubleValues {
        private final SortedNumericDocValues values;

        SortedDoubleCastedValues(SortedNumericDocValues in) {
            this.values = in;
        }

        @Override
        public double valueAt(int index) {
            return this.values.valueAt(index);
        }

        @Override
        public void setDocument(int doc) {
            this.values.setDocument(doc);
        }

        @Override
        public int count() {
            return this.values.count();
        }
    }

    private static class DoubleCastedValues
    extends NumericDoubleValues {
        private final NumericDocValues values;

        DoubleCastedValues(NumericDocValues values) {
            this.values = values;
        }

        @Override
        public double get(int docID) {
            return this.values.get(docID);
        }
    }

    private static interface ToStringValues {
        public void get(int var1, List<CharSequence> var2);
    }
}

