/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.index.engine.VersionValue;

class DeleteVersionValue
extends VersionValue {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DeleteVersionValue.class);
    private final long time;

    DeleteVersionValue(long version2, long time) {
        super(version2);
        this.time = time;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public boolean isDelete() {
        return true;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED;
    }

    @Override
    public String toString() {
        return "DeleteVersionValue{version=" + this.getVersion() + ",time=" + this.time + '}';
    }
}

