/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty3;

import com.carrotsearch.hppc.IntHashSet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.http.BindHttpException;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpStats;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.http.netty3.ESNetty3HttpResponseEncoder;
import org.elasticsearch.http.netty3.Netty3HttpRequestHandler;
import org.elasticsearch.http.netty3.cors.Netty3CorsConfig;
import org.elasticsearch.http.netty3.cors.Netty3CorsConfigBuilder;
import org.elasticsearch.http.netty3.cors.Netty3CorsHandler;
import org.elasticsearch.http.netty3.pipelining.HttpPipeliningHandler;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.netty3.Netty3OpenChannelsHandler;
import org.elasticsearch.transport.netty3.Netty3Utils;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.AdaptiveReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.ReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.timeout.ReadTimeoutException;

public class Netty3HttpServerTransport
extends AbstractLifecycleComponent
implements HttpServerTransport {
    public static Setting<ByteSizeValue> SETTING_HTTP_NETTY_MAX_CUMULATION_BUFFER_CAPACITY;
    public static Setting<Integer> SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS;
    public static final Setting<Integer> SETTING_HTTP_WORKER_COUNT;
    public static final Setting<Boolean> SETTING_HTTP_TCP_NO_DELAY;
    public static final Setting<Boolean> SETTING_HTTP_TCP_KEEP_ALIVE;
    public static final Setting<Boolean> SETTING_HTTP_TCP_BLOCKING_SERVER;
    public static final Setting<Boolean> SETTING_HTTP_TCP_REUSE_ADDRESS;
    public static final Setting<ByteSizeValue> SETTING_HTTP_TCP_SEND_BUFFER_SIZE;
    public static final Setting<ByteSizeValue> SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE;
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE;
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MIN;
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MAX;
    protected final NetworkService networkService;
    protected final BigArrays bigArrays;
    protected final ByteSizeValue maxContentLength;
    protected final ByteSizeValue maxInitialLineLength;
    protected final ByteSizeValue maxHeaderSize;
    protected final ByteSizeValue maxChunkSize;
    protected final int workerCount;
    protected final boolean blockingServer;
    protected final boolean pipelining;
    protected final int pipeliningMaxEvents;
    protected final boolean compression;
    protected final int compressionLevel;
    protected final boolean resetCookies;
    protected final PortsRange port;
    protected final String[] bindHosts;
    protected final String[] publishHosts;
    protected final boolean detailedErrorsEnabled;
    protected final ThreadPool threadPool;
    protected final NamedXContentRegistry xContentRegistry;
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    protected final boolean reuseAddress;
    protected final ByteSizeValue tcpSendBufferSize;
    protected final ByteSizeValue tcpReceiveBufferSize;
    protected final ReceiveBufferSizePredictorFactory receiveBufferSizePredictorFactory;
    protected final ByteSizeValue maxCumulationBufferCapacity;
    protected final int maxCompositeBufferComponents;
    private final HttpServerTransport.Dispatcher dispatcher;
    protected volatile ServerBootstrap serverBootstrap;
    protected volatile BoundTransportAddress boundAddress;
    protected volatile List<Channel> serverChannels = new ArrayList<Channel>();
    Netty3OpenChannelsHandler serverOpenChannels;
    private final Netty3CorsConfig corsConfig;

    public Netty3HttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher) {
        super(settings);
        this.deprecationLogger.deprecated(this.deprecationMessage(), new Object[0]);
        this.networkService = networkService;
        this.bigArrays = bigArrays;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.dispatcher = dispatcher;
        ByteSizeValue maxContentLength = HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get(settings);
        this.maxChunkSize = HttpTransportSettings.SETTING_HTTP_MAX_CHUNK_SIZE.get(settings);
        this.maxHeaderSize = HttpTransportSettings.SETTING_HTTP_MAX_HEADER_SIZE.get(settings);
        this.maxInitialLineLength = HttpTransportSettings.SETTING_HTTP_MAX_INITIAL_LINE_LENGTH.get(settings);
        this.resetCookies = HttpTransportSettings.SETTING_HTTP_RESET_COOKIES.get(settings);
        this.maxCumulationBufferCapacity = SETTING_HTTP_NETTY_MAX_CUMULATION_BUFFER_CAPACITY.get(settings);
        this.maxCompositeBufferComponents = SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS.get(settings);
        this.workerCount = SETTING_HTTP_WORKER_COUNT.get(settings);
        this.blockingServer = SETTING_HTTP_TCP_BLOCKING_SERVER.get(settings);
        this.port = HttpTransportSettings.SETTING_HTTP_PORT.get(settings);
        this.bindHosts = HttpTransportSettings.SETTING_HTTP_BIND_HOST.get(settings).toArray(Strings.EMPTY_ARRAY);
        this.publishHosts = HttpTransportSettings.SETTING_HTTP_PUBLISH_HOST.get(settings).toArray(Strings.EMPTY_ARRAY);
        this.tcpNoDelay = SETTING_HTTP_TCP_NO_DELAY.get(settings);
        this.tcpKeepAlive = SETTING_HTTP_TCP_KEEP_ALIVE.get(settings);
        this.reuseAddress = SETTING_HTTP_TCP_REUSE_ADDRESS.get(settings);
        this.tcpSendBufferSize = SETTING_HTTP_TCP_SEND_BUFFER_SIZE.get(settings);
        this.tcpReceiveBufferSize = SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE.get(settings);
        this.detailedErrorsEnabled = HttpTransportSettings.SETTING_HTTP_DETAILED_ERRORS_ENABLED.get(settings);
        ByteSizeValue receivePredictorMin = SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MIN.get(settings);
        ByteSizeValue receivePredictorMax = SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MAX.get(settings);
        this.receiveBufferSizePredictorFactory = receivePredictorMax.getBytes() == receivePredictorMin.getBytes() ? new FixedReceiveBufferSizePredictorFactory((int)receivePredictorMax.getBytes()) : new AdaptiveReceiveBufferSizePredictorFactory((int)receivePredictorMin.getBytes(), (int)receivePredictorMin.getBytes(), (int)receivePredictorMax.getBytes());
        this.compression = HttpTransportSettings.SETTING_HTTP_COMPRESSION.get(settings);
        this.compressionLevel = HttpTransportSettings.SETTING_HTTP_COMPRESSION_LEVEL.get(settings);
        this.pipelining = HttpTransportSettings.SETTING_PIPELINING.get(settings);
        this.pipeliningMaxEvents = HttpTransportSettings.SETTING_PIPELINING_MAX_EVENTS.get(settings);
        this.corsConfig = this.buildCorsConfig(settings);
        if (maxContentLength.getBytes() > Integer.MAX_VALUE) {
            this.logger.warn("maxContentLength[{}] set to high value, resetting it to [100mb]", (Object)maxContentLength);
            maxContentLength = new ByteSizeValue(100L, ByteSizeUnit.MB);
        }
        this.maxContentLength = maxContentLength;
        this.logger.debug("using max_chunk_size[{}], max_header_size[{}], max_initial_line_length[{}], max_content_length[{}], receive_predictor[{}->{}], pipelining[{}], pipelining_max_events[{}]", (Object)this.maxChunkSize, (Object)this.maxHeaderSize, (Object)this.maxInitialLineLength, (Object)this.maxContentLength, (Object)receivePredictorMin, (Object)receivePredictorMax, (Object)this.pipelining, (Object)this.pipeliningMaxEvents);
    }

    protected String deprecationMessage() {
        return "http type [netty3] is deprecated";
    }

    public Settings settings() {
        return this.settings;
    }

    @Override
    protected void doStart() {
        boolean success = false;
        try {
            this.serverOpenChannels = new Netty3OpenChannelsHandler(this.logger);
            this.serverBootstrap = this.blockingServer ? new ServerBootstrap(new OioServerSocketChannelFactory(Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "http_server_boss")), Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "http_server_worker")))) : new ServerBootstrap(new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "http_server_boss")), Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "http_server_worker")), this.workerCount));
            this.serverBootstrap.setPipelineFactory(this.configureServerChannelPipelineFactory());
            this.serverBootstrap.setOption("child.tcpNoDelay", this.tcpNoDelay);
            this.serverBootstrap.setOption("child.keepAlive", this.tcpKeepAlive);
            if (this.tcpSendBufferSize.getBytes() > 0L) {
                this.serverBootstrap.setOption("child.sendBufferSize", this.tcpSendBufferSize.getBytes());
            }
            if (this.tcpReceiveBufferSize.getBytes() > 0L) {
                this.serverBootstrap.setOption("child.receiveBufferSize", this.tcpReceiveBufferSize.getBytes());
            }
            this.serverBootstrap.setOption("receiveBufferSizePredictorFactory", this.receiveBufferSizePredictorFactory);
            this.serverBootstrap.setOption("child.receiveBufferSizePredictorFactory", this.receiveBufferSizePredictorFactory);
            this.serverBootstrap.setOption("reuseAddress", this.reuseAddress);
            this.serverBootstrap.setOption("child.reuseAddress", this.reuseAddress);
            this.boundAddress = this.createBoundHttpAddress();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    private BoundTransportAddress createBoundHttpAddress() {
        InetAddress publishInetAddress;
        InetAddress[] hostAddresses;
        try {
            hostAddresses = this.networkService.resolveBindHostAddresses(this.bindHosts);
        }
        catch (IOException e) {
            throw new BindHttpException("Failed to resolve host [" + Arrays.toString(this.bindHosts) + "]", e);
        }
        ArrayList<InetSocketTransportAddress> boundAddresses = new ArrayList<InetSocketTransportAddress>(hostAddresses.length);
        for (InetAddress address : hostAddresses) {
            boundAddresses.add(this.bindAddress(address));
        }
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(this.publishHosts);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        int publishPort = Netty3HttpServerTransport.resolvePublishPort(this.settings, boundAddresses, publishInetAddress);
        InetSocketAddress publishAddress = new InetSocketAddress(publishInetAddress, publishPort);
        return new BoundTransportAddress(boundAddresses.toArray(new TransportAddress[0]), new InetSocketTransportAddress(publishAddress));
    }

    static int resolvePublishPort(Settings settings, List<InetSocketTransportAddress> boundAddresses, InetAddress publishInetAddress) {
        int publishPort = HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.get(settings);
        if (publishPort < 0) {
            for (InetSocketTransportAddress boundAddress : boundAddresses) {
                InetAddress boundInetAddress = boundAddress.address().getAddress();
                if (!boundInetAddress.isAnyLocalAddress() && !boundInetAddress.equals(publishInetAddress)) continue;
                publishPort = boundAddress.getPort();
                break;
            }
        }
        if (publishPort < 0) {
            IntHashSet ports = new IntHashSet();
            for (InetSocketTransportAddress boundAddress : boundAddresses) {
                ports.add(boundAddress.getPort());
            }
            if (ports.size() == 1) {
                publishPort = ports.iterator().next().value;
            }
        }
        if (publishPort < 0) {
            throw new BindHttpException("Failed to auto-resolve http publish port, multiple bound addresses " + boundAddresses + " with distinct ports and none of them matched the publish address (" + publishInetAddress + "). Please specify a unique port by setting " + HttpTransportSettings.SETTING_HTTP_PORT.getKey() + " or " + HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.getKey());
        }
        return publishPort;
    }

    private Netty3CorsConfig buildCorsConfig(Settings settings) {
        Pattern p;
        if (!HttpTransportSettings.SETTING_CORS_ENABLED.get(settings).booleanValue()) {
            return Netty3CorsConfigBuilder.forOrigins(new String[0]).disable().build();
        }
        String origin = HttpTransportSettings.SETTING_CORS_ALLOW_ORIGIN.get(settings);
        Netty3CorsConfigBuilder builder = Strings.isNullOrEmpty(origin) ? Netty3CorsConfigBuilder.forOrigins(new String[0]) : (origin.equals("*") ? Netty3CorsConfigBuilder.forAnyOrigin() : ((p = RestUtils.checkCorsSettingForRegex(origin)) == null ? Netty3CorsConfigBuilder.forOrigins(RestUtils.corsSettingAsArray(origin)) : Netty3CorsConfigBuilder.forPattern(p)));
        if (HttpTransportSettings.SETTING_CORS_ALLOW_CREDENTIALS.get(settings).booleanValue()) {
            builder.allowCredentials();
        }
        Set<String> strMethods = Strings.splitStringByCommaToSet(HttpTransportSettings.SETTING_CORS_ALLOW_METHODS.get(settings));
        return builder.allowedRequestMethods(strMethods.stream().map(HttpMethod::valueOf).collect(Collectors.toSet())).maxAge(HttpTransportSettings.SETTING_CORS_MAX_AGE.get(settings).intValue()).allowedRequestHeaders(Strings.splitStringByCommaToSet(HttpTransportSettings.SETTING_CORS_ALLOW_HEADERS.get(settings))).shortCircuit().build();
    }

    private InetSocketTransportAddress bindAddress(InetAddress hostAddress) {
        AtomicReference boundSocket = new AtomicReference();
        AtomicReference lastException = new AtomicReference();
        boolean success = this.port.iterate(portNumber -> {
            try {
                List<Channel> list = this.serverChannels;
                synchronized (list) {
                    Channel channel = this.serverBootstrap.bind(new InetSocketAddress(hostAddress, portNumber));
                    this.serverChannels.add(channel);
                    boundSocket.set((InetSocketAddress)channel.getLocalAddress());
                }
            }
            catch (Exception e) {
                lastException.set(e);
                return false;
            }
            return true;
        });
        if (!success) {
            throw new BindHttpException("Failed to bind to [" + this.port.getPortRangeString() + "]", (Throwable)lastException.get());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Bound http to address {{}}", (Object)NetworkAddress.format((InetSocketAddress)boundSocket.get()));
        }
        return new InetSocketTransportAddress((InetSocketAddress)boundSocket.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        List<Channel> list = this.serverChannels;
        synchronized (list) {
            if (this.serverChannels != null) {
                for (Channel channel : this.serverChannels) {
                    channel.close().awaitUninterruptibly();
                }
                this.serverChannels = null;
            }
        }
        if (this.serverOpenChannels != null) {
            this.serverOpenChannels.close();
            this.serverOpenChannels = null;
        }
        if (this.serverBootstrap != null) {
            this.serverBootstrap.releaseExternalResources();
            this.serverBootstrap = null;
        }
    }

    @Override
    protected void doClose() {
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    public HttpInfo info() {
        BoundTransportAddress boundTransportAddress = this.boundAddress();
        if (boundTransportAddress == null) {
            return null;
        }
        return new HttpInfo(boundTransportAddress, this.maxContentLength.getBytes());
    }

    @Override
    public HttpStats stats() {
        Netty3OpenChannelsHandler channels = this.serverOpenChannels;
        return new HttpStats(channels == null ? 0L : channels.numberOfOpenChannels(), channels == null ? 0L : channels.totalChannels());
    }

    public Netty3CorsConfig getCorsConfig() {
        return this.corsConfig;
    }

    protected void dispatchRequest(RestRequest request, RestChannel channel) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            this.dispatcher.dispatchRequest(request, channel, threadContext);
        }
    }

    protected void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Netty3Utils.maybeDie(e.getCause());
        if (e.getCause() instanceof ReadTimeoutException) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Connection timeout [{}]", (Object)ctx.getChannel().getRemoteAddress());
            }
            ctx.getChannel().close();
        } else {
            if (!this.lifecycle.started()) {
                return;
            }
            if (!NetworkExceptionHelper.isCloseConnectionException(e.getCause())) {
                this.logger.warn(() -> new ParameterizedMessage("Caught exception while handling client http traffic, closing connection {}", (Object)ctx.getChannel()), e.getCause());
                ctx.getChannel().close();
            } else {
                this.logger.debug(() -> new ParameterizedMessage("Caught exception while handling client http traffic, closing connection {}", (Object)ctx.getChannel()), e.getCause());
                ctx.getChannel().close();
            }
        }
    }

    public ChannelPipelineFactory configureServerChannelPipelineFactory() {
        return new HttpChannelPipelineFactory(this, this.detailedErrorsEnabled, this.threadPool.getThreadContext());
    }

    static {
        Netty3Utils.setup();
        SETTING_HTTP_NETTY_MAX_CUMULATION_BUFFER_CAPACITY = Setting.byteSizeSetting("http.netty.max_cumulation_buffer_capacity", new ByteSizeValue(-1L), Setting.Property.NodeScope, Setting.Property.Shared);
        SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = Setting.intSetting("http.netty.max_composite_buffer_components", -1, Setting.Property.NodeScope, Setting.Property.Shared);
        SETTING_HTTP_WORKER_COUNT = new Setting<Integer>("http.netty.worker_count", s2 -> Integer.toString(EsExecutors.boundedNumberOfProcessors(s2) * 2), s2 -> Setting.parseInt(s2, 1, "http.netty.worker_count"), Setting.Property.NodeScope, Setting.Property.Shared);
        SETTING_HTTP_TCP_NO_DELAY = Setting.boolSetting("http.tcp_no_delay", NetworkService.TcpSettings.TCP_NO_DELAY, Setting.Property.NodeScope, Setting.Property.Shared);
        SETTING_HTTP_TCP_KEEP_ALIVE = Setting.boolSetting("http.tcp.keep_alive", NetworkService.TcpSettings.TCP_KEEP_ALIVE, Setting.Property.NodeScope, Setting.Property.Shared);
        SETTING_HTTP_TCP_BLOCKING_SERVER = Setting.boolSetting("http.tcp.blocking_server", NetworkService.TcpSettings.TCP_BLOCKING_SERVER, Setting.Property.NodeScope, Setting.Property.Shared);
        SETTING_HTTP_TCP_REUSE_ADDRESS = Setting.boolSetting("http.tcp.reuse_address", NetworkService.TcpSettings.TCP_REUSE_ADDRESS, Setting.Property.NodeScope, Setting.Property.Shared);
        SETTING_HTTP_TCP_SEND_BUFFER_SIZE = Setting.byteSizeSetting("http.tcp.send_buffer_size", NetworkService.TcpSettings.TCP_SEND_BUFFER_SIZE, Setting.Property.NodeScope, Setting.Property.Shared);
        SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE = Setting.byteSizeSetting("http.tcp.receive_buffer_size", NetworkService.TcpSettings.TCP_RECEIVE_BUFFER_SIZE, Setting.Property.NodeScope, Setting.Property.Shared);
        SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting("transport.netty.receive_predictor_size", settings -> {
            long defaultReceiverPredictor = 524288L;
            if (JvmInfo.jvmInfo().getMem().getDirectMemoryMax().getBytes() > 0L) {
                long l = (long)(0.3 * (double)JvmInfo.jvmInfo().getMem().getDirectMemoryMax().getBytes() / (double)SETTING_HTTP_WORKER_COUNT.get((Settings)settings).intValue());
                defaultReceiverPredictor = Math.min(defaultReceiverPredictor, Math.max(l, 65536L));
            }
            return new ByteSizeValue(defaultReceiverPredictor).toString();
        }, Setting.Property.NodeScope);
        SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MIN = Setting.byteSizeSetting("http.netty.receive_predictor_min", SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE, Setting.Property.NodeScope);
        SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MAX = Setting.byteSizeSetting("http.netty.receive_predictor_max", SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE, Setting.Property.NodeScope);
    }

    protected static class HttpChannelPipelineFactory
    implements ChannelPipelineFactory {
        protected final Netty3HttpServerTransport transport;
        protected final Netty3HttpRequestHandler requestHandler;

        public HttpChannelPipelineFactory(Netty3HttpServerTransport transport, boolean detailedErrorsEnabled, ThreadContext threadContext) {
            this.transport = transport;
            this.requestHandler = new Netty3HttpRequestHandler(transport, detailedErrorsEnabled, threadContext);
        }

        @Override
        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("openChannels", this.transport.serverOpenChannels);
            HttpRequestDecoder requestDecoder = new HttpRequestDecoder((int)this.transport.maxInitialLineLength.getBytes(), (int)this.transport.maxHeaderSize.getBytes(), (int)this.transport.maxChunkSize.getBytes());
            if (this.transport.maxCumulationBufferCapacity.getBytes() >= 0L) {
                if (this.transport.maxCumulationBufferCapacity.getBytes() > Integer.MAX_VALUE) {
                    requestDecoder.setMaxCumulationBufferCapacity(Integer.MAX_VALUE);
                } else {
                    requestDecoder.setMaxCumulationBufferCapacity((int)this.transport.maxCumulationBufferCapacity.getBytes());
                }
            }
            if (this.transport.maxCompositeBufferComponents != -1) {
                requestDecoder.setMaxCumulationBufferComponents(this.transport.maxCompositeBufferComponents);
            }
            pipeline.addLast("decoder", requestDecoder);
            pipeline.addLast("decoder_compress", new HttpContentDecompressor());
            HttpChunkAggregator httpChunkAggregator = new HttpChunkAggregator((int)this.transport.maxContentLength.getBytes());
            if (this.transport.maxCompositeBufferComponents != -1) {
                httpChunkAggregator.setMaxCumulationBufferComponents(this.transport.maxCompositeBufferComponents);
            }
            pipeline.addLast("aggregator", httpChunkAggregator);
            pipeline.addLast("encoder", new ESNetty3HttpResponseEncoder());
            if (this.transport.compression) {
                pipeline.addLast("encoder_compress", new HttpContentCompressor(this.transport.compressionLevel));
            }
            if (HttpTransportSettings.SETTING_CORS_ENABLED.get(this.transport.settings()).booleanValue()) {
                pipeline.addLast("cors", new Netty3CorsHandler(this.transport.getCorsConfig()));
            }
            if (this.transport.pipelining) {
                pipeline.addLast("pipelining", new HttpPipeliningHandler(this.transport.pipeliningMaxEvents));
            }
            pipeline.addLast("handler", this.requestHandler);
            return pipeline;
        }
    }
}

