/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.BytesStream;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class XContentBuilder
implements BytesStream,
Releasable,
Flushable {
    public static final DateTimeFormatter DEFAULT_DATE_PRINTER = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    private static final Map<Class<?>, Writer> WRITERS;
    private final XContentGenerator generator;
    private final OutputStream bos;
    private boolean humanReadable = false;

    public static XContentBuilder builder(XContent xContent) throws IOException {
        return new XContentBuilder(xContent, new BytesStreamOutput());
    }

    public static XContentBuilder builder(XContent xContent, Set<String> includes, Set<String> excludes) throws IOException {
        return new XContentBuilder(xContent, new BytesStreamOutput(), includes, excludes);
    }

    public XContentBuilder(XContent xContent, OutputStream bos) throws IOException {
        this(xContent, bos, Collections.emptySet(), Collections.emptySet());
    }

    public XContentBuilder(XContent xContent, OutputStream bos, Set<String> includes) throws IOException {
        this(xContent, bos, includes, Collections.emptySet());
    }

    public XContentBuilder(XContent xContent, OutputStream os, Set<String> includes, Set<String> excludes) throws IOException {
        this.bos = os;
        this.generator = xContent.createGenerator(this.bos, includes, excludes);
    }

    public XContentType contentType() {
        return this.generator.contentType();
    }

    public XContentBuilder prettyPrint() {
        this.generator.usePrettyPrint();
        return this;
    }

    public boolean isPrettyPrint() {
        return this.generator.isPrettyPrint();
    }

    public XContentBuilder lfAtEnd() {
        this.generator.usePrintLineFeedAtEnd();
        return this;
    }

    public XContentBuilder humanReadable(boolean humanReadable) {
        this.humanReadable = humanReadable;
        return this;
    }

    public boolean humanReadable() {
        return this.humanReadable;
    }

    public XContentBuilder startObject() throws IOException {
        this.generator.writeStartObject();
        return this;
    }

    public XContentBuilder startObject(String name) throws IOException {
        return this.field(name).startObject();
    }

    public XContentBuilder endObject() throws IOException {
        this.generator.writeEndObject();
        return this;
    }

    public XContentBuilder startArray() throws IOException {
        this.generator.writeStartArray();
        return this;
    }

    public XContentBuilder startArray(String name) throws IOException {
        return this.field(name).startArray();
    }

    public XContentBuilder endArray() throws IOException {
        this.generator.writeEndArray();
        return this;
    }

    public XContentBuilder field(String name) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeFieldName(name);
        return this;
    }

    public XContentBuilder nullField(String name) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNullField(name);
        return this;
    }

    public XContentBuilder nullValue() throws IOException {
        this.generator.writeNull();
        return this;
    }

    public XContentBuilder field(String name, Boolean value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (boolean)value);
    }

    public XContentBuilder field(String name, boolean value) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeBooleanField(name, value);
        return this;
    }

    public XContentBuilder array(String name, boolean[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(boolean[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (boolean b : values) {
            this.value(b);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Boolean value) throws IOException {
        return value == null ? this.nullValue() : this.value((boolean)value);
    }

    public XContentBuilder value(boolean value) throws IOException {
        this.generator.writeBoolean(value);
        return this;
    }

    public XContentBuilder field(String name, Byte value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (byte)value);
    }

    public XContentBuilder field(String name, byte value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder value(Byte value) throws IOException {
        return value == null ? this.nullValue() : this.value((byte)value);
    }

    public XContentBuilder value(byte value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Double value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (double)value);
    }

    public XContentBuilder field(String name, double value) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNumberField(name, value);
        return this;
    }

    public XContentBuilder array(String name, double[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(double[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (double b : values) {
            this.value(b);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Double value) throws IOException {
        return value == null ? this.nullValue() : this.value((double)value);
    }

    public XContentBuilder value(double value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Float value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, value.floatValue());
    }

    public XContentBuilder field(String name, float value) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNumberField(name, value);
        return this;
    }

    public XContentBuilder array(String name, float[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(float[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (float f : values) {
            this.value(f);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Float value) throws IOException {
        return value == null ? this.nullValue() : this.value(value.floatValue());
    }

    public XContentBuilder value(float value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Integer value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (int)value);
    }

    public XContentBuilder field(String name, int value) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNumberField(name, value);
        return this;
    }

    public XContentBuilder array(String name, int[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(int[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (int i : values) {
            this.value(i);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Integer value) throws IOException {
        return value == null ? this.nullValue() : this.value((int)value);
    }

    public XContentBuilder value(int value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Long value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (long)value);
    }

    public XContentBuilder field(String name, long value) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNumberField(name, value);
        return this;
    }

    public XContentBuilder array(String name, long[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(long[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (long l : values) {
            this.value(l);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Long value) throws IOException {
        return value == null ? this.nullValue() : this.value((long)value);
    }

    public XContentBuilder value(long value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Short value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (short)value);
    }

    public XContentBuilder field(String name, short value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder array(String name, short[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(short[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (short s2 : values) {
            this.value(s2);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Short value) throws IOException {
        return value == null ? this.nullValue() : this.value((short)value);
    }

    public XContentBuilder value(short value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, String value) throws IOException {
        if (value == null) {
            return this.nullField(name);
        }
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeStringField(name, value);
        return this;
    }

    public XContentBuilder array(String name, String ... values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(String[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (String s2 : values) {
            this.value(s2);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeString(value);
        return this;
    }

    public XContentBuilder field(String name, byte[] value) throws IOException {
        if (value == null) {
            return this.nullField(name);
        }
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeBinaryField(name, value);
        return this;
    }

    public XContentBuilder value(byte[] value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeBinary(value);
        return this;
    }

    public XContentBuilder field(String name, byte[] value, int offset, int length) throws IOException {
        return this.field(name).value(value, offset, length);
    }

    public XContentBuilder value(byte[] value, int offset, int length) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeBinary(value, offset, length);
        return this;
    }

    public XContentBuilder field(String name, BytesRef value) throws IOException {
        return this.field(name).binaryValue(value);
    }

    public XContentBuilder utf8Field(String name, BytesRef value) throws IOException {
        return this.field(name).utf8Value(value);
    }

    public XContentBuilder binaryValue(BytesRef value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.value(value.bytes, value.offset, value.length);
        return this;
    }

    public XContentBuilder utf8Value(BytesRef value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeUTF8String(value.bytes, value.offset, value.length);
        return this;
    }

    public XContentBuilder field(String name, BytesReference value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder value(BytesReference value) throws IOException {
        return value == null ? this.nullValue() : this.binaryValue(value.toBytesRef());
    }

    public XContentBuilder field(String name, Text value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder value(Text value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        if (value.hasString()) {
            return this.value(value.string());
        }
        return this.utf8Value(value.bytes().toBytesRef());
    }

    public XContentBuilder field(String name, ReadableInstant value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder field(String name, ReadableInstant value, DateTimeFormatter formatter) throws IOException {
        return this.field(name).value(value, formatter);
    }

    public XContentBuilder value(ReadableInstant value) throws IOException {
        return this.value(value, DEFAULT_DATE_PRINTER);
    }

    public XContentBuilder value(ReadableInstant value, DateTimeFormatter formatter) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        XContentBuilder.ensureFormatterNotNull(formatter);
        return this.value(formatter.print(value));
    }

    public XContentBuilder field(String name, Date value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder field(String name, Date value, DateTimeFormatter formatter) throws IOException {
        return this.field(name).value(value, formatter);
    }

    public XContentBuilder value(Date value) throws IOException {
        return this.value(value, DEFAULT_DATE_PRINTER);
    }

    public XContentBuilder value(Date value, DateTimeFormatter formatter) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.value(formatter, value.getTime());
    }

    public XContentBuilder dateField(String name, String readableName, long value) throws IOException {
        if (this.humanReadable) {
            this.field(readableName).value(DEFAULT_DATE_PRINTER, value);
        }
        this.field(name, value);
        return this;
    }

    XContentBuilder value(Calendar value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.value(DEFAULT_DATE_PRINTER, value.getTimeInMillis());
    }

    XContentBuilder value(DateTimeFormatter formatter, long value) throws IOException {
        XContentBuilder.ensureFormatterNotNull(formatter);
        return this.value(formatter.print(value));
    }

    public XContentBuilder field(String name, GeoPoint value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder value(GeoPoint value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.latlon(value.getLat(), value.getLon());
    }

    public XContentBuilder latlon(String name, double lat, double lon) throws IOException {
        return this.field(name).latlon(lat, lon);
    }

    public XContentBuilder latlon(double lat, double lon) throws IOException {
        return this.startObject().field("lat", lat).field("lon", lon).endObject();
    }

    public XContentBuilder value(Path value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.value(value.toString());
    }

    public XContentBuilder field(String name, Object value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder array(String name, Object ... values) throws IOException {
        return this.field(name).values(values);
    }

    XContentBuilder values(Object[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        XContentBuilder.ensureNoSelfReferences(values);
        this.startArray();
        for (Object o : values) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Object value) throws IOException {
        this.unknownValue(value);
        return this;
    }

    private void unknownValue(Object value) throws IOException {
        if (value == null) {
            this.nullValue();
            return;
        }
        Writer writer = WRITERS.get(value.getClass());
        if (writer != null) {
            writer.write(this, value);
        } else if (value instanceof Path) {
            this.value((Path)value);
        } else if (value instanceof Map) {
            this.map((Map)value);
        } else if (value instanceof Iterable) {
            this.value((Iterable)value);
        } else if (value instanceof Object[]) {
            this.values((Object[])value);
        } else if (value instanceof Calendar) {
            this.value((Calendar)value);
        } else if (value instanceof ReadableInstant) {
            this.value((ReadableInstant)value);
        } else if (value instanceof BytesReference) {
            this.value((BytesReference)value);
        } else if (value instanceof ToXContent) {
            this.value((ToXContent)value);
        } else {
            this.value(Objects.toString(value));
        }
    }

    public XContentBuilder field(String name, ToXContent value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder field(String name, ToXContent value, ToXContent.Params params) throws IOException {
        return this.field(name).value(value, params);
    }

    private XContentBuilder value(ToXContent value) throws IOException {
        return this.value(value, ToXContent.EMPTY_PARAMS);
    }

    private XContentBuilder value(ToXContent value, ToXContent.Params params) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        value.toXContent(this, params);
        return this;
    }

    public XContentBuilder field(String name, Map<String, Object> values) throws IOException {
        return this.field(name).map(values);
    }

    public XContentBuilder map(Map<String, ?> values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        XContentBuilder.ensureNoSelfReferences(values);
        this.startObject();
        for (Map.Entry<String, ?> value : values.entrySet()) {
            this.field(value.getKey());
            this.unknownValue(value.getValue());
        }
        this.endObject();
        return this;
    }

    public XContentBuilder field(String name, Iterable<?> values) throws IOException {
        return this.field(name).value(values);
    }

    private XContentBuilder value(Iterable<?> values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        if (values instanceof Path) {
            this.value((Path)values);
        } else {
            XContentBuilder.ensureNoSelfReferences(values);
            this.startArray();
            for (Object value : values) {
                this.unknownValue(value);
            }
            this.endArray();
        }
        return this;
    }

    public XContentBuilder timeValueField(String rawFieldName, String readableFieldName, TimeValue timeValue) throws IOException {
        if (this.humanReadable) {
            this.field(readableFieldName, timeValue.toString());
        }
        this.field(rawFieldName, timeValue.millis());
        return this;
    }

    public XContentBuilder timeValueField(String rawFieldName, String readableFieldName, long rawTime) throws IOException {
        if (this.humanReadable) {
            this.field(readableFieldName, new TimeValue(rawTime).toString());
        }
        this.field(rawFieldName, rawTime);
        return this;
    }

    public XContentBuilder timeValueField(String rawFieldName, String readableFieldName, long rawTime, TimeUnit timeUnit) throws IOException {
        if (this.humanReadable) {
            this.field(readableFieldName, new TimeValue(rawTime, timeUnit).toString());
        }
        this.field(rawFieldName, rawTime);
        return this;
    }

    public XContentBuilder percentageField(String rawFieldName, String readableFieldName, double percentage) throws IOException {
        if (this.humanReadable) {
            this.field(readableFieldName, String.format(Locale.ROOT, "%1.1f%%", percentage));
        }
        this.field(rawFieldName, percentage);
        return this;
    }

    public XContentBuilder byteSizeField(String rawFieldName, String readableFieldName, ByteSizeValue byteSizeValue) throws IOException {
        if (this.humanReadable) {
            this.field(readableFieldName, byteSizeValue.toString());
        }
        this.field(rawFieldName, byteSizeValue.getBytes());
        return this;
    }

    public XContentBuilder byteSizeField(String rawFieldName, String readableFieldName, long rawSize) throws IOException {
        if (this.humanReadable) {
            this.field(readableFieldName, new ByteSizeValue(rawSize).toString());
        }
        this.field(rawFieldName, rawSize);
        return this;
    }

    @Deprecated
    public XContentBuilder rawField(String name, InputStream value) throws IOException {
        this.generator.writeRawField(name, value);
        return this;
    }

    public XContentBuilder rawField(String name, InputStream value, XContentType contentType) throws IOException {
        this.generator.writeRawField(name, value, contentType);
        return this;
    }

    @Deprecated
    public XContentBuilder rawField(String name, BytesReference value) throws IOException {
        this.generator.writeRawField(name, value);
        return this;
    }

    public XContentBuilder rawField(String name, BytesReference value, XContentType contentType) throws IOException {
        this.generator.writeRawField(name, value, contentType);
        return this;
    }

    @Deprecated
    public XContentBuilder rawValue(BytesReference value) throws IOException {
        this.generator.writeRawValue(value);
        return this;
    }

    public XContentBuilder rawValue(BytesReference value, XContentType contentType) throws IOException {
        this.generator.writeRawValue(value, contentType);
        return this;
    }

    public XContentBuilder copyCurrentStructure(XContentParser parser2) throws IOException {
        this.generator.copyCurrentStructure(parser2);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.generator.flush();
    }

    @Override
    public void close() {
        try {
            this.generator.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to close the XContentBuilder", e);
        }
    }

    public XContentGenerator generator() {
        return this.generator;
    }

    @Override
    public BytesReference bytes() {
        this.close();
        return ((BytesStream)((Object)this.bos)).bytes();
    }

    public String string() throws IOException {
        return this.bytes().utf8ToString();
    }

    static void ensureNameNotNull(String name) {
        XContentBuilder.ensureNotNull(name, "Field name cannot be null");
    }

    static void ensureFormatterNotNull(DateTimeFormatter formatter) {
        XContentBuilder.ensureNotNull(formatter, "DateTimeFormatter cannot be null");
    }

    static void ensureNotNull(Object value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
    }

    static void ensureNoSelfReferences(Object value) {
        XContentBuilder.ensureNoSelfReferences(value, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private static void ensureNoSelfReferences(Object value, Set<Object> ancestors) {
        if (value != null) {
            Iterable<Object> it;
            if (value instanceof Map) {
                it = ((Map)value).values();
            } else if (value instanceof Iterable && !(value instanceof Path)) {
                it = (Iterable)value;
            } else if (value instanceof Object[]) {
                it = Arrays.asList((Object[])value);
            } else {
                return;
            }
            if (!ancestors.add(value)) {
                throw new IllegalArgumentException("Object has already been built and is self-referencing itself");
            }
            for (Object o : it) {
                XContentBuilder.ensureNoSelfReferences(o, ancestors);
            }
            ancestors.remove(value);
        }
    }

    static {
        HashMap<Class<Text>, Writer> writers = new HashMap<Class<Text>, Writer>();
        writers.put(Boolean.class, (b, v) -> b.value((Boolean)v));
        writers.put(Byte.class, (b, v) -> b.value((Byte)v));
        writers.put(byte[].class, (b, v) -> b.value((byte[])v));
        writers.put(BytesRef.class, (b, v) -> b.binaryValue((BytesRef)v));
        writers.put(Date.class, (b, v) -> b.value((Date)v));
        writers.put(Double.class, (b, v) -> b.value((Double)v));
        writers.put(double[].class, (b, v) -> b.values((double[])v));
        writers.put(Float.class, (b, v) -> b.value((Float)v));
        writers.put(float[].class, (b, v) -> b.values((float[])v));
        writers.put(GeoPoint.class, (b, v) -> b.value((GeoPoint)v));
        writers.put(Integer.class, (b, v) -> b.value((Integer)v));
        writers.put(int[].class, (b, v) -> b.values((int[])v));
        writers.put(Long.class, (b, v) -> b.value((Long)v));
        writers.put(long[].class, (b, v) -> b.values((long[])v));
        writers.put(Short.class, (b, v) -> b.value((Short)v));
        writers.put(short[].class, (b, v) -> b.values((short[])v));
        writers.put(String.class, (b, v) -> b.value((String)v));
        writers.put(String[].class, (b, v) -> b.values((String[])v));
        writers.put(Text.class, (b, v) -> b.value((Text)v));
        WRITERS = Collections.unmodifiableMap(writers);
    }

    @FunctionalInterface
    private static interface Writer {
        public void write(XContentBuilder var1, Object var2) throws IOException;
    }
}

