/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public abstract class AbstractObjectParser<Value, Context>
implements BiFunction<XContentParser, Context, Value>,
ContextParser<Context, Value> {
    public abstract <T> void declareField(BiConsumer<Value, T> var1, ContextParser<Context, T> var2, ParseField var3, ObjectParser.ValueType var4);

    public <T> void declareField(BiConsumer<Value, T> consumer, CheckedFunction<XContentParser, T, IOException> parser2, ParseField parseField, ObjectParser.ValueType type) {
        if (parser2 == null) {
            throw new IllegalArgumentException("[parser] is required");
        }
        this.declareField(consumer, (XContentParser p, Context c) -> parser2.apply(p), parseField, type);
    }

    public <T> void declareObject(BiConsumer<Value, T> consumer, ContextParser<Context, T> objectParser, ParseField field) {
        this.declareField(consumer, (XContentParser p, Context c) -> objectParser.parse(p, c), field, ObjectParser.ValueType.OBJECT);
    }

    public void declareFloat(BiConsumer<Value, Float> consumer, ParseField field) {
        this.declareField(consumer, (XContentParser p) -> Float.valueOf(p.floatValue()), field, ObjectParser.ValueType.FLOAT);
    }

    public void declareDouble(BiConsumer<Value, Double> consumer, ParseField field) {
        this.declareField(consumer, (XContentParser p) -> p.doubleValue(), field, ObjectParser.ValueType.DOUBLE);
    }

    public void declareLong(BiConsumer<Value, Long> consumer, ParseField field) {
        this.declareField(consumer, (XContentParser p) -> p.longValue(), field, ObjectParser.ValueType.LONG);
    }

    public void declareInt(BiConsumer<Value, Integer> consumer, ParseField field) {
        this.declareField(consumer, (XContentParser p) -> p.intValue(), field, ObjectParser.ValueType.INT);
    }

    public void declareString(BiConsumer<Value, String> consumer, ParseField field) {
        this.declareField(consumer, XContentParser::text, field, ObjectParser.ValueType.STRING);
    }

    public void declareStringOrNull(BiConsumer<Value, String> consumer, ParseField field) {
        this.declareField(consumer, (XContentParser p) -> p.currentToken() == XContentParser.Token.VALUE_NULL ? null : p.text(), field, ObjectParser.ValueType.STRING_OR_NULL);
    }

    public void declareBoolean(BiConsumer<Value, Boolean> consumer, ParseField field) {
        this.declareField(consumer, XContentParser::booleanValue, field, ObjectParser.ValueType.BOOLEAN);
    }

    public <T> void declareObjectArray(BiConsumer<Value, List<T>> consumer, ContextParser<Context, T> objectParser, ParseField field) {
        this.declareField(consumer, (XContentParser p, Context c) -> AbstractObjectParser.parseArray(p, () -> objectParser.parse(p, c)), field, ObjectParser.ValueType.OBJECT_ARRAY);
    }

    public void declareStringArray(BiConsumer<Value, List<String>> consumer, ParseField field) {
        this.declareField(consumer, (XContentParser p, Context c) -> AbstractObjectParser.parseArray(p, p::text), field, ObjectParser.ValueType.STRING_ARRAY);
    }

    public void declareDoubleArray(BiConsumer<Value, List<Double>> consumer, ParseField field) {
        this.declareField(consumer, (XContentParser p, Context c) -> AbstractObjectParser.parseArray(p, p::doubleValue), field, ObjectParser.ValueType.DOUBLE_ARRAY);
    }

    public void declareFloatArray(BiConsumer<Value, List<Float>> consumer, ParseField field) {
        this.declareField(consumer, (XContentParser p, Context c) -> AbstractObjectParser.parseArray(p, p::floatValue), field, ObjectParser.ValueType.FLOAT_ARRAY);
    }

    public void declareLongArray(BiConsumer<Value, List<Long>> consumer, ParseField field) {
        this.declareField(consumer, (XContentParser p, Context c) -> AbstractObjectParser.parseArray(p, p::longValue), field, ObjectParser.ValueType.LONG_ARRAY);
    }

    public void declareIntArray(BiConsumer<Value, List<Integer>> consumer, ParseField field) {
        this.declareField(consumer, (XContentParser p, Context c) -> AbstractObjectParser.parseArray(p, p::intValue), field, ObjectParser.ValueType.INT_ARRAY);
    }

    public void declareRawObject(BiConsumer<Value, BytesReference> consumer, ParseField field) {
        CheckedFunction bytesParser = p -> {
            try (XContentBuilder builder = JsonXContent.contentBuilder();){
                builder.prettyPrint();
                builder.copyCurrentStructure((XContentParser)p);
                BytesReference bytesReference = builder.bytes();
                return bytesReference;
            }
        };
        this.declareField(consumer, bytesParser, field, ObjectParser.ValueType.OBJECT);
    }

    private static <T> List<T> parseArray(XContentParser parser2, IOSupplier<T> supplier) throws IOException {
        ArrayList<T> list = new ArrayList<T>();
        if (parser2.currentToken().isValue() || parser2.currentToken() == XContentParser.Token.START_OBJECT) {
            list.add(supplier.get());
        } else {
            while (parser2.nextToken() != XContentParser.Token.END_ARRAY) {
                if (parser2.currentToken().isValue() || parser2.currentToken() == XContentParser.Token.START_OBJECT) {
                    list.add(supplier.get());
                    continue;
                }
                throw new IllegalStateException("expected value but got [" + (Object)((Object)parser2.currentToken()) + "]");
            }
        }
        return list;
    }

    private static interface IOSupplier<T> {
        public T get() throws IOException;
    }
}

