/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.uid;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.common.lucene.uid.PerThreadIDAndVersionLookup;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public class VersionsResolver {
    static final ConcurrentMap<Object, CloseableThreadLocal<PerThreadIDAndVersionLookup>> lookupStates = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private static final LeafReader.CoreClosedListener removeLookupState = key -> {
        CloseableThreadLocal ctl = (CloseableThreadLocal)lookupStates.remove(key);
        if (ctl != null) {
            ctl.close();
        }
    };

    private static PerThreadIDAndVersionLookup getLookupState(LeafReader reader) throws IOException {
        PerThreadIDAndVersionLookup lookupState;
        Object key = reader.getCoreCacheKey();
        CloseableThreadLocal ctl = (CloseableThreadLocal)lookupStates.get(key);
        if (ctl == null) {
            ctl = new CloseableThreadLocal();
            CloseableThreadLocal other = lookupStates.putIfAbsent(key, (CloseableThreadLocal<PerThreadIDAndVersionLookup>)ctl);
            if (other == null) {
                reader.addCoreClosedListener(removeLookupState);
            } else {
                ctl = other;
            }
        }
        if ((lookupState = (PerThreadIDAndVersionLookup)ctl.get()) == null) {
            lookupState = new PerThreadIDAndVersionLookup(reader);
            ctl.set((Object)lookupState);
        }
        return lookupState;
    }

    private VersionsResolver() {
    }

    public static DocIdAndVersion loadDocIdAndVersion(IndexReader reader, Term term) throws IOException {
        assert (term.field().equals("_uid"));
        List leaves = reader.leaves();
        if (leaves.isEmpty()) {
            return null;
        }
        for (int i = leaves.size() - 1; i >= 0; --i) {
            LeafReaderContext context = (LeafReaderContext)leaves.get(i);
            LeafReader leaf = context.reader();
            PerThreadIDAndVersionLookup lookup = VersionsResolver.getLookupState(leaf);
            DocIdAndVersion result = lookup.lookupVersion(term.bytes(), leaf.getLiveDocs(), context);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static long loadVersion(IndexReader reader, Term term) throws IOException {
        DocIdAndVersion docIdAndVersion = VersionsResolver.loadDocIdAndVersion(reader, term);
        return docIdAndVersion == null ? -1L : docIdAndVersion.version;
    }

    public static class DocIdAndVersion {
        public final int docId;
        public final long version;
        public final LeafReaderContext context;

        public DocIdAndVersion(int docId, long version2, LeafReaderContext context) {
            this.docId = docId;
            this.version = version2;
            this.context = context;
        }
    }
}

