/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;

public class IndexTemplateMetaData
extends AbstractDiffable<IndexTemplateMetaData> {
    private final String name;
    private final int order;
    @Nullable
    private final Integer version;
    private final String template;
    private final Settings settings;
    private final ImmutableOpenMap<String, CompressedXContent> mappings;
    private final ImmutableOpenMap<String, AliasMetaData> aliases;
    private final ImmutableOpenMap<String, IndexMetaData.Custom> customs;

    public IndexTemplateMetaData(String name, int order, Integer version2, String template, Settings settings, ImmutableOpenMap<String, CompressedXContent> mappings, ImmutableOpenMap<String, AliasMetaData> aliases, ImmutableOpenMap<String, IndexMetaData.Custom> customs) {
        this.name = name;
        this.order = order;
        this.version = version2;
        this.template = template;
        this.settings = settings;
        this.mappings = mappings;
        this.aliases = aliases;
        this.customs = customs;
    }

    public String name() {
        return this.name;
    }

    public int order() {
        return this.order;
    }

    public int getOrder() {
        return this.order();
    }

    @Nullable
    public Integer getVersion() {
        return this.version();
    }

    @Nullable
    public Integer version() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String template() {
        return this.template;
    }

    public String getTemplate() {
        return this.template;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings getSettings() {
        return this.settings();
    }

    public ImmutableOpenMap<String, CompressedXContent> mappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, CompressedXContent> getMappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, AliasMetaData> aliases() {
        return this.aliases;
    }

    public ImmutableOpenMap<String, AliasMetaData> getAliases() {
        return this.aliases;
    }

    public ImmutableOpenMap<String, IndexMetaData.Custom> customs() {
        return this.customs;
    }

    public ImmutableOpenMap<String, IndexMetaData.Custom> getCustoms() {
        return this.customs;
    }

    public <T extends IndexMetaData.Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexTemplateMetaData that = (IndexTemplateMetaData)o;
        if (this.order != that.order) {
            return false;
        }
        if (!this.mappings.equals(that.mappings)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        if (!this.template.equals(that.template)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.order;
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + this.template.hashCode();
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + this.mappings.hashCode();
        return result;
    }

    public static IndexTemplateMetaData readFrom(StreamInput in) throws IOException {
        Builder builder = new Builder(in.readString());
        builder.order(in.readInt());
        builder.template(in.readString());
        builder.settings(Settings.readSettingsFromStream(in));
        int mappingsSize = in.readVInt();
        for (int i = 0; i < mappingsSize; ++i) {
            builder.putMapping(in.readString(), CompressedXContent.readCompressedString(in));
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            AliasMetaData aliasMd = new AliasMetaData(in);
            builder.putAlias(aliasMd);
        }
        int customSize = in.readVInt();
        for (int i = 0; i < customSize; ++i) {
            String type = in.readString();
            IndexMetaData.Custom customIndexMetaData = IndexMetaData.lookupPrototypeSafe(type).readFrom(in);
            builder.putCustom(type, customIndexMetaData);
        }
        if (in.getVersion().onOrAfter(Version.V_5_0_0_beta1)) {
            builder.version(in.readOptionalVInt());
        }
        return builder.build();
    }

    public static Diff<IndexTemplateMetaData> readDiffFrom(StreamInput in) throws IOException {
        return IndexTemplateMetaData.readDiffFrom(IndexTemplateMetaData::readFrom, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeInt(this.order);
        out.writeString(this.template);
        Settings.writeSettingsToStream(this.settings, out);
        out.writeVInt(this.mappings.size());
        for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : this.mappings) {
            out.writeString((String)objectObjectCursor.key);
            ((CompressedXContent)objectObjectCursor.value).writeTo(out);
        }
        out.writeVInt(this.aliases.size());
        for (ObjectCursor objectCursor : this.aliases.values()) {
            ((AliasMetaData)objectCursor.value).writeTo(out);
        }
        out.writeVInt(this.customs.size());
        for (ObjectObjectCursor objectObjectCursor : this.customs) {
            out.writeString((String)objectObjectCursor.key);
            ((IndexMetaData.Custom)objectObjectCursor.value).writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_5_0_0_beta1)) {
            out.writeOptionalVInt(this.version);
        }
    }

    public static class Builder {
        private static final Set<String> VALID_FIELDS = Sets.newHashSet("template", "order", "mappings", "settings");
        private String name;
        private int order;
        private Integer version;
        private String template;
        private Settings settings = Settings.Builder.EMPTY_SETTINGS;
        private final ImmutableOpenMap.Builder<String, CompressedXContent> mappings;
        private final ImmutableOpenMap.Builder<String, AliasMetaData> aliases;
        private final ImmutableOpenMap.Builder<String, IndexMetaData.Custom> customs;

        public Builder(String name) {
            this.name = name;
            this.mappings = ImmutableOpenMap.builder();
            this.aliases = ImmutableOpenMap.builder();
            this.customs = ImmutableOpenMap.builder();
        }

        public Builder(IndexTemplateMetaData indexTemplateMetaData) {
            this.name = indexTemplateMetaData.name();
            this.order(indexTemplateMetaData.order());
            this.version(indexTemplateMetaData.version());
            this.template(indexTemplateMetaData.template());
            this.settings(indexTemplateMetaData.settings());
            this.mappings = ImmutableOpenMap.builder(indexTemplateMetaData.mappings());
            this.aliases = ImmutableOpenMap.builder(indexTemplateMetaData.aliases());
            this.customs = ImmutableOpenMap.builder(indexTemplateMetaData.customs());
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder version(Integer version2) {
            this.version = version2;
            return this;
        }

        public Builder template(String template) {
            this.template = template;
            return this;
        }

        public String template() {
            return this.template;
        }

        public Builder settings(Settings.Builder settings) {
            this.settings = settings.build();
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder removeMapping(String mappingType) {
            this.mappings.remove(mappingType);
            return this;
        }

        public Builder putMapping(String mappingType, CompressedXContent mappingSource) throws IOException {
            this.mappings.put(mappingType, mappingSource);
            return this;
        }

        public Builder putMapping(String mappingType, String mappingSource) throws IOException {
            this.mappings.put(mappingType, new CompressedXContent(mappingSource));
            return this;
        }

        public Builder putAlias(AliasMetaData aliasMetaData) {
            this.aliases.put(aliasMetaData.alias(), aliasMetaData);
            return this;
        }

        public Builder putAlias(AliasMetaData.Builder aliasMetaData) {
            this.aliases.put(aliasMetaData.alias(), aliasMetaData.build());
            return this;
        }

        public Builder putCustom(String type, IndexMetaData.Custom customIndexMetaData) {
            this.customs.put(type, customIndexMetaData);
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public IndexMetaData.Custom getCustom(String type) {
            return this.customs.get(type);
        }

        public IndexTemplateMetaData build() {
            return new IndexTemplateMetaData(this.name, this.order, this.version, this.template, this.settings, this.mappings.build(), this.aliases.build(), this.customs.build());
        }

        public static void toXContent(IndexTemplateMetaData indexTemplateMetaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(indexTemplateMetaData.name());
            builder.field("order", indexTemplateMetaData.order());
            if (indexTemplateMetaData.version() != null) {
                builder.field("version", indexTemplateMetaData.version());
            }
            builder.field("template", indexTemplateMetaData.template());
            builder.startObject("settings");
            indexTemplateMetaData.settings().toXContent(builder, params);
            builder.endObject();
            if (params.paramAsBoolean("reduce_mappings", false)) {
                builder.startObject("mappings");
                for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : indexTemplateMetaData.mappings()) {
                    byte[] mappingSource = ((CompressedXContent)objectObjectCursor.value).uncompressed();
                    Map mapping = XContentHelper.convertToMap(new BytesArray(mappingSource), false).v2();
                    if (mapping.size() == 1 && mapping.containsKey(objectObjectCursor.key)) {
                        mapping = (Map)mapping.get(objectObjectCursor.key);
                    }
                    builder.field((String)objectObjectCursor.key);
                    builder.map(mapping);
                }
                builder.endObject();
            } else {
                builder.startArray("mappings");
                for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : indexTemplateMetaData.mappings()) {
                    byte[] data = ((CompressedXContent)objectObjectCursor.value).uncompressed();
                    builder.map(XContentHelper.convertToMap(new BytesArray(data), true).v2());
                }
                builder.endArray();
            }
            for (ObjectObjectCursor<String, Object> objectObjectCursor : indexTemplateMetaData.customs()) {
                builder.startObject((String)objectObjectCursor.key);
                ((IndexMetaData.Custom)objectObjectCursor.value).toXContent(builder, params);
                builder.endObject();
            }
            builder.startObject("aliases");
            for (ObjectCursor objectCursor : indexTemplateMetaData.aliases().values()) {
                AliasMetaData.Builder.toXContent((AliasMetaData)objectCursor.value, builder, params);
            }
            builder.endObject();
            builder.endObject();
        }

        public static IndexTemplateMetaData fromXContent(XContentParser parser2, String templateName) throws IOException {
            XContentParser.Token token;
            Builder builder = new Builder(templateName);
            String currentFieldName = Builder.skipTemplateName(parser2);
            while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser2.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("settings".equals(currentFieldName)) {
                        Settings.Builder templateSettingsBuilder = Settings.builder();
                        templateSettingsBuilder.put(SettingsLoader.Helper.loadNestedFromMap(parser2.mapOrdered())).normalizePrefix("index.");
                        builder.settings(templateSettingsBuilder.build());
                        continue;
                    }
                    if ("mappings".equals(currentFieldName)) {
                        while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser2.currentName();
                                continue;
                            }
                            if (token != XContentParser.Token.START_OBJECT) continue;
                            String mappingType = currentFieldName;
                            Map<String, Map<String, Object>> mappingSource = MapBuilder.newMapBuilder().put(mappingType, parser2.mapOrdered()).map();
                            builder.putMapping(mappingType, XContentFactory.jsonBuilder().map(mappingSource).string());
                        }
                        continue;
                    }
                    if ("aliases".equals(currentFieldName)) {
                        while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.putAlias(AliasMetaData.Builder.fromXContent(parser2));
                        }
                        continue;
                    }
                    Object proto = IndexMetaData.lookupPrototype(currentFieldName);
                    if (proto == null) {
                        parser2.skipChildren();
                        continue;
                    }
                    IndexMetaData.Custom custom = proto.fromXContent(parser2);
                    builder.putCustom(custom.type(), custom);
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (!"mappings".equals(currentFieldName)) continue;
                    while ((token = parser2.nextToken()) != XContentParser.Token.END_ARRAY) {
                        Map<String, Object> mapping = parser2.mapOrdered();
                        if (mapping.size() != 1) continue;
                        String mappingType = mapping.keySet().iterator().next();
                        String mappingSource = XContentFactory.jsonBuilder().map(mapping).string();
                        if (mappingSource == null) continue;
                        builder.putMapping(mappingType, mappingSource);
                    }
                    continue;
                }
                if (!token.isValue()) continue;
                if ("template".equals(currentFieldName)) {
                    builder.template(parser2.text());
                    continue;
                }
                if ("order".equals(currentFieldName)) {
                    builder.order(parser2.intValue());
                    continue;
                }
                if (!"version".equals(currentFieldName)) continue;
                builder.version(parser2.intValue());
            }
            return builder.build();
        }

        private static String skipTemplateName(XContentParser parser2) throws IOException {
            XContentParser.Token token = parser2.nextToken();
            if (token != null && token == XContentParser.Token.START_OBJECT && (token = parser2.nextToken()) == XContentParser.Token.FIELD_NAME) {
                String currentFieldName = parser2.currentName();
                if (VALID_FIELDS.contains(currentFieldName)) {
                    return currentFieldName;
                }
                parser2.nextToken();
            }
            return null;
        }

        static {
            VALID_FIELDS.addAll(IndexMetaData.customPrototypes.keySet());
        }
    }
}

