/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.IncompatibleClusterStateVersionException;
import org.elasticsearch.cluster.NamedDiffable;
import org.elasticsearch.cluster.NamedDiffableValueSerializer;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;

public class ClusterState
implements ToXContent,
Diffable<ClusterState> {
    public static final ClusterState EMPTY_STATE = ClusterState.builder(ClusterName.CLUSTER_NAME_SETTING.getDefault(Settings.EMPTY)).build();
    private static final NamedDiffableValueSerializer<Custom> CUSTOM_VALUE_SERIALIZER = new NamedDiffableValueSerializer<Custom>(Custom.class);
    public static final String UNKNOWN_UUID = "_na_";
    public static final long UNKNOWN_VERSION = -1L;
    private final long version;
    private final String stateUUID;
    private final RoutingTable routingTable;
    private final DiscoveryNodes nodes;
    private final MetaData metaData;
    private final ClusterBlocks blocks;
    private final ImmutableOpenMap<String, Custom> customs;
    private final ClusterName clusterName;
    private final boolean wasReadFromDiff;
    private volatile RoutingNodes routingNodes;

    public ClusterState(long version2, String stateUUID, ClusterState state) {
        this(state.clusterName, version2, stateUUID, state.metaData(), state.routingTable(), state.nodes(), state.blocks(), state.customs(), false);
    }

    public ClusterState(ClusterName clusterName, long version2, String stateUUID, MetaData metaData, RoutingTable routingTable, DiscoveryNodes nodes, ClusterBlocks blocks, ImmutableOpenMap<String, Custom> customs, boolean wasReadFromDiff) {
        this.version = version2;
        this.stateUUID = stateUUID;
        this.clusterName = clusterName;
        this.metaData = metaData;
        this.routingTable = routingTable;
        this.nodes = nodes;
        this.blocks = blocks;
        this.customs = customs;
        this.wasReadFromDiff = wasReadFromDiff;
    }

    public long version() {
        return this.version;
    }

    public long getVersion() {
        return this.version();
    }

    public String stateUUID() {
        return this.stateUUID;
    }

    public DiscoveryNodes nodes() {
        return this.nodes;
    }

    public DiscoveryNodes getNodes() {
        return this.nodes();
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public MetaData getMetaData() {
        return this.metaData();
    }

    public RoutingTable routingTable() {
        return this.routingTable;
    }

    public RoutingTable getRoutingTable() {
        return this.routingTable();
    }

    public ClusterBlocks blocks() {
        return this.blocks;
    }

    public ClusterBlocks getBlocks() {
        return this.blocks;
    }

    public ImmutableOpenMap<String, Custom> customs() {
        return this.customs;
    }

    public ImmutableOpenMap<String, Custom> getCustoms() {
        return this.customs;
    }

    public <T extends Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public boolean wasReadFromDiff() {
        return this.wasReadFromDiff;
    }

    public RoutingNodes getRoutingNodes() {
        if (this.routingNodes != null) {
            return this.routingNodes;
        }
        this.routingNodes = new RoutingNodes(this);
        return this.routingNodes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("cluster uuid: ").append(this.metaData.clusterUUID()).append("\n");
        sb.append("version: ").append(this.version).append("\n");
        sb.append("state uuid: ").append(this.stateUUID).append("\n");
        sb.append("from_diff: ").append(this.wasReadFromDiff).append("\n");
        sb.append("meta data version: ").append(this.metaData.version()).append("\n");
        String TAB = "   ";
        for (IndexMetaData indexMetaData : this.metaData) {
            sb.append("   ").append(indexMetaData.getIndex());
            sb.append(": v[").append(indexMetaData.getVersion()).append("]\n");
            for (int shard = 0; shard < indexMetaData.getNumberOfShards(); ++shard) {
                sb.append("   ").append("   ").append(shard).append(": ");
                sb.append("p_term [").append(indexMetaData.primaryTerm(shard)).append("], ");
                sb.append("isa_ids ").append(indexMetaData.inSyncAllocationIds(shard)).append("\n");
            }
        }
        sb.append(this.blocks());
        sb.append(this.nodes());
        sb.append(this.routingTable());
        sb.append(this.getRoutingNodes());
        if (!this.customs.isEmpty()) {
            sb.append("customs:\n");
            for (ObjectObjectCursor objectObjectCursor : this.customs) {
                String type = (String)objectObjectCursor.key;
                Custom custom = (Custom)objectObjectCursor.value;
                sb.append("   ").append(type).append(": ").append(custom);
            }
        }
        return sb.toString();
    }

    public boolean supersedes(ClusterState other) {
        return this.nodes().getMasterNodeId() != null && this.nodes().getMasterNodeId().equals(other.nodes().getMasterNodeId()) && this.version() > other.version();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        EnumSet<Metric> metrics = Metric.parseString(params.param("metric", "_all"), true);
        if (metrics.contains((Object)Metric.VERSION)) {
            builder.field("version", this.version);
            builder.field("state_uuid", this.stateUUID);
        }
        if (metrics.contains((Object)Metric.MASTER_NODE)) {
            builder.field("master_node", this.nodes().getMasterNodeId());
        }
        if (metrics.contains((Object)Metric.BLOCKS)) {
            builder.startObject("blocks");
            if (!this.blocks().global().isEmpty()) {
                builder.startObject("global");
                for (ClusterBlock clusterBlock : this.blocks().global()) {
                    clusterBlock.toXContent(builder, params);
                }
                builder.endObject();
            }
            if (!this.blocks().indices().isEmpty()) {
                builder.startObject("indices");
                for (ObjectObjectCursor objectObjectCursor : this.blocks().indices()) {
                    builder.startObject((String)objectObjectCursor.key);
                    for (ClusterBlock block : (Set)objectObjectCursor.value) {
                        block.toXContent(builder, params);
                    }
                    builder.endObject();
                }
                builder.endObject();
            }
            builder.endObject();
        }
        if (metrics.contains((Object)Metric.NODES)) {
            builder.startObject("nodes");
            for (DiscoveryNode discoveryNode : this.nodes) {
                discoveryNode.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (metrics.contains((Object)Metric.METADATA)) {
            builder.startObject("metadata");
            builder.field("cluster_uuid", this.metaData().clusterUUID());
            builder.startObject("templates");
            for (ObjectCursor objectCursor : this.metaData().templates().values()) {
                IndexTemplateMetaData templateMetaData = (IndexTemplateMetaData)objectCursor.value;
                builder.startObject(templateMetaData.name());
                builder.field("template", templateMetaData.template());
                builder.field("order", templateMetaData.order());
                builder.startObject("settings");
                Iterator settings = templateMetaData.settings();
                ((Settings)((Object)settings)).toXContent(builder, params);
                builder.endObject();
                builder.startObject("mappings");
                for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : templateMetaData.mappings()) {
                    Map mapping = XContentHelper.convertToMap(new BytesArray(((CompressedXContent)objectObjectCursor.value).uncompressed()), false).v2();
                    if (mapping.size() == 1 && mapping.containsKey(objectObjectCursor.key)) {
                        mapping = (Map)mapping.get(objectObjectCursor.key);
                    }
                    builder.field((String)objectObjectCursor.key);
                    builder.map(mapping);
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endObject();
            builder.startObject("indices");
            for (IndexMetaData indexMetaData : this.metaData()) {
                builder.startObject(indexMetaData.getIndex().getName());
                builder.field("state", indexMetaData.getState().toString().toLowerCase(Locale.ENGLISH));
                builder.startObject("settings");
                Settings settings = indexMetaData.getSettings();
                settings.toXContent(builder, params);
                builder.endObject();
                builder.startObject("mappings");
                for (ObjectObjectCursor objectObjectCursor : indexMetaData.getMappings()) {
                    void var9_38;
                    Map<String, Object> map = XContentHelper.convertToMap(new BytesArray(((MappingMetaData)objectObjectCursor.value).source().uncompressed()), false).v2();
                    if (map.size() == 1 && map.containsKey(objectObjectCursor.key)) {
                        Map map2 = (Map)map.get(objectObjectCursor.key);
                    }
                    builder.field((String)objectObjectCursor.key);
                    builder.map((Map<String, ?>)var9_38);
                }
                builder.endObject();
                builder.startArray("aliases");
                for (ObjectCursor objectCursor : indexMetaData.getAliases().keys()) {
                    builder.value((String)objectCursor.value);
                }
                builder.endArray();
                builder.startObject("primary_terms");
                for (int shard = 0; shard < indexMetaData.getNumberOfShards(); ++shard) {
                    builder.field(Integer.toString(shard), indexMetaData.primaryTerm(shard));
                }
                builder.endObject();
                builder.startObject("in_sync_allocations");
                for (IntObjectCursor<Set<String>> intObjectCursor : indexMetaData.getInSyncAllocationIds()) {
                    builder.startArray(String.valueOf(intObjectCursor.key));
                    for (String allocationId : (Set)intObjectCursor.value) {
                        builder.value(allocationId);
                    }
                    builder.endArray();
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endObject();
            for (ObjectObjectCursor objectObjectCursor : this.metaData.customs()) {
                builder.startObject((String)objectObjectCursor.key);
                ((MetaData.Custom)objectObjectCursor.value).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        if (metrics.contains((Object)Metric.ROUTING_TABLE)) {
            builder.startObject("routing_table");
            builder.startObject("indices");
            for (IndexRoutingTable indexRoutingTable : this.routingTable()) {
                builder.startObject(indexRoutingTable.getIndex().getName());
                builder.startObject("shards");
                for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                    builder.startArray(Integer.toString(indexShardRoutingTable.shardId().id()));
                    for (ShardRouting shardRouting : indexShardRoutingTable) {
                        shardRouting.toXContent(builder, params);
                    }
                    builder.endArray();
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        if (metrics.contains((Object)Metric.ROUTING_NODES)) {
            builder.startObject("routing_nodes");
            builder.startArray("unassigned");
            for (ShardRouting shardRouting : this.getRoutingNodes().unassigned()) {
                shardRouting.toXContent(builder, params);
            }
            builder.endArray();
            builder.startObject("nodes");
            for (RoutingNode routingNode : this.getRoutingNodes()) {
                builder.startArray(routingNode.nodeId() == null ? "null" : routingNode.nodeId());
                for (ShardRouting shardRouting : routingNode) {
                    shardRouting.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            builder.endObject();
        }
        if (metrics.contains((Object)Metric.CUSTOMS)) {
            for (ObjectObjectCursor objectObjectCursor : this.customs) {
                builder.startObject((String)objectObjectCursor.key);
                ((Custom)objectObjectCursor.value).toXContent(builder, params);
                builder.endObject();
            }
        }
        return builder;
    }

    public static Builder builder(ClusterName clusterName) {
        return new Builder(clusterName);
    }

    public static Builder builder(ClusterState state) {
        return new Builder(state);
    }

    @Override
    public Diff<ClusterState> diff(ClusterState previousState) {
        return new ClusterStateDiff(previousState, this);
    }

    public static Diff<ClusterState> readDiffFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        return new ClusterStateDiff(in, localNode);
    }

    public static ClusterState readFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        ClusterName clusterName = new ClusterName(in);
        Builder builder = new Builder(clusterName);
        builder.version = in.readLong();
        builder.uuid = in.readString();
        builder.metaData = MetaData.readFrom(in);
        builder.routingTable = RoutingTable.readFrom(in);
        builder.nodes = DiscoveryNodes.readFrom(in, localNode);
        builder.blocks = new ClusterBlocks(in);
        int customSize = in.readVInt();
        for (int i = 0; i < customSize; ++i) {
            Custom customIndexMetaData = in.readNamedWriteable(Custom.class);
            builder.putCustom(customIndexMetaData.getWriteableName(), customIndexMetaData);
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.clusterName.writeTo(out);
        out.writeLong(this.version);
        out.writeString(this.stateUUID);
        this.metaData.writeTo(out);
        this.routingTable.writeTo(out);
        this.nodes.writeTo(out);
        this.blocks.writeTo(out);
        int numberOfCustoms = 0;
        for (ObjectCursor<Custom> objectCursor : this.customs.values()) {
            if (!out.getVersion().onOrAfter(((Custom)objectCursor.value).getMinimalSupportedVersion())) continue;
            ++numberOfCustoms;
        }
        out.writeVInt(numberOfCustoms);
        for (ObjectCursor<Custom> objectCursor : this.customs.values()) {
            if (!out.getVersion().onOrAfter(((Custom)objectCursor.value).getMinimalSupportedVersion())) continue;
            out.writeNamedWriteable((NamedWriteable)objectCursor.value);
        }
    }

    private static class ClusterStateDiff
    implements Diff<ClusterState> {
        private final long toVersion;
        private final String fromUuid;
        private final String toUuid;
        private final ClusterName clusterName;
        private final Diff<RoutingTable> routingTable;
        private final Diff<DiscoveryNodes> nodes;
        private final Diff<MetaData> metaData;
        private final Diff<ClusterBlocks> blocks;
        private final Diff<ImmutableOpenMap<String, Custom>> customs;

        ClusterStateDiff(ClusterState before, ClusterState after) {
            this.fromUuid = before.stateUUID;
            this.toUuid = after.stateUUID;
            this.toVersion = after.version;
            this.clusterName = after.clusterName;
            this.routingTable = after.routingTable.diff(before.routingTable);
            this.nodes = after.nodes.diff(before.nodes);
            this.metaData = after.metaData.diff(before.metaData);
            this.blocks = after.blocks.diff(before.blocks);
            this.customs = DiffableUtils.diff(before.customs, after.customs, DiffableUtils.getStringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
        }

        ClusterStateDiff(StreamInput in, DiscoveryNode localNode) throws IOException {
            this.clusterName = new ClusterName(in);
            this.fromUuid = in.readString();
            this.toUuid = in.readString();
            this.toVersion = in.readLong();
            this.routingTable = RoutingTable.readDiffFrom(in);
            this.nodes = DiscoveryNodes.readDiffFrom(in, localNode);
            this.metaData = MetaData.readDiffFrom(in);
            this.blocks = ClusterBlocks.readDiffFrom(in);
            this.customs = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.clusterName.writeTo(out);
            out.writeString(this.fromUuid);
            out.writeString(this.toUuid);
            out.writeLong(this.toVersion);
            this.routingTable.writeTo(out);
            this.nodes.writeTo(out);
            this.metaData.writeTo(out);
            this.blocks.writeTo(out);
            this.customs.writeTo(out);
        }

        @Override
        public ClusterState apply(ClusterState state) {
            Builder builder = new Builder(this.clusterName);
            if (this.toUuid.equals(state.stateUUID)) {
                return state;
            }
            if (!this.fromUuid.equals(state.stateUUID)) {
                throw new IncompatibleClusterStateVersionException(state.version, state.stateUUID, this.toVersion, this.fromUuid);
            }
            builder.stateUUID(this.toUuid);
            builder.version(this.toVersion);
            builder.routingTable(this.routingTable.apply(state.routingTable));
            builder.nodes(this.nodes.apply(state.nodes));
            builder.metaData(this.metaData.apply(state.metaData));
            builder.blocks(this.blocks.apply(state.blocks));
            builder.customs(this.customs.apply(state.customs));
            builder.fromDiff(true);
            return builder.build();
        }
    }

    public static class Builder {
        private final ClusterName clusterName;
        private long version = 0L;
        private String uuid = "_na_";
        private MetaData metaData = MetaData.EMPTY_META_DATA;
        private RoutingTable routingTable = RoutingTable.EMPTY_ROUTING_TABLE;
        private DiscoveryNodes nodes = DiscoveryNodes.EMPTY_NODES;
        private ClusterBlocks blocks = ClusterBlocks.EMPTY_CLUSTER_BLOCK;
        private final ImmutableOpenMap.Builder<String, Custom> customs;
        private boolean fromDiff;

        public Builder(ClusterState state) {
            this.clusterName = state.clusterName;
            this.version = state.version();
            this.uuid = state.stateUUID();
            this.nodes = state.nodes();
            this.routingTable = state.routingTable();
            this.metaData = state.metaData();
            this.blocks = state.blocks();
            this.customs = ImmutableOpenMap.builder(state.customs());
            this.fromDiff = false;
        }

        public Builder(ClusterName clusterName) {
            this.customs = ImmutableOpenMap.builder();
            this.clusterName = clusterName;
        }

        public Builder nodes(DiscoveryNodes.Builder nodesBuilder) {
            return this.nodes(nodesBuilder.build());
        }

        public Builder nodes(DiscoveryNodes nodes) {
            this.nodes = nodes;
            return this;
        }

        public DiscoveryNodes nodes() {
            return this.nodes;
        }

        public Builder routingTable(RoutingTable routingTable) {
            this.routingTable = routingTable;
            return this;
        }

        public Builder metaData(MetaData.Builder metaDataBuilder) {
            return this.metaData(metaDataBuilder.build());
        }

        public Builder metaData(MetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder blocks(ClusterBlocks.Builder blocksBuilder) {
            return this.blocks(blocksBuilder.build());
        }

        public Builder blocks(ClusterBlocks blocks) {
            this.blocks = blocks;
            return this;
        }

        public Builder version(long version2) {
            this.version = version2;
            return this;
        }

        public Builder incrementVersion() {
            ++this.version;
            this.uuid = ClusterState.UNKNOWN_UUID;
            return this;
        }

        public Builder stateUUID(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder putCustom(String type, Custom custom) {
            this.customs.put(type, custom);
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Builder customs(ImmutableOpenMap<String, Custom> customs) {
            this.customs.putAll(customs);
            return this;
        }

        public Builder fromDiff(boolean fromDiff) {
            this.fromDiff = fromDiff;
            return this;
        }

        public ClusterState build() {
            if (ClusterState.UNKNOWN_UUID.equals(this.uuid)) {
                this.uuid = UUIDs.randomBase64UUID();
            }
            return new ClusterState(this.clusterName, this.version, this.uuid, this.metaData, this.routingTable, this.nodes, this.blocks, this.customs.build(), this.fromDiff);
        }

        public static byte[] toBytes(ClusterState state) throws IOException {
            BytesStreamOutput os = new BytesStreamOutput();
            state.writeTo(os);
            return BytesReference.toBytes(os.bytes());
        }

        public static ClusterState fromBytes(byte[] data, DiscoveryNode localNode, NamedWriteableRegistry registry) throws IOException {
            NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(StreamInput.wrap(data), registry);
            return ClusterState.readFrom(in, localNode);
        }
    }

    public static enum Metric {
        VERSION("version"),
        MASTER_NODE("master_node"),
        BLOCKS("blocks"),
        NODES("nodes"),
        METADATA("metadata"),
        ROUTING_TABLE("routing_table"),
        ROUTING_NODES("routing_nodes"),
        CUSTOMS("customs");

        private static Map<String, Metric> valueToEnum;
        private final String value;

        private Metric(String value) {
            this.value = value;
        }

        public static EnumSet<Metric> parseString(String param, boolean ignoreUnknown) {
            String[] metrics = Strings.splitStringByCommaToArray(param);
            EnumSet<Metric> result = EnumSet.noneOf(Metric.class);
            for (String metric : metrics) {
                if ("_all".equals(metric)) {
                    result = EnumSet.allOf(Metric.class);
                    break;
                }
                Metric m3 = valueToEnum.get(metric);
                if (m3 == null) {
                    if (ignoreUnknown) continue;
                    throw new IllegalArgumentException("Unknown metric [" + metric + "]");
                }
                result.add(m3);
            }
            return result;
        }

        public String toString() {
            return this.value;
        }

        static {
            valueToEnum = new HashMap<String, Metric>();
            for (Metric metric : Metric.values()) {
                valueToEnum.put(metric.value, metric);
            }
        }
    }

    public static interface Custom
    extends NamedDiffable<Custom>,
    ToXContent {
    }
}

