/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.io.IOException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;

public class UpdateResponse
extends DocWriteResponse {
    private static final String GET = "get";
    private GetResult getResult;

    public UpdateResponse() {
    }

    public UpdateResponse(ShardId shardId, String type, String id, long version2, DocWriteResponse.Result result) {
        this(new ReplicationResponse.ShardInfo(0, 0, new ReplicationResponse.ShardInfo.Failure[0]), shardId, type, id, version2, result);
    }

    public UpdateResponse(ReplicationResponse.ShardInfo shardInfo, ShardId shardId, String type, String id, long version2, DocWriteResponse.Result result) {
        super(shardId, type, id, version2, result);
        this.setShardInfo(shardInfo);
    }

    public void setGetResult(GetResult getResult) {
        this.getResult = getResult;
    }

    public GetResult getGetResult() {
        return this.getResult;
    }

    @Override
    public RestStatus status() {
        return this.result == DocWriteResponse.Result.CREATED ? RestStatus.CREATED : super.status();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.readBoolean()) {
            this.getResult = GetResult.readGetResult(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.getResult == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.getResult.writeTo(out);
        }
    }

    @Override
    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerToXContent(builder, params);
        if (this.getGetResult() != null) {
            builder.startObject(GET);
            this.getGetResult().toXContentEmbedded(builder, params);
            builder.endObject();
        }
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UpdateResponse[");
        builder.append("index=").append(this.getIndex());
        builder.append(",type=").append(this.getType());
        builder.append(",id=").append(this.getId());
        builder.append(",version=").append(this.getVersion());
        builder.append(",result=").append(this.getResult().getLowercase());
        builder.append(",shards=").append(this.getShardInfo());
        return builder.append("]").toString();
    }

    public static UpdateResponse fromXContent(XContentParser parser2) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser2.nextToken(), parser2::getTokenLocation);
        Builder context = new Builder();
        while (parser2.nextToken() != XContentParser.Token.END_OBJECT) {
            UpdateResponse.parseXContentFields(parser2, context);
        }
        return context.build();
    }

    public static void parseXContentFields(XContentParser parser2, Builder context) throws IOException {
        XContentParser.Token token = parser2.currentToken();
        String currentFieldName = parser2.currentName();
        if (GET.equals(currentFieldName)) {
            if (token == XContentParser.Token.START_OBJECT) {
                context.setGetResult(GetResult.fromXContentEmbedded(parser2));
            }
        } else {
            DocWriteResponse.parseInnerToXContent(parser2, context);
        }
    }

    public static class Builder
    extends DocWriteResponse.Builder {
        private GetResult getResult = null;

        public void setGetResult(GetResult getResult) {
            this.getResult = getResult;
        }

        @Override
        public UpdateResponse build() {
            UpdateResponse update = this.shardInfo != null ? new UpdateResponse(this.shardInfo, this.shardId, this.type, this.id, this.version, this.result) : new UpdateResponse(this.shardId, this.type, this.id, this.version, this.result);
            if (this.getResult != null) {
                update.setGetResult(new GetResult(update.getIndex(), update.getType(), update.getId(), update.getVersion(), this.getResult.isExists(), this.getResult.internalSourceRef(), this.getResult.getFields()));
            }
            update.setForcedRefresh(this.forcedRefresh);
            return update;
        }
    }
}

