/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.index;

import java.io.IOException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;

public class IndexResponse
extends DocWriteResponse {
    private static final String CREATED = "created";

    public IndexResponse() {
    }

    public IndexResponse(ShardId shardId, String type, String id, long version2, boolean created) {
        super(shardId, type, id, version2, created ? DocWriteResponse.Result.CREATED : DocWriteResponse.Result.UPDATED);
    }

    @Override
    public RestStatus status() {
        return this.result == DocWriteResponse.Result.CREATED ? RestStatus.CREATED : super.status();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IndexResponse[");
        builder.append("index=").append(this.getIndex());
        builder.append(",type=").append(this.getType());
        builder.append(",id=").append(this.getId());
        builder.append(",version=").append(this.getVersion());
        builder.append(",result=").append(this.getResult().getLowercase());
        builder.append(",shards=").append(Strings.toString(this.getShardInfo()));
        return builder.append("]").toString();
    }

    @Override
    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerToXContent(builder, params);
        builder.field(CREATED, this.result == DocWriteResponse.Result.CREATED);
        return builder;
    }

    public static IndexResponse fromXContent(XContentParser parser2) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser2.nextToken(), parser2::getTokenLocation);
        Builder context = new Builder();
        while (parser2.nextToken() != XContentParser.Token.END_OBJECT) {
            IndexResponse.parseXContentFields(parser2, context);
        }
        return context.build();
    }

    public static void parseXContentFields(XContentParser parser2, Builder context) throws IOException {
        XContentParser.Token token = parser2.currentToken();
        String currentFieldName = parser2.currentName();
        if (CREATED.equals(currentFieldName)) {
            if (token.isValue()) {
                context.setCreated(parser2.booleanValue());
            }
        } else {
            DocWriteResponse.parseInnerToXContent(parser2, context);
        }
    }

    public static class Builder
    extends DocWriteResponse.Builder {
        private boolean created = false;

        public void setCreated(boolean created) {
            this.created = created;
        }

        @Override
        public IndexResponse build() {
            IndexResponse indexResponse = new IndexResponse(this.shardId, this.type, this.id, (long)this.version, this.created);
            indexResponse.setForcedRefresh(this.forcedRefresh);
            if (this.shardInfo != null) {
                indexResponse.setShardInfo(this.shardInfo);
            }
            return indexResponse;
        }
    }
}

