/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.action.admin.indices.rollover.MaxAgeCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxDocsCondition;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;

public class RolloverRequest
extends AcknowledgedRequest<RolloverRequest>
implements IndicesRequest {
    public static final ObjectParser<RolloverRequest, Void> PARSER = new ObjectParser("conditions", null);
    private String alias;
    private String newIndexName;
    private boolean dryRun;
    private Set<Condition> conditions = new HashSet<Condition>(2);
    private CreateIndexRequest createIndexRequest = new CreateIndexRequest("_na_");

    RolloverRequest() {
    }

    public RolloverRequest(String alias, String newIndexName) {
        this.alias = alias;
        this.newIndexName = newIndexName;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException;
        ActionRequestValidationException actionRequestValidationException = validationException = this.createIndexRequest == null ? null : this.createIndexRequest.validate();
        if (this.alias == null) {
            validationException = ValidateActions.addValidationError("index alias is missing", validationException);
        }
        if (this.createIndexRequest == null) {
            validationException = ValidateActions.addValidationError("create index request is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.alias = in.readString();
        this.newIndexName = in.readOptionalString();
        this.dryRun = in.readBoolean();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            this.conditions.add(in.readNamedWriteable(Condition.class));
        }
        this.createIndexRequest = new CreateIndexRequest();
        this.createIndexRequest.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.alias);
        out.writeOptionalString(this.newIndexName);
        out.writeBoolean(this.dryRun);
        out.writeVInt(this.conditions.size());
        for (Condition condition : this.conditions) {
            out.writeNamedWriteable(condition);
        }
        this.createIndexRequest.writeTo(out);
    }

    @Override
    public String[] indices() {
        return new String[]{this.alias};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setNewIndexName(String newIndexName) {
        this.newIndexName = newIndexName;
    }

    public void dryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void addMaxIndexAgeCondition(TimeValue age) {
        this.conditions.add(new MaxAgeCondition(age));
    }

    public void addMaxIndexDocsCondition(long numDocs) {
        this.conditions.add(new MaxDocsCondition(numDocs));
    }

    public void setCreateIndexRequest(CreateIndexRequest createIndexRequest) {
        this.createIndexRequest = Objects.requireNonNull(createIndexRequest, "create index request must not be null");
    }

    boolean isDryRun() {
        return this.dryRun;
    }

    Set<Condition> getConditions() {
        return this.conditions;
    }

    String getAlias() {
        return this.alias;
    }

    String getNewIndexName() {
        return this.newIndexName;
    }

    CreateIndexRequest getCreateIndexRequest() {
        return this.createIndexRequest;
    }

    public void setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.createIndexRequest.waitForActiveShards(waitForActiveShards);
    }

    public void setWaitForActiveShards(int waitForActiveShards) {
        this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    static {
        PARSER.declareField((parser2, request, context) -> Condition.PARSER.parse(parser2, request.conditions, null), new ParseField("conditions", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser2, request, context) -> request.createIndexRequest.settings(parser2.map()), new ParseField("settings", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser2, request, context) -> {
            for (Map.Entry<String, Object> mappingsEntry : parser2.map().entrySet()) {
                request.createIndexRequest.mapping(mappingsEntry.getKey(), (Map)mappingsEntry.getValue());
            }
        }, new ParseField("mappings", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser2, request, context) -> request.createIndexRequest.aliases(parser2.map()), new ParseField("aliases", new String[0]), ObjectParser.ValueType.OBJECT);
    }
}

