/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.UimaContextHolder;
import org.apache.uima.resource.CasManager;
import org.apache.uima.resource.ConfigurableDataResourceSpecifier;
import org.apache.uima.resource.ConfigurationManager;
import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.resource.FileLanguageResourceSpecifier;
import org.apache.uima.resource.FileResourceSpecifier;
import org.apache.uima.resource.RelativePathResolver;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.impl.RelativePathResolver_impl;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Logger;
import org.apache.uima.util.Settings;

public abstract class Resource_ImplBase
implements Resource {
    private ResourceMetaData mMetaData;
    private UimaContextAdmin mUimaContextAdmin;
    private boolean mInitialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initialize(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        Object configMgr;
        String name;
        ResourceMetaData metadata1 = this.getMetaData();
        String string = name = metadata1 == null ? this.getClass().getName() : metadata1.getName();
        if (this.mInitialized) {
            throw new UIMA_IllegalStateException("resource_already_initialized", new Object[]{name});
        }
        if (aAdditionalParams != null) {
            this.mUimaContextAdmin = (UimaContextAdmin)aAdditionalParams.get("UIMA_CONTEXT");
        }
        if (this.mUimaContextAdmin == null) {
            if (!(aSpecifier instanceof ConfigurableDataResourceSpecifier || aSpecifier instanceof FileLanguageResourceSpecifier || aSpecifier instanceof FileResourceSpecifier)) {
                ResourceManager resMgr = null;
                if (aAdditionalParams != null) {
                    resMgr = (ResourceManager)aAdditionalParams.get("RESOURCE_MANAGER");
                }
                if (resMgr == null) {
                    resMgr = UIMAFramework.newDefaultResourceManager();
                }
                Logger logger = UIMAFramework.getLogger(this.getClass());
                logger.setResourceManager(resMgr);
                configMgr = null;
                if (aAdditionalParams != null) {
                    configMgr = (ConfigurationManager)aAdditionalParams.get("CONFIG_MANAGER");
                }
                if (configMgr == null) {
                    configMgr = UIMAFramework.newConfigurationManager();
                }
                this.mUimaContextAdmin = UIMAFramework.newUimaContext(logger, resMgr, (ConfigurationManager)configMgr);
            }
        } else {
            Logger logger = UIMAFramework.getLogger(this.getClass());
            logger.setResourceManager(this.mUimaContextAdmin.getResourceManager());
            this.mUimaContextAdmin.setLogger(logger);
        }
        if (aSpecifier instanceof ResourceCreationSpecifier) {
            ExternalResourceDependency[] resourceDependencies;
            Settings externalOverrides;
            ResourceMetaData metadata = ((ResourceCreationSpecifier)aSpecifier).getMetaData();
            name = metadata.getName();
            try {
                metadata.resolveImports(this.getResourceManager());
            }
            catch (InvalidXMLException e) {
                throw new ResourceInitializationException(e);
            }
            this.setMetaData(metadata);
            Settings settings = externalOverrides = aAdditionalParams == null ? null : (Settings)aAdditionalParams.get("EXTERNAL_OVERRIDE_SETTINGS");
            if (externalOverrides != null) {
                this.mUimaContextAdmin.setExternalOverrides(externalOverrides);
            } else {
                configMgr = this.mUimaContextAdmin;
                synchronized (configMgr) {
                    if (this.mUimaContextAdmin.getExternalOverrides() == null) {
                        externalOverrides = UIMAFramework.getResourceSpecifierFactory().createSettings();
                        try {
                            externalOverrides.loadSystemDefaults();
                        }
                        catch (ResourceConfigurationException e) {
                            throw new ResourceInitializationException("error_initializing_from_descriptor", new Object[]{name, metadata.getSourceUrlString()}, e);
                        }
                        this.mUimaContextAdmin.setExternalOverrides(externalOverrides);
                    }
                }
            }
            try {
                this.mUimaContextAdmin.getConfigurationManager().createContext(this.mUimaContextAdmin.getQualifiedContextName(), this.getMetaData(), this.mUimaContextAdmin.getExternalOverrides());
                this.mUimaContextAdmin.getConfigurationManager().setSession(this.mUimaContextAdmin.getSession());
            }
            catch (ResourceConfigurationException e) {
                throw new ResourceInitializationException("error_initializing_from_descriptor", new Object[]{name, metadata.getSourceUrlString()}, e);
            }
            ResourceManagerConfiguration resMgrCfg = ((ResourceCreationSpecifier)aSpecifier).getResourceManagerConfiguration();
            if (resMgrCfg != null) {
                UimaContext prevContext = UimaContextHolder.setContext(this.mUimaContextAdmin);
                try {
                    try {
                        resMgrCfg.resolveImports(this.getResourceManager());
                    }
                    catch (InvalidXMLException e) {
                        throw new ResourceInitializationException(e);
                    }
                    if (aAdditionalParams == null) {
                        aAdditionalParams = new HashMap<String, Object>();
                        aAdditionalParams.put("RESOURCE_MANAGER", this.mUimaContextAdmin.getResourceManager());
                    } else if (!aAdditionalParams.containsKey("RESOURCE_MANAGER")) {
                        aAdditionalParams = new HashMap<String, Object>(aAdditionalParams);
                        aAdditionalParams.put("RESOURCE_MANAGER", this.mUimaContextAdmin.getResourceManager());
                    }
                    HashMap<String, Object> aAdditionalParmsForExtResources = new HashMap<String, Object>(aAdditionalParams);
                    if (aAdditionalParmsForExtResources.get("UIMA_CONTEXT") == null) {
                        aAdditionalParmsForExtResources.put("UIMA_CONTEXT", this.mUimaContextAdmin);
                    }
                    this.mUimaContextAdmin.getResourceManager().initializeExternalResources(resMgrCfg, this.mUimaContextAdmin.getQualifiedContextName(), aAdditionalParmsForExtResources);
                }
                finally {
                    UimaContextHolder.setContext(prevContext);
                }
            }
            if ((resourceDependencies = ((ResourceCreationSpecifier)aSpecifier).getExternalResourceDependencies()) != null) {
                this.mUimaContextAdmin.getResourceManager().resolveAndValidateResourceDependencies(resourceDependencies, this.mUimaContextAdmin.getQualifiedContextName());
            }
        }
        this.mInitialized = true;
        return true;
    }

    @Override
    public void destroy() {
    }

    @Override
    public ResourceMetaData getMetaData() {
        return this.mMetaData;
    }

    protected void setMetaData(ResourceMetaData aMetaData) {
        this.mMetaData = aMetaData;
    }

    @Override
    public Logger getLogger() {
        return UIMAFramework.getLogger(this.getClass());
    }

    @Override
    public void setLogger(Logger aLogger) {
        if (this.getUimaContext() != null) {
            this.getUimaContextAdmin().setLogger(aLogger);
        }
    }

    @Override
    public ResourceManager getResourceManager() {
        if (this.getUimaContextAdmin() != null) {
            return this.getUimaContextAdmin().getResourceManager();
        }
        return null;
    }

    @Override
    public UimaContext getUimaContext() {
        return this.mUimaContextAdmin;
    }

    @Override
    public UimaContextAdmin getUimaContextAdmin() {
        return this.mUimaContextAdmin;
    }

    public CasManager getCasManager() {
        return this.getResourceManager().getCasManager();
    }

    public RelativePathResolver getRelativePathResolver(Map<String, Object> aAdditionalParams) {
        RelativePathResolver relPathResolver = null;
        if (aAdditionalParams != null) {
            relPathResolver = (RelativePathResolver)aAdditionalParams.get("RELATIVE_PATH_RESOLVER");
        }
        if (relPathResolver == null) {
            relPathResolver = new RelativePathResolver_impl();
        }
        return relPathResolver;
    }
}

