/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class EncodedPrintStream
extends PrintStream {
    private final String encoding;

    public EncodedPrintStream(OutputStream out, String encoding) throws UnsupportedEncodingException {
        this(out, false, encoding);
    }

    public EncodedPrintStream(OutputStream out, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
        super(out, autoFlush);
        this.encoding = encoding;
        "test".getBytes(encoding);
    }

    @Override
    private final void writeBytes(byte[] bytes) {
        super.write(bytes, 0, bytes.length);
    }

    @Override
    public void print(char c) {
        try {
            this.writeBytes(new String(new char[]{c}).getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public void print(char[] s2) {
        try {
            this.writeBytes(new String(s2).getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public void print(String s2) {
        try {
            this.writeBytes(s2.getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public void println(char x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char[] x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(String x) {
        this.print(x);
        this.println();
    }
}

