/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.events.StartElement;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmiSplitUtilities {
    public static final String CAS_NULL = "uima.cas.NULL";
    public static final String CAS_VIEW = "uima.cas.View";
    public static final String CAS_SOFA = "uima.cas.Sofa";
    public static final String TYPES_NAMESPACE = "de.julielab.jules.types.";
    public static final List<String> primitives = Arrays.asList("uima.cas.BooleanArray", "uima.cas.ByteArray", "uima.cas.DoubleArray", "uima.cas.FloatArray", "uima.cas.IntegerArray", "uima.cas.LongArray", "uima.cas.ShortArray", "uima.cas.StringArray");
    private static final Logger log = LoggerFactory.getLogger(XmiSplitUtilities.class);

    public static String convertNSUri(String nameSpace) {
        if (nameSpace.startsWith("http:")) {
            nameSpace = nameSpace.substring(5);
        }
        while (nameSpace.startsWith("/")) {
            nameSpace = nameSpace.substring(1);
        }
        if (nameSpace.endsWith(".ecore")) {
            nameSpace = nameSpace.substring(0, nameSpace.length() - 6);
        }
        String javaNamePart = nameSpace.replace('/', '.') + ".";
        return javaNamePart;
    }

    public static String getTypeJavaName(StartElement element) {
        String NSUri = element.getName().getNamespaceURI();
        String typeJavaName = XmiSplitUtilities.convertNSUri(NSUri);
        return typeJavaName;
    }

    public static boolean isFSArray(Type annotationType) {
        return annotationType.getName().equals("uima.cas.FSArray");
    }

    public static boolean isPrimitive(Type annotationType, String featureName) {
        boolean isPrimitive = false;
        Type featureType = annotationType.getFeatureByBaseName(featureName).getRange();
        return XmiSplitUtilities.isPrimitive(featureType);
    }

    public static boolean isPrimitive(Type type) {
        boolean isPrimitive = false;
        if (type.isPrimitive() || primitives.contains(type.toString()) || type.toString().equals(CAS_SOFA)) {
            isPrimitive = true;
        }
        return isPrimitive;
    }

    public static Type getFeatureType(Type annotationType, String featureName) {
        return annotationType.getFeatureByBaseName(featureName).getRange();
    }

    public static boolean isAnnotationType(String qualifiedTypename) {
        return !qualifiedTypename.startsWith("uima.cas");
    }

    public static boolean isReferenceAttribute(Type annotationType, String attributeName, TypeSystem ts) {
        if (annotationType.isArray() && attributeName.equals("elements")) {
            return !annotationType.getComponentType().isPrimitive();
        }
        return XmiSplitUtilities.isReferenceFeature(annotationType.getFeatureByBaseName(attributeName), ts);
    }

    public static boolean isReferenceFeature(Feature f, TypeSystem ts) {
        if (f.isMultipleReferencesAllowed()) {
            return true;
        }
        Type range = f.getRange();
        if (range.isArray() && !range.getComponentType().isPrimitive()) {
            return true;
        }
        if (range.isArray()) {
            return false;
        }
        if (ts.subsumes(ts.getType("uima.cas.FSList"), range)) {
            return true;
        }
        if (ts.subsumes(ts.getType("uima.cas.ListBase"), range)) {
            return false;
        }
        return !range.isPrimitive();
    }

    public static boolean isMultiValuedFeatureAttribute(Type type, String attrName) {
        return type.isArray() && attrName.equals("elements");
    }

    public static boolean isListTypeName(String typeName) {
        String resolvedName = XmiSplitUtilities.resolveListSubtypes(typeName);
        return resolvedName.equals("uima.cas.FloatList") || resolvedName.equals("uima.cas.FSList") || resolvedName.equals("uima.cas.IntegerList") || resolvedName.equals("uima.cas.StringList");
    }

    public static String resolveListSubtypes(String typeName) {
        switch (typeName) {
            case "uima.cas.NonEmptyFloatList": {
                return "uima.cas.FloatList";
            }
            case "uima.cas.NonEmptyFSList": {
                return "uima.cas.FSList";
            }
            case "uima.cas.NonEmptyIntegerList": {
                return "uima.cas.IntegerList";
            }
            case "uima.cas.NonEmptyStringList": {
                return "uima.cas.StringList";
            }
        }
        return typeName;
    }

    public static ByteBuffer readInputStreamIntoBuffer(InputStream is) throws IOException {
        ByteArrayOutputStream baos = XmiSplitUtilities.readInputStreamIntoByteArrayOutputStream(is);
        ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
        return bb;
    }

    public static ByteArrayOutputStream readInputStreamIntoByteArrayOutputStream(InputStream is) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((read = is.read(buffer)) != -1) {
            baos.write(buffer, 0, read);
        }
        return baos;
    }

    public static Set<String> completeTypeNames(String[] annotationsToRetrieve) {
        if (null != annotationsToRetrieve && annotationsToRetrieve.length > 0) {
            HashSet<String> annotationNames = new HashSet<String>();
            for (int i = 0; i < annotationsToRetrieve.length; ++i) {
                String annotationName = annotationsToRetrieve[i];
                if (!annotationName.contains(".")) {
                    String typeName = TYPES_NAMESPACE + annotationsToRetrieve[i];
                    annotationNames.add(typeName);
                    continue;
                }
                annotationNames.add(annotationName);
            }
            return annotationNames;
        }
        return null;
    }
}

