/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import de.julielab.xml.XmiSplitUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmiBuilder {
    public static final List<String> noViewMembers = Arrays.asList("cas:NULL", "cas:Sofa", "cas:FSArray");
    private static final Logger log = LoggerFactory.getLogger(XmiBuilder.class);
    private static final XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private static final QName xmiIdQName = new QName("http://www.omg.org/XMI", "id");
    private static final QName fsArrayElements = new QName("elements");
    private static XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private static XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    private static String xmiTag = "xmi:XMI";
    Map<String, Collection<String>> potentiallyMissingFeatures;
    private Map<String, InputStream> xmiData;
    private String docTableName;
    private LinkedHashMap<String, XMLEventReader> readers;
    private LinkedHashSet<String> viewXmiIds;
    private byte[] xmlStartDocBytes;
    private byte[] xmiEndBytes;
    private byte[] xmiStartFinishBytes;
    private byte[] xmiStartBytes;
    private TypeSystem ts;
    private Set<String> annotationNames;
    private int dataSize = 100000;

    public XmiBuilder(Map<String, String> nsAndXmiVersionMap, String[] annotationsToRetrieve, long attribute_size) {
        this.annotationNames = XmiSplitUtilities.completeTypeNames(annotationsToRetrieve);
        this.setXMIStartElementData(nsAndXmiVersionMap);
    }

    public XmiBuilder(Map<String, String> nsAndXmiVersionMap, String[] annotationsToRetrieve) {
        this(nsAndXmiVersionMap, annotationsToRetrieve, 0L);
    }

    public ByteArrayOutputStream buildXmi(LinkedHashMap<String, InputStream> xmiData, TypeSystem ts) {
        this.xmiData = xmiData;
        this.docTableName = "DOCUMENT-MODULE";
        this.ts = ts;
        if (null == this.potentiallyMissingFeatures) {
            this.createFeatureExcludeMap();
        }
        this.makeValidXML();
        this.readers = new LinkedHashMap();
        this.viewXmiIds = new LinkedHashSet();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.dataSize);
        Attribute xmiIdAtt = null;
        try {
            XMLEventWriter writer = outputFactory.createXMLEventWriter(baos);
            this.initializeReaders();
            XMLEventReader docReader = this.readers.get(this.docTableName);
            if (docReader == null) {
                throw new IllegalArgumentException("No XMI data was passed for the given document data key \"" + this.docTableName + "\".");
            }
            while (docReader.hasNext()) {
                String elementName;
                EndElement element;
                QName elementQName;
                String elementPrefix;
                String tag;
                XMLEvent docEvent = docReader.nextEvent();
                if (docEvent.isStartElement()) {
                    StartElement docStart = docEvent.asStartElement();
                    QName docStartQName = docStart.getName();
                    String docStartPrefix = docStartQName.getPrefix();
                    String docStartName = docStartQName.getLocalPart();
                    String docStartTag = docStartPrefix + ":" + docStartName;
                    xmiIdAtt = docStart.getAttributeByName(xmiIdQName);
                    if (xmiIdAtt != null && !noViewMembers.contains(docStartTag)) {
                        String xmiId = xmiIdAtt.getValue();
                        this.viewXmiIds.add(xmiId);
                    }
                } else if (docEvent.isEndElement() && (tag = (elementPrefix = (elementQName = (element = docEvent.asEndElement()).getName()).getPrefix()) + ":" + (elementName = elementQName.getLocalPart())).equals(xmiTag)) {
                    ArrayList<XMLEvent> annotationElements = new ArrayList<XMLEvent>();
                    HashMap<String, StartElement> seenXmiElements = new HashMap<String, StartElement>();
                    for (String tableName : this.readers.keySet()) {
                        if (tableName.equals(this.docTableName)) continue;
                        XMLEventReader annotationReader = this.readers.get(tableName);
                        while (annotationReader.hasNext()) {
                            String endName;
                            EndElement endElement;
                            QName endQName;
                            String endPrefix;
                            String endTag;
                            XMLEvent annotationEvent = annotationReader.nextEvent();
                            if (annotationEvent.isStartDocument() || annotationEvent.isEndDocument()) continue;
                            if (annotationEvent.isStartElement()) {
                                String startName;
                                StartElement startElement = annotationEvent.asStartElement();
                                QName startQName = startElement.getName();
                                String startPrefix = startQName.getPrefix();
                                String startTag = startPrefix + ":" + (startName = startQName.getLocalPart());
                                if (startTag.equals(xmiTag)) continue;
                                xmiIdAtt = startElement.getAttributeByName(xmiIdQName);
                                if (xmiIdAtt != null) {
                                    String xmiId = xmiIdAtt.getValue();
                                    if (!noViewMembers.contains(startTag)) {
                                        this.viewXmiIds.add(xmiId);
                                    }
                                    if (null != seenXmiElements.get(xmiId) && !this.equals((StartElement)seenXmiElements.get(xmiId), startElement)) {
                                        throw new IllegalArgumentException("Detected XMI ID clash between the following to elements: " + ((StartElement)seenXmiElements.get(xmiId)).getName().getLocalPart() + " and " + startElement.getName().getLocalPart() + "; the input data is inconsistent, please check the consistency of your database.");
                                    }
                                    if (null == seenXmiElements.get(xmiId)) {
                                        seenXmiElements.put(xmiId, startElement);
                                    }
                                }
                            } else if (annotationEvent.isEndElement() && (endTag = (endPrefix = (endQName = (endElement = annotationEvent.asEndElement()).getName()).getPrefix()) + ":" + (endName = endQName.getLocalPart())).equals(xmiTag)) continue;
                            annotationElements.add(annotationEvent);
                        }
                    }
                    for (int i = 0; i < annotationElements.size(); ++i) {
                        if (!((XMLEvent)annotationElements.get(i)).isStartElement()) continue;
                        StartElement annotationElementWithoutInvalidRefrences = this.removeInvalidFeatureReferences(((XMLEvent)annotationElements.get(i)).asStartElement(), seenXmiElements);
                        annotationElements.set(i, annotationElementWithoutInvalidRefrences);
                    }
                    int deletedStartElementCount = 0;
                    boolean inDeletedElement = false;
                    for (XMLEvent event : annotationElements) {
                        String xmiId;
                        XMLEvent toWrite = event;
                        if (!toWrite.isEndElement() && inDeletedElement) {
                            if (toWrite.isStartElement()) {
                                xmiIdAtt = toWrite.asStartElement().getAttributeByName(xmiIdQName);
                                if (xmiIdAtt != null) {
                                    xmiId = xmiIdAtt.getValue();
                                    this.viewXmiIds.remove(xmiId);
                                }
                                ++deletedStartElementCount;
                            }
                            log.trace("Deleted element: {}; Reason: Nested in deleted element.", (Object)toWrite);
                            continue;
                        }
                        if (event.isStartElement() && (xmiIdAtt = toWrite.asStartElement().getAttributeByName(xmiIdQName)) != null && null == seenXmiElements.get(xmiId = xmiIdAtt.getValue())) {
                            this.viewXmiIds.remove(xmiId);
                            ++deletedStartElementCount;
                            inDeletedElement = true;
                            log.trace("Deleted element: {}; Reason: Explicitly deleted for referencing non existing XMI ID.", (Object)toWrite);
                            continue;
                        }
                        if (toWrite.isEndElement() && deletedStartElementCount > 0) {
                            if (--deletedStartElementCount == 0) {
                                inDeletedElement = false;
                            }
                            log.trace("Deleted element: {}; Reason: Nested in deleted element.", (Object)toWrite);
                            continue;
                        }
                        writer.add(toWrite);
                    }
                    String members = StringUtils.join(this.viewXmiIds, " ");
                    Attribute membersAttribute = eventFactory.createAttribute("members", members);
                    StartElement viewStart = eventFactory.createStartElement("cas", "http:///uima/cas.ecore", "View");
                    EndElement viewEnd = eventFactory.createEndElement("cas", "http:///uima/cas.ecore", "View");
                    writer.add(viewStart);
                    writer.add(membersAttribute);
                    writer.add(viewEnd);
                }
                writer.add(docEvent);
            }
            writer.close();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return baos;
    }

    private boolean equals(StartElement e1, StartElement e2) {
        boolean equal = e1.getName().equals(e2.getName());
        Iterator<Attribute> a1It = e1.getAttributes();
        Iterator<Attribute> a2It = e2.getAttributes();
        HashSet<QName> a1Names = new HashSet<QName>();
        HashSet<QName> a2Names = new HashSet<QName>();
        HashSet<String> a1Values = new HashSet<String>();
        HashSet<String> a2Values = new HashSet<String>();
        while (a1It.hasNext() && a2It.hasNext()) {
            Attribute a1 = a1It.next();
            Attribute a2 = a2It.next();
            a1Names.add(a1.getName());
            a2Names.add(a2.getName());
            a1Values.add(a1.getValue());
            a2Values.add(a2.getValue());
        }
        equal = equal && !a1It.hasNext() && !a2It.hasNext();
        equal = equal && a1Names.equals(a2Names);
        equal = equal && a1Values.equals(a2Values);
        return equal;
    }

    private StartElement removeInvalidFeatureReferences(StartElement startElement, Map<String, StartElement> seenXmiElements) {
        String elementName = startElement.getName().getLocalPart();
        String javaname = XmiSplitUtilities.getTypeJavaName(startElement) + elementName;
        if (null == this.potentiallyMissingFeatures || !this.potentiallyMissingFeatures.keySet().contains(javaname)) {
            return startElement;
        }
        ArrayList<Attribute> reducedAttributeList = new ArrayList<Attribute>();
        Collection<String> missingFeatureCandidates = this.potentiallyMissingFeatures.get(javaname);
        boolean reduceAttributeList = false;
        Iterator<Attribute> attIt = startElement.getAttributes();
        while (attIt.hasNext()) {
            boolean removeAttribute = false;
            Attribute att = attIt.next();
            QName qname = att.getName();
            String xmiRefId = att.getValue();
            String featureBaseName = qname.getLocalPart();
            if (missingFeatureCandidates.contains(featureBaseName)) {
                boolean annotationMissing = false;
                Type type = this.ts.getType(javaname);
                Feature feature = type.getFeatureByBaseName(featureBaseName);
                Type featureRange = feature.getRange();
                boolean featureHasArrayRange = featureRange.isArray();
                if (featureHasArrayRange) {
                    if (feature.isMultipleReferencesAllowed()) {
                        StartElement fsArray = seenXmiElements.get(xmiRefId);
                        if (null == fsArray) {
                            annotationMissing = true;
                        } else {
                            String[] elements;
                            Attribute attributeByName = fsArray.getAttributeByName(fsArrayElements);
                            if (attributeByName == null) {
                                throw new IllegalStateException("Programming error: The array feature " + featureBaseName + " should be accessed as FSArray for the element " + elementName + ". However, it does not have the \"" + fsArrayElements + "\" attribute. The value of the " + featureBaseName + " attribute is \"" + xmiRefId + "\".");
                            }
                            String elementsString = attributeByName.getValue();
                            for (String element : elements = elementsString.split(" ")) {
                                if (seenXmiElements.containsKey(element)) continue;
                                annotationMissing = true;
                            }
                        }
                    } else {
                        String[] elements;
                        String elementsString = xmiRefId;
                        for (String element : elements = elementsString.split(" ")) {
                            if (seenXmiElements.containsKey(element)) continue;
                            annotationMissing = true;
                        }
                    }
                } else if (seenXmiElements.get(xmiRefId) == null) {
                    annotationMissing = true;
                }
                if (annotationMissing) {
                    removeAttribute = true;
                }
            }
            if (!removeAttribute) {
                reducedAttributeList.add(att);
            } else if (null != seenXmiElements.get(xmiRefId)) {
                seenXmiElements.remove(xmiRefId);
            }
            if (!removeAttribute) continue;
            reduceAttributeList = true;
        }
        if (!reduceAttributeList) {
            return startElement;
        }
        StartElement newElement = eventFactory.createStartElement(startElement.getName(), reducedAttributeList.iterator(), startElement.getNamespaces());
        return newElement;
    }

    private void createFeatureExcludeMap() {
        if (null == this.annotationNames) {
            return;
        }
        this.potentiallyMissingFeatures = new HashMap<String, Collection<String>>();
        for (String typeName : this.annotationNames) {
            Type type = this.ts.getType(typeName);
            if (null == type) {
                throw new IllegalArgumentException("The type \"" + typeName + "\" could not be found in the type system.");
            }
            for (Feature feature : type.getFeatures()) {
                String featureTypeName;
                if (feature.getRange().isPrimitive() || feature.getName().startsWith("uima.cas.AnnotationBase")) continue;
                Type rangeType = feature.getRange().getComponentType();
                if (null == rangeType) {
                    rangeType = feature.getRange();
                }
                if (this.annotationNames.contains(featureTypeName = rangeType.getName())) continue;
                String featureBaseName = feature.getShortName();
                Collection<String> excludeFeatures = this.potentiallyMissingFeatures.get(typeName);
                if (null == excludeFeatures) {
                    excludeFeatures = new HashSet<String>();
                    this.potentiallyMissingFeatures.put(typeName, excludeFeatures);
                }
                excludeFeatures.add(featureBaseName);
            }
        }
        log.debug("The following features for specified types have been declared to be potentially missing: {}", (Object)this.potentiallyMissingFeatures);
    }

    protected void setXMIStartElementData(Map<String, String> namespacesAndXmiVersion) {
        if (null == namespacesAndXmiVersion || namespacesAndXmiVersion.size() == 0) {
            log.debug("No namespaces mapping were passed. It is assumed that all given XMI documents are complete and valid.");
            return;
        }
        ArrayList<Attribute> xmiAtt = new ArrayList<Attribute>();
        ArrayList<Namespace> xmiNS = new ArrayList<Namespace>();
        for (Map.Entry<String, String> nsEntry : namespacesAndXmiVersion.entrySet()) {
            if (nsEntry.getKey().equals("xmi:version")) {
                QName qName = new QName("http://www.omg.org/XMI", "version");
                xmiAtt.add(eventFactory.createAttribute(qName, nsEntry.getValue()));
                continue;
            }
            xmiNS.add(eventFactory.createNamespace(nsEntry.getKey(), nsEntry.getValue()));
        }
        StartElement xmiStart = eventFactory.createStartElement("xmi", "http://www.omg.org/XMI", "XMI", xmiAtt.iterator(), xmiNS.iterator());
        try {
            this.xmlStartDocBytes = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLEventWriter w = outputFactory.createXMLEventWriter(baos);
            w.add(xmiStart);
            w.add(eventFactory.createCharacters("dummy"));
            w.add(eventFactory.createEndElement("xmi", "http://www.omg.org/XMI", "XMI"));
            w.close();
            byte[] ba = baos.toByteArray();
            String xmiStr = new String(ba);
            this.xmiStartBytes = xmiStr.substring(0, xmiStr.indexOf(62)).getBytes();
            this.xmiStartFinishBytes = ">".getBytes();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        this.xmiEndBytes = "</xmi:XMI>".getBytes();
    }

    private void makeValidXML() {
        if (null == this.xmlStartDocBytes) {
            return;
        }
        for (Map.Entry<String, InputStream> xmiEntry : this.xmiData.entrySet()) {
            InputStream xmiStream = xmiEntry.getValue();
            Vector<InputStream> streamVec = new Vector<InputStream>();
            if (xmiEntry.getKey().equals(this.docTableName)) {
                streamVec.add(new ByteArrayInputStream(this.xmlStartDocBytes));
            }
            streamVec.add(new ByteArrayInputStream(this.xmiStartBytes));
            streamVec.add(new ByteArrayInputStream(this.xmiStartFinishBytes));
            streamVec.add(xmiStream);
            streamVec.add(new ByteArrayInputStream(this.xmiEndBytes));
            SequenceInputStream completeXmiStream = new SequenceInputStream(streamVec.elements());
            xmiEntry.setValue(completeXmiStream);
        }
    }

    private void initializeReaders() {
        for (String tableName : this.xmiData.keySet()) {
            try {
                XMLEventReader reader = inputFactory.createXMLEventReader(this.xmiData.get(tableName));
                this.readers.put(tableName, reader);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }

    public void setdocTableName(String docTableName) {
        this.docTableName = docTableName;
    }

    public void setXmiData(HashMap<String, InputStream> xmiData) {
        this.xmiData = xmiData;
    }

    public void setInputSize(int dataSize) {
        this.dataSize = dataSize;
    }
}

