/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import com.ximpleware.AutoPilot;
import com.ximpleware.EOFException;
import com.ximpleware.EncodingException;
import com.ximpleware.EntityException;
import com.ximpleware.NavException;
import com.ximpleware.ParseException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import com.ximpleware.extended.AutoPilotHuge;
import com.ximpleware.extended.NavExceptionHuge;
import com.ximpleware.extended.ParseExceptionHuge;
import com.ximpleware.extended.VTDExceptionHuge;
import com.ximpleware.extended.VTDGenHuge;
import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import de.julielab.java.utilities.CompressionUtilities;
import de.julielab.xml.AbstractFieldValueSource;
import de.julielab.xml.ConstantFieldValueSource;
import de.julielab.xml.FieldValueSource;
import de.julielab.xml.FileNameValueSource;
import de.julielab.xml.FileTooBigException;
import de.julielab.xml.JulieXMLBuffer;
import de.julielab.xml.Options;
import de.julielab.xml.TimestampValueSource;
import de.julielab.xml.XPathNavigator;
import de.julielab.xml.XPathNavigatorHuge;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.tuple.Pair;
import org.rauschig.jarchivelib.ArchiveEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JulieXMLTools {
    public static final int ELEMENT_FRAGMENT = 0;
    public static final int CONTENT_FRAGMENT = 1;
    static final Logger LOG = LoggerFactory.getLogger(JulieXMLTools.class);

    public static Iterator<Map<String, Object>> constructRowIterator(String fileName, int bufferSize, String forEachXpath, List<Map<String, String>> fields, boolean largeFileSize) {
        return JulieXMLTools.constructRowIterator(fileName, bufferSize, forEachXpath, fields, largeFileSize, true);
    }

    public static Iterator<Map<String, Object>> constructRowIterator(String fileName, final int bufferSize, final String forEachXpath, final List<Map<String, String>> fields, boolean largeFileSize, final boolean namespaceAwareness) {
        try {
            if (largeFileSize) {
                return JulieXMLTools.constructRowIteratorHuge(fileName, forEachXpath, fields, namespaceAwareness);
            }
            if (fileName.endsWith(".tgz") || fileName.endsWith(".tar.gz") || fileName.endsWith(".tar")) {
                LOG.info("Got a TAR archive at {}. It will be scanned for XML entry files.", (Object)fileName);
                final Iterator<Pair<ArchiveEntry, InputStream>> archiveEntryInputStreams = CompressionUtilities.getArchiveEntryInputStreams(new File(fileName));
                return new Iterator<Map<String, Object>>(){
                    private Iterator<Map<String, Object>> internalIterator;
                    private Map<String, Object> nextRow;
                    private Pair<ArchiveEntry, InputStream> entry = this.nextArchiveEntry();

                    @Override
                    public boolean hasNext() {
                        if (this.nextRow == null) {
                            if (this.internalIterator != null && this.internalIterator.hasNext()) {
                                this.nextRow = this.internalIterator.next();
                            } else if (this.entry != null) {
                                while (!(this.internalIterator != null && this.internalIterator.hasNext() || this.entry == null)) {
                                    if (this.entry.getLeft().isDirectory() || !this.hasValidEnding(this.entry.getLeft().getName())) {
                                        LOG.info("Skipping TAR entry {}", (Object)this.entry.getLeft().getName());
                                        this.entry = this.nextArchiveEntry();
                                        continue;
                                    }
                                    VTDNav vn = null;
                                    try {
                                        LOG.info("Processing TAR entry {}", (Object)this.entry.getLeft().getName());
                                        InputStream entryIs = this.entry.getRight();
                                        if (this.entry.getLeft().getName().toLowerCase().endsWith(".gz") || this.entry.getLeft().getName().toLowerCase().endsWith("gzip")) {
                                            entryIs = new GZIPInputStream(entryIs);
                                        }
                                        vn = JulieXMLTools.getVTDNav(entryIs, bufferSize, namespaceAwareness);
                                    }
                                    catch (ParseException e) {
                                        e.printStackTrace();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    this.internalIterator = JulieXMLTools.constructRowIterator(vn, forEachXpath, (List<Map<String, String>>)fields, this.entry.getLeft().getName());
                                    this.entry = this.nextArchiveEntry();
                                }
                                this.nextRow = this.internalIterator.next();
                            }
                        }
                        return this.nextRow != null;
                    }

                    @Override
                    public Map<String, Object> next() {
                        this.hasNext();
                        Map<String, Object> ret = this.nextRow;
                        this.nextRow = null;
                        return ret;
                    }

                    private boolean hasValidEnding(String filename) {
                        String lc = filename;
                        return lc.endsWith("xml") || lc.endsWith("xml.gz") || lc.endsWith("xml.gzip");
                    }

                    private Pair<ArchiveEntry, InputStream> nextArchiveEntry() {
                        return archiveEntryInputStreams.hasNext() ? (Pair)archiveEntryInputStreams.next() : null;
                    }
                };
            }
            if (fileName.endsWith(".zip")) {
                LOG.info("Got a ZIP archive at {}. It will be scanned for XML entry files.", (Object)fileName);
                final ZipFile zipFile = new ZipFile(fileName, StandardCharsets.UTF_8);
                final List sortedEntries = zipFile.stream().sorted(Comparator.comparing(ZipEntry::getName)).collect(Collectors.toList());
                return new Iterator<Map<String, Object>>(){
                    private Iterator<ZipEntry> zipEntryIt;
                    private ZipEntry entry;
                    private Iterator<Map<String, Object>> internalIterator;
                    private Map<String, Object> nextRow;
                    {
                        this.zipEntryIt = sortedEntries.iterator();
                        this.entry = this.nextZipEntry();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.nextRow == null) {
                            if (this.internalIterator != null && this.internalIterator.hasNext()) {
                                this.nextRow = this.internalIterator.next();
                            } else if (this.entry != null) {
                                while (!(this.internalIterator != null && this.internalIterator.hasNext() || this.entry == null)) {
                                    if (this.entry.isDirectory() || !this.hasValidEnding(this.entry.getName())) {
                                        LOG.info("Skipping ZIP entry {}", (Object)this.entry.getName());
                                        this.entry = this.nextZipEntry();
                                        continue;
                                    }
                                    VTDNav vn = null;
                                    try {
                                        LOG.info("Processing ZIP entry {}", (Object)this.entry.getName());
                                        InputStream entryIs = zipFile.getInputStream(this.entry);
                                        if (this.entry.getName().toLowerCase().endsWith(".gz") || this.entry.getName().toLowerCase().endsWith("gzip")) {
                                            entryIs = new GZIPInputStream(entryIs);
                                        }
                                        vn = JulieXMLTools.getVTDNav(entryIs, bufferSize, namespaceAwareness);
                                    }
                                    catch (ParseException e) {
                                        e.printStackTrace();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    this.internalIterator = JulieXMLTools.constructRowIterator(vn, forEachXpath, (List<Map<String, String>>)fields, this.entry.getName());
                                    this.entry = this.nextZipEntry();
                                }
                                this.nextRow = this.internalIterator.next();
                            }
                        }
                        return this.nextRow != null;
                    }

                    private boolean hasValidEnding(String filename) {
                        String lc = filename;
                        return lc.endsWith("xml") || lc.endsWith("xml.gz") || lc.endsWith("xml.gzip");
                    }

                    @Override
                    public Map<String, Object> next() {
                        this.hasNext();
                        Map<String, Object> ret = this.nextRow;
                        this.nextRow = null;
                        return ret;
                    }

                    private ZipEntry nextZipEntry() {
                        return this.zipEntryIt.hasNext() ? this.zipEntryIt.next() : null;
                    }
                };
            }
            InputStream is = fileName.endsWith(".gz") || fileName.endsWith(".gzip") ? new GZIPInputStream(new FileInputStream(fileName)) : new FileInputStream(fileName);
            VTDNav vn = JulieXMLTools.getVTDNav(is, bufferSize, namespaceAwareness);
            return JulieXMLTools.constructRowIterator(vn, forEachXpath, fields, fileName);
        }
        catch (FileNotFoundException e) {
            LOG.error(String.format("File %s could not be found.", fileName));
            e.printStackTrace();
        }
        catch (FileTooBigException e) {
            try {
                LOG.info("Falling back on VTD XML 'Huge' parser for large XML files...");
                return JulieXMLTools.constructRowIteratorHuge(fileName, forEachXpath, fields, namespaceAwareness);
            }
            catch (ParseExceptionHuge e1) {
                LOG.error("Error while parsing file " + fileName + ": ", (Object)e1.getMessage());
                e1.printStackTrace();
                System.exit(1);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException | ParseExceptionHuge e) {
            LOG.error("Error while parsing file " + fileName + ": ", (Object)e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        return null;
    }

    private static Iterator<Map<String, Object>> constructRowIteratorHuge(String fileName, String forEachXpath, List<Map<String, String>> fields, boolean nsAwareness) throws IOException, ParseExceptionHuge {
        JulieXMLBuffer buffer = new JulieXMLBuffer();
        buffer.readFile(fileName);
        VTDGenHuge vg = new VTDGenHuge();
        vg.setDoc(buffer);
        vg.parse(nsAwareness);
        VTDNavHuge vn = vg.getNav();
        return JulieXMLTools.constructRowIterator(vn, forEachXpath, fields, fileName);
    }

    public static Iterator<Map<String, Object>> constructRowIterator(byte[] data, int bufferSize, String forEachXpath, List<Map<String, String>> fields, String identifier, boolean nsAwareness) {
        try {
            VTDGen vg = new VTDGen();
            vg.setDoc(data);
            vg.parse(nsAwareness);
            VTDNav vn = vg.getNav();
            return JulieXMLTools.constructRowIterator(vn, forEachXpath, fields, identifier);
        }
        catch (ParseException e) {
            LOG.error("Error while parsing document " + identifier);
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private static Iterator<Map<String, Object>> constructRowIterator(final VTDNavHuge vn, String forEachXpath, List<Map<String, String>> fields, String identifier) {
        final AutoPilotHuge ap = new AutoPilotHuge(vn);
        try {
            ap.selectXPath(forEachXpath);
            final int startIndex = ap.evalXPath();
            if (startIndex == -1) {
                LOG.debug("Couldn't find XPath: " + forEachXpath + " in document " + identifier);
            }
            final HashMap<String, AbstractFieldValueSource> navigators = new HashMap<String, AbstractFieldValueSource>();
            for (Map<String, String> field : fields) {
                String xPath = field.get("xpath");
                Options options = new Options();
                String fieldName = field.get("name");
                if (xPath != null) {
                    AutoPilotHuge pilot = new AutoPilotHuge(vn);
                    AutoPilotHuge pilotForEach = new AutoPilotHuge(vn);
                    String fieldForEach = field.get("forEach");
                    pilotForEach.selectXPath(xPath);
                    pilot.selectXPath(xPath);
                    if (fieldForEach != null) {
                        pilotForEach = new AutoPilotHuge(vn);
                        pilotForEach.selectXPath(fieldForEach);
                    } else {
                        pilot.selectXPath(".");
                    }
                    options.returnXMLFragment = Boolean.parseBoolean(field.get("returnXMLFragment"));
                    options.returnArray = Boolean.parseBoolean(field.get("returnValuesAsArray"));
                    options.concatString = field.get("concatString");
                    if (options.concatString == null) {
                        options.concatString = ",";
                    }
                    options.performGzip = Boolean.parseBoolean(field.get("gzip"));
                    navigators.put(fieldName, new XPathNavigatorHuge(vn, pilotForEach, pilot, options));
                    continue;
                }
                if (Boolean.parseBoolean(field.get("extractFromFileName"))) {
                    String[] path = identifier.split("/");
                    navigators.put(fieldName, new FileNameValueSource(path[path.length - 1], field));
                    continue;
                }
                if (field.get("constantValue") != null) {
                    String value = field.get("constantValue");
                    navigators.put(fieldName, new ConstantFieldValueSource(value));
                    continue;
                }
                LOG.warn("Field with name \"" + fieldName + "\" does not define a source to get a value from (e.g. XML XPath or file name) and will not have imported any values.");
            }
            return new Iterator<Map<String, Object>>(){
                int index;
                {
                    this.index = startIndex;
                }

                @Override
                public boolean hasNext() {
                    return this.index != -1;
                }

                @Override
                public Map<String, Object> next() {
                    if (!this.hasNext()) {
                        return null;
                    }
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    try {
                        for (String fieldName : navigators.keySet()) {
                            FieldValueSource navi = (FieldValueSource)navigators.get(fieldName);
                            vn.push();
                            Object fieldValue = navi.getFieldValue();
                            vn.pop();
                            row.put(fieldName, fieldValue);
                        }
                        row.put("vtdIndex", this.index);
                        this.index = ap.evalXPath();
                        return row;
                    }
                    catch (XPathEvalExceptionHuge e) {
                        e.printStackTrace();
                    }
                    catch (NavExceptionHuge e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
        catch (XPathEvalException e) {
            e.printStackTrace();
        }
        catch (NavException e) {
            e.printStackTrace();
        }
        catch (VTDExceptionHuge e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Iterator<Map<String, Object>> constructRowIterator(final VTDNav vn, String forEachXpath, List<Map<String, String>> fields, String identifier) {
        final AutoPilot ap = new AutoPilot(vn);
        try {
            Map<String, String> namespaceMap = JulieXMLTools.buildNamespaceMap(vn.duplicateNav());
            JulieXMLTools.declareNamespaces(ap, namespaceMap);
            ap.selectXPath(forEachXpath);
            final int startIndex = ap.evalXPath();
            if (startIndex == -1) {
                LOG.debug("Couldn't find XPath: " + forEachXpath + " in document " + identifier);
            }
            final HashMap<String, AbstractFieldValueSource> navigators = new HashMap<String, AbstractFieldValueSource>();
            for (Map<String, String> field : fields) {
                String xPath = field.get("xpath");
                Options options = new Options();
                String fieldName = field.get("name");
                if (xPath != null) {
                    AutoPilot pilot = new AutoPilot(vn);
                    AutoPilot pilotForEach = new AutoPilot(vn);
                    String fieldForEach = field.get("forEach");
                    JulieXMLTools.declareNamespaces(pilot, namespaceMap);
                    JulieXMLTools.declareNamespaces(pilotForEach, namespaceMap);
                    try {
                        pilotForEach.selectXPath(xPath);
                    }
                    catch (XPathParseException e) {
                        throw new IllegalArgumentException("Could not parse XPath '" + xPath + "'.", e);
                    }
                    pilot.selectXPath(xPath);
                    if (fieldForEach != null) {
                        pilotForEach = new AutoPilot(vn);
                        pilotForEach.selectXPath(fieldForEach);
                    } else {
                        pilot.selectXPath(".");
                    }
                    options.returnXMLFragment = Boolean.parseBoolean(field.get("returnXMLFragment"));
                    options.returnArray = Boolean.parseBoolean(field.get("returnValuesAsArray"));
                    options.resolveEntities = Boolean.parseBoolean(field.get("resolveEntities"));
                    options.concatString = field.get("concatString");
                    if (options.concatString == null) {
                        options.concatString = ",";
                    }
                    options.performGzip = Boolean.parseBoolean(field.get("gzip"));
                    navigators.put(fieldName, new XPathNavigator(vn, pilotForEach, pilot, options));
                    continue;
                }
                if (Boolean.parseBoolean(field.get("completeXml"))) {
                    boolean performGzip = Boolean.parseBoolean(field.get("gzip"));
                    navigators.put(fieldName, new ConstantFieldValueSource(new String(vn.getXML().getBytes(), StandardCharsets.UTF_8), performGzip));
                    continue;
                }
                if (Boolean.parseBoolean(field.get("extractFromFileName"))) {
                    String[] path = identifier.split(File.separator);
                    navigators.put(fieldName, new FileNameValueSource(path[path.length - 1], field));
                    continue;
                }
                if (Boolean.parseBoolean(field.get("timestamp"))) {
                    navigators.put(fieldName, new TimestampValueSource());
                    continue;
                }
                if (field.get("constantValue") != null) {
                    String value = field.get("constantValue");
                    navigators.put(fieldName, new ConstantFieldValueSource(value));
                    continue;
                }
                LOG.warn("Field with name \"" + fieldName + "\" does not define a source to get a value from (e.g. XML XPath or file name) and will not have imported any values.");
            }
            return new Iterator<Map<String, Object>>(){
                int index;
                {
                    this.index = startIndex;
                }

                @Override
                public boolean hasNext() {
                    return this.index != -1;
                }

                @Override
                public Map<String, Object> next() {
                    if (!this.hasNext()) {
                        return null;
                    }
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    try {
                        for (String fieldName : navigators.keySet()) {
                            FieldValueSource navi = (FieldValueSource)navigators.get(fieldName);
                            vn.push();
                            Object fieldValue = navi.getFieldValue();
                            vn.pop();
                            row.put(fieldName, fieldValue);
                        }
                        row.put("vtdIndex", this.index);
                        this.index = ap.evalXPath();
                        return row;
                    }
                    catch (XPathEvalException e) {
                        e.printStackTrace();
                    }
                    catch (NavException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
        catch (XPathEvalException e) {
            e.printStackTrace();
        }
        catch (NavException e) {
            e.printStackTrace();
        }
        catch (XPathParseException e) {
            e.printStackTrace();
        }
        catch (VTDException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void declareNamespaces(AutoPilot ap, Map<String, String> namespaceMap) {
        for (Map.Entry<String, String> entry : namespaceMap.entrySet()) {
            ap.declareXPathNameSpace(entry.getKey(), entry.getValue());
        }
    }

    public static Map<String, String> buildNamespaceMap(VTDNav vn) throws VTDException {
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        AutoPilot ap = new AutoPilot(vn);
        ap.selectXPath("//namespace::*");
        String nsDeclaration = null;
        try {
            int i;
            while ((i = ap.evalXPath()) != -1) {
                nsDeclaration = vn.toString(i);
                if (!nsDeclaration.contains(":")) continue;
                String nsPrefix = nsDeclaration.split(":")[1];
                String nsUrl = vn.toString(i + 1);
                namespaceMap.put(nsPrefix, nsUrl);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.error("This algorithm expects XML namespace declarations to be of the form \"xmlns:<ns-name>\". The declaration actually was: \"" + nsDeclaration + "\"", e);
        }
        return namespaceMap;
    }

    public static VTDNav getVTDNav(InputStream is, int bufferSize) throws ParseException, FileTooBigException {
        return JulieXMLTools.getVTDNav(is, bufferSize, true);
    }

    public static VTDNav getVTDNav(InputStream is, int bufferSize, boolean namespaceAwareness) throws ParseException, FileTooBigException {
        VTDGen vg;
        block7: {
            vg = null;
            try {
                byte[] data = JulieXMLTools.readStream(is, bufferSize);
                vg = new VTDGen();
                vg.setDoc(data);
                vg.parse(namespaceAwareness);
            }
            catch (EncodingException e) {
                e.printStackTrace();
            }
            catch (EOFException e) {
                e.printStackTrace();
            }
            catch (EntityException e) {
                e.printStackTrace();
            }
            catch (FileTooBigException e) {
                throw e;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                String message = e.getMessage();
                if (!message.contains("file size too big")) break block7;
                throw new FileTooBigException(message);
            }
        }
        return vg.getNav();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readStream(InputStream is, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        ArrayList<byte[]> bufferList = new ArrayList<byte[]>();
        ArrayList<Integer> readBytesList = new ArrayList<Integer>();
        int bytesRead = 0;
        int allBytesRead = 0;
        while ((bytesRead = is.read(buffer)) != -1) {
            bufferList.add(buffer);
            readBytesList.add(bytesRead);
            buffer = new byte[bufferSize];
            if (allBytesRead + bytesRead < allBytesRead) {
                LOG.info("Array size overflow while reading file. The file you are attempting to read is propably greater than 2GB in size. Such files cannot be read using the default VTD XML parser. Consider splitting the file into subfiles of size less than 2GB for using the default parser.");
                throw new FileTooBigException("Input file could not be read because it is too big (>2GB)");
            }
            allBytesRead += bytesRead;
        }
        byte[] streamContent = new byte[allBytesRead];
        int pos = 0;
        try {
            for (int i = 0; i < bufferList.size(); ++i) {
                System.arraycopy(bufferList.get(i), 0, streamContent, pos, (Integer)readBytesList.get(i));
                pos += ((Integer)readBytesList.get(i)).intValue();
            }
        }
        catch (ArrayIndexOutOfBoundsException oob) {
            LOG.error("Array index out of bounds - please check whether the file you try to read is less then 2GB in size.", oob);
        }
        finally {
            is.close();
        }
        return streamContent;
    }

    public static byte[] gzipData(byte[] data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream os = new GZIPOutputStream(baos);
            os.write(data);
            os.close();
            return baos.toByteArray();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] unGzipData(byte[] gzipData) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(gzipData);
        GZIPInputStream gzipInputStream = new GZIPInputStream(bais);
        byte[] data = JulieXMLTools.readStream(gzipInputStream, 1024);
        return data;
    }

    public static URL getSolrServerURL(String urlStr, boolean calledByCLI, Logger LOG) {
        try {
            URL serverURL = new URL(urlStr);
            return serverURL;
        }
        catch (MalformedURLException e) {
            String msg = "Solr server URL '" + urlStr + "' is malformed: ";
            if (calledByCLI) {
                LOG.error(msg + e.getMessage());
            } else {
                LOG.error(msg, e);
            }
            return null;
        }
    }

    public static String getElementText(VTDNav vn) throws NavException {
        StringBuilder sb = new StringBuilder();
        int depth = vn.getCurrentDepth();
        int i = vn.getCurrentIndex();
        while (vn.getTokenType(i) == 0) {
            ++i;
        }
        while (i < vn.getTokenCount() && vn.getTokenDepth(i) >= depth && (vn.getTokenType(i) != 0 || vn.getTokenDepth(i) != depth)) {
            if (vn.getTokenType(i) == 5 || vn.getTokenType(i) == 11) {
                sb.append(vn.toString(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getFragment(VTDNav vn, int fragmentType, boolean returnRawString) throws NavException {
        long fragment = fragmentType == 0 ? vn.getElementFragment() : vn.getContentFragment();
        int offset = (int)fragment;
        int length = (int)(fragment >> 32);
        return returnRawString ? vn.toRawString(offset, length) : vn.toString(offset, length);
    }

    public static Map<String, String> createField(String ... configuration) {
        if (configuration.length % 2 == 1) {
            throw new IllegalArgumentException("An even number of arguments is required. The even indexes are field property keys, the odd indexes are the values to the previous key.");
        }
        HashMap<String, String> field = new HashMap<String, String>();
        for (int i = 0; i < configuration.length; i += 2) {
            String s2 = configuration[i];
            field.put(s2, configuration[i + 1]);
        }
        return field;
    }

    public static int setElementText(VTDNav vn, AutoPilot ap, XMLModifier xm, String xpath, String text) throws VTDException, UnsupportedEncodingException {
        ap.selectXPath(xpath);
        int elementIndex = ap.evalXPath();
        LOG.trace("Setting element text to an XML element: Found element XPath {} at VTD token index {} (-1 means not found)", (Object)xpath, (Object)elementIndex);
        int textIndex = -1;
        if (elementIndex != -1) {
            textIndex = vn.getText();
            if (textIndex != -1) {
                xm.updateToken(textIndex, text);
                LOG.trace("Element text already existed at token index {} and is replaced.", (Object)textIndex);
            } else {
                LOG.trace("Element is empty, setting new text.");
                xm.insertAfterHead(text);
                textIndex = elementIndex + 1;
            }
        }
        LOG.trace("Returning the VTD XML index of the new element text as {}", (Object)textIndex);
        return textIndex;
    }

    public static <T> String[] expandArrayEntries(T[] array, String fmtStr) {
        String[] expandedEntries = new String[array.length];
        for (int i = 0; i < expandedEntries.length; ++i) {
            expandedEntries[i] = String.format(fmtStr, array[i]);
        }
        return expandedEntries;
    }

    public static <T> String[] expandArrayEntries(List<T> list, String fmtStr) {
        String[] array = new String[list.size()];
        list.toArray(array);
        return JulieXMLTools.expandArrayEntries(array, fmtStr);
    }

    public static <T> String[] expandArrayEntries(T[] array, String[] fmtStrs) {
        if (array.length != fmtStrs.length) {
            throw new IllegalArgumentException("The size of the array with elements to be expanded must match the size of the array holding the extention format strings.");
        }
        String[] expandedEntries = new String[array.length];
        for (int i = 0; i < expandedEntries.length; ++i) {
            expandedEntries[i] = String.format(fmtStrs[i], array[i]);
        }
        return expandedEntries;
    }

    public static String getXpathValue(String xpath, AutoPilot ap) throws XPathParseException {
        ap.selectXPath(xpath);
        return ap.evalXPathToString();
    }

    public static String getXpathValue(String xpath, VTDNav vn) throws XPathParseException {
        return JulieXMLTools.getXpathValue(xpath, new AutoPilot(vn));
    }

    public static String getXpathValue(String xpath, InputStream is) throws IOException, XPathParseException, ParseException {
        VTDGen vg = new VTDGen();
        vg.setDoc(JulieXMLTools.readStream(is, 1024));
        vg.parse(false);
        return JulieXMLTools.getXpathValue(xpath, vg.getNav());
    }
}

