/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities.cache;

import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;

public abstract class CacheAccess<K, V> {
    public static final String STRING = "string";
    public static final String BOOL = "bool";
    public static final String JAVA = "java";
    public static final String BYTEARRAY = "bytearray";
    public static final String DOUBLEARRAY = "doublearray";
    protected String cacheId;
    protected String cacheRegion;

    public CacheAccess(String cacheId, String cacheRegion) {
        this.cacheId = cacheId;
        this.cacheRegion = cacheRegion;
    }

    public static <T> GroupSerializer<T> getSerializerByName(String name) {
        switch (name.toLowerCase()) {
            case "string": {
                return Serializer.STRING;
            }
            case "bool": {
                return Serializer.BOOLEAN;
            }
            case "java": {
                return Serializer.JAVA;
            }
            case "bytearray": {
                return Serializer.BYTE_ARRAY;
            }
            case "doublearray": {
                return Serializer.DOUBLE_ARRAY;
            }
        }
        throw new IllegalArgumentException("Unsupported cache serializer '" + name + "'.");
    }

    public abstract V get(K var1);

    public abstract boolean put(K var1, V var2);

    public abstract boolean isReadOnly();

    public abstract boolean isClosed();

    public abstract void commit();
}

