/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.costosys.medline;

import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.costosys.medline.DocumentDeletionException;
import de.julielab.costosys.medline.IDocumentDeleter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePKDataTableDocumentDeleter
implements IDocumentDeleter {
    private static final Logger log = LoggerFactory.getLogger(SimplePKDataTableDocumentDeleter.class);
    private DataBaseConnector dbc;
    private String[] tablesForDeletions;

    public void setDbc(DataBaseConnector dbc) {
        this.dbc = dbc;
    }

    @Override
    public void deleteDocuments(List<String> docIds) {
        for (String table : this.tablesForDeletions) {
            log.debug("Deleting {} documents marked for deletion in update file from table \"{}\".", (Object)docIds.size(), (Object)table);
            this.dbc.deleteFromTableSimplePK(table, docIds);
        }
    }

    @Override
    public void configure(HierarchicalConfiguration<ImmutableNode> deletionConfiguration) throws DocumentDeletionException {
        if (!deletionConfiguration.containsKey("tables.table")) {
            throw new DocumentDeletionException("Could not configure deleter '" + this.getName() + "' because its configuration lacks the 'tables.table' element telling in which tables to remove deleted documents.");
        }
        this.tablesForDeletions = deletionConfiguration.getStringArray("tables.table");
        log.info("Received the following tables for row deletion: {}", (Object)Arrays.toString(this.tablesForDeletions));
    }

    @Override
    public String getName() {
        return "database";
    }
}

