/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.costosys.dbconnection.util;

import de.julielab.costosys.dbconnection.CoStoSysConnection;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.costosys.dbconnection.util.CoStoSysException;
import de.julielab.xml.binary.BinaryJedisFormatUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoStoSysJedisTools {
    private static final Logger log = LoggerFactory.getLogger(CoStoSysJedisTools.class);

    public static JedisDataFormat determineDataFormat(DataBaseConnector dbc, String table, String column) throws CoStoSysException {
        boolean doGzip = true;
        boolean useBinaryFormat = true;
        String dataTable = dbc.getNextOrThisDataTable(table);
        log.debug("Fetching a single row from data table {}, column {} in order to determine whether data is in GZIP format", (Object)dataTable, (Object)column);
        try (CoStoSysConnection conn = dbc.obtainOrReserveConnection(true);){
            ResultSet rs = conn.createStatement().executeQuery(String.format("SELECT %s FROM %s WHERE %s IS NOT NULL LIMIT 1", column, dataTable, column));
            while (rs.next()) {
                byte[] xmiData = rs.getBytes(column);
                if (xmiData == null) {
                    throw new IllegalArgumentException("No data was retrieved from the given column.");
                }
                try (GZIPInputStream gzis = new GZIPInputStream(new ByteArrayInputStream(xmiData));){
                    useBinaryFormat = BinaryJedisFormatUtils.checkForJeDISBinaryFormat(gzis);
                }
                catch (IOException e) {
                    log.debug("Attempt to read XMI data in GZIP format failed. Assuming non-gzipped XMI data.");
                    doGzip = false;
                    useBinaryFormat = BinaryJedisFormatUtils.checkForJeDISBinaryFormat(xmiData);
                }
            }
        }
        catch (SQLException e) {
            if (e.getMessage().contains("does not exist")) {
                log.error("An exception occurred when trying to read the xmi column of the data table \"{}\". It seems the table does not contain XMI data and this is invalid to use with this reader.", (Object)dataTable);
            }
            throw new CoStoSysException(e);
        }
        log.debug("Found gzip: {}, binary: {}", (Object)doGzip, (Object)useBinaryFormat);
        return new JedisDataFormat(doGzip, useBinaryFormat);
    }

    public static Map<Integer, String> getReverseBinaryMappingFromDb(DataBaseConnector dbc, String xmiMetaSchema) {
        HashMap<Integer, String> map;
        block11: {
            map = null;
            String mappingTableName = xmiMetaSchema + "._binary_string_mapping";
            if (dbc.tableExists(mappingTableName)) {
                try (CoStoSysConnection conn = dbc.obtainOrReserveConnection(true);){
                    map = new HashMap<Integer, String>();
                    conn.setAutoCommit(true);
                    Statement stmt = conn.createStatement();
                    String sql = String.format("SELECT %s,%s FROM %s", "mapping_id", "mapping_string", mappingTableName);
                    ResultSet rs = stmt.executeQuery(String.format(sql, new Object[0]));
                    while (rs.next()) {
                        map.put(rs.getInt(1), rs.getString(2));
                    }
                    break block11;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLException ne = e.getNextException();
                    if (null != ne) {
                        ne.printStackTrace();
                    }
                    break block11;
                }
            }
            log.warn("JeDIS XMI annotation module meta table \"{}\" was not found. It is assumed that the table from which is read contains complete XMI documents.", (Object)(xmiMetaSchema + "._binary_string_mapping"));
        }
        return map;
    }

    public static Map<String, Boolean> getFeaturesToMapBinaryFromDb(DataBaseConnector dbc, String xmiMetaSchema) {
        HashMap<String, Boolean> map;
        block11: {
            map = null;
            String mappingTableName = xmiMetaSchema + "._binary_features_to_map";
            if (dbc.tableExists(mappingTableName)) {
                try (CoStoSysConnection conn = dbc.obtainOrReserveConnection(true);){
                    map = new HashMap<String, Boolean>();
                    conn.setAutoCommit(true);
                    Statement stmt = conn.createStatement();
                    String sql = String.format("SELECT %s,%s FROM %s", "feature", "map", mappingTableName);
                    ResultSet rs = stmt.executeQuery(String.format(sql, new Object[0]));
                    while (rs.next()) {
                        map.put(rs.getString(1), rs.getBoolean(2));
                    }
                    break block11;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLException ne = e.getNextException();
                    if (null != ne) {
                        ne.printStackTrace();
                    }
                    break block11;
                }
            }
            log.warn("JeDIS XMI annotation module meta table \"{}\" was not found. It is assumed that the table from which is read contains complete XMI documents.", (Object)(xmiMetaSchema + "._binary_features_to_map"));
        }
        return map;
    }

    public static Map<String, String> getNamespaceMap(DataBaseConnector dbc, String xmiMetaSchema) {
        HashMap<String, String> map;
        block11: {
            map = null;
            if (dbc.tableExists(xmiMetaSchema + "._xmi_namespaces")) {
                try (CoStoSysConnection conn = dbc.obtainOrReserveConnection(true);){
                    map = new HashMap<String, String>();
                    conn.setAutoCommit(true);
                    Statement stmt = conn.createStatement();
                    String sql = String.format("SELECT %s,%s FROM %s", "prefix", "ns_uri", xmiMetaSchema + "._xmi_namespaces");
                    ResultSet rs = stmt.executeQuery(String.format(sql, new Object[0]));
                    while (rs.next()) {
                        map.put(rs.getString(1), rs.getString(2));
                    }
                    break block11;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLException ne = e.getNextException();
                    if (null != ne) {
                        ne.printStackTrace();
                    }
                    break block11;
                }
            }
            log.warn("Table \"{}\" was not found it is assumed that the table from which is read contains complete XMI documents.", (Object)(dbc.getActiveDataPGSchema() + "._xmi_namespaces"));
        }
        return map;
    }

    public static class JedisDataFormat {
        private boolean gzip;
        private boolean binary;

        public JedisDataFormat(boolean gzip, boolean binary) {
            this.gzip = gzip;
            this.binary = binary;
        }

        public boolean isGzip() {
            return this.gzip;
        }

        public boolean isBinary() {
            return this.binary;
        }
    }
}

