/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.costosys.dbconnection;

import de.julielab.costosys.dbconnection.ConnectionClosable;
import de.julielab.costosys.dbconnection.DBCIterator;
import de.julielab.costosys.dbconnection.util.CoStoSysSQLRuntimeException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Exchanger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBCThreadedIterator<E>
extends DBCIterator<E> {
    private static final Logger log = LoggerFactory.getLogger(DBCThreadedIterator.class);
    protected Exchanger<List<E>> listExchanger = new Exchanger();
    protected ConnectionClosable backgroundThread;
    private Iterator<E> currentListIter;
    private boolean hasNext = true;
    private int returned = 0;
    private int currentSize = 0;

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public E next() {
        E next = this.currentListIter.next();
        if (!this.currentListIter.hasNext()) {
            this.update();
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void update() {
        try {
            log.debug("Retrieving next result list from background thread {}", (Object)((Thread)((Object)this.backgroundThread)).getName());
            List list = this.listExchanger.exchange(null);
            while (list != null && list.isEmpty()) {
                log.debug("Result list was empty; retrieving next result list from background thread {}", (Object)((Thread)((Object)this.backgroundThread)).getName());
                list = this.listExchanger.exchange(null);
            }
            if (list == null) {
                log.debug("Received end-of-data signal from background thread. Setting 'hasNext' to 'false'.");
                this.hasNext = false;
            } else {
                log.debug("Received data list of size {} from {}", (Object)list.size(), (Object)((Thread)((Object)this.backgroundThread)).getName());
                this.returned = 0;
                this.currentSize = list.size();
                this.currentListIter = list.iterator();
            }
        }
        catch (InterruptedException e) {
            throw new CoStoSysSQLRuntimeException(e);
        }
    }

    @Override
    public abstract void close();

    public abstract void join() throws InterruptedException;
}

