/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.ByteCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.IntBufferVisualizer;
import com.carrotsearch.hppc.IntByteAssociativeContainer;
import com.carrotsearch.hppc.IntByteMap;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.cursors.IntByteCursor;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.predicates.IntBytePredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import com.carrotsearch.hppc.procedures.IntByteProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class IntByteHashMap
implements IntByteMap,
Preallocable,
Cloneable {
    public int[] keys;
    public byte[] values;
    protected int keyMixer;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public IntByteHashMap() {
        this(4);
    }

    public IntByteHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntByteHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public IntByteHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public IntByteHashMap(IntByteAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public byte put(int key, byte value) {
        int existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == 0) {
            this.hasEmptyKey = true;
            byte previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return previousValue;
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                byte previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(IntByteAssociativeContainer container) {
        int count = this.size();
        for (IntByteCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends IntByteCursor> iterable) {
        int count = this.size();
        for (IntByteCursor intByteCursor : iterable) {
            this.put(intByteCursor.key, intByteCursor.value);
        }
        return this.size() - count;
    }

    public boolean putIfAbsent(int key, byte value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public byte putOrAdd(int key, byte putValue, byte incrementValue) {
        assert (this.assigned < this.mask + 1);
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue = (byte)(putValue + incrementValue);
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public byte addTo(int key, byte incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    @Override
    public byte remove(int key) {
        int existing;
        int mask = this.mask;
        if (key == 0) {
            this.hasEmptyKey = false;
            byte previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0;
            return previousValue;
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                byte previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public int removeAll(IntContainer other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof IntLookupContainer) {
            if (this.hasEmptyKey && other.contains(0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0;
            }
            int[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                int existing = keys[slot];
                if (existing != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (IntCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(IntBytePredicate predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply(0, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = 0;
        }
        int[] keys = this.keys;
        byte[] values = this.values;
        int slot = 0;
        while (slot <= mask) {
            int existing = keys[slot];
            if (existing != 0 && predicate.apply(existing, values[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply(0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0;
        }
        int[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            int existing = keys[slot];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public byte get(int key) {
        int existing;
        if (key == 0) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : (byte)0;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public byte getOrDefault(int key, byte defaultValue) {
        int existing;
        if (key == 0) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(int key) {
        int existing;
        if (key == 0) {
            return this.hasEmptyKey;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(int key) {
        int existing;
        int mask = this.mask;
        if (key == 0) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public byte indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    @Override
    public byte indexReplace(int index, byte newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        byte previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, int key, byte value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key == 0) {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == 0);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key, value);
            } else {
                this.keys[index] = key;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h2 = this.hasEmptyKey ? -559038737 : 0;
        for (IntByteCursor c : this) {
            h2 += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h2;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((IntByteHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(IntByteHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (IntByteCursor c : other) {
            int key = c.key;
            if (this.containsKey(key) && this.get(key) == c.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            int[] prevKeys = this.keys;
            byte[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public Iterator<IntByteCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends IntByteProcedure> T forEach(T procedure) {
        int[] keys = this.keys;
        byte[] values = this.values;
        if (this.hasEmptyKey) {
            procedure.apply(0, values[this.mask + 1]);
        }
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            if (keys[slot] == 0) continue;
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends IntBytePredicate> T forEach(T predicate) {
        int[] keys = this.keys;
        byte[] values = this.values;
        if (this.hasEmptyKey && !predicate.apply(0, values[this.mask + 1])) {
            return predicate;
        }
        int max = this.mask;
        for (int slot = 0; slot <= max && (keys[slot] == 0 || predicate.apply(keys[slot], values[slot])); ++slot) {
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ByteCollection values() {
        return new ValuesContainer();
    }

    public IntByteHashMap clone() {
        try {
            IntByteHashMap cloned = (IntByteHashMap)super.clone();
            cloned.keys = (int[])this.keys.clone();
            cloned.values = (byte[])this.values.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (IntByteCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return IntBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static IntByteHashMap from(int[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntByteHashMap map = new IntByteHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(int key) {
        assert (key != 0);
        return BitMixer.mix(key, this.keyMixer);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(int[] fromKeys, byte[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        int[] keys = this.keys;
        byte[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            int existing = fromKeys[from];
            if (existing == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        int[] prevKeys = this.keys;
        byte[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new int[arraySize + emptyElementSlot];
            this.values = new byte[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, int pendingKey, byte pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0 && pendingKey != 0);
        int[] prevKeys = this.keys;
        byte[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        int existing;
        int[] keys = this.keys;
        byte[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        values[gapSlot] = 0;
        --this.assigned;
    }

    private final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = IntByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ByteCursor();
        }

        @Override
        protected ByteCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    if (IntByteHashMap.this.keys[this.slot] != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.value = IntByteHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && IntByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = IntByteHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractByteCollection {
        private final IntByteHashMap owner;

        private ValuesContainer() {
            this.owner = IntByteHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(byte value) {
            for (IntByteCursor c : this.owner) {
                if (c.value != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            for (IntByteCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            for (IntByteCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(final byte e) {
            return this.owner.removeAll(new IntBytePredicate(){

                @Override
                public boolean apply(int key, byte value) {
                    return value == e;
                }
            });
        }

        @Override
        public int removeAll(final BytePredicate predicate) {
            return this.owner.removeAll(new IntBytePredicate(){

                @Override
                public boolean apply(int key, byte value) {
                    return predicate.apply(value);
                }
            });
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = IntByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    int existing = IntByteHashMap.this.keys[this.slot];
                    if (existing != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && IntByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final IntByteHashMap owner;

        public KeysContainer() {
            this.owner = IntByteHashMap.this;
        }

        @Override
        public boolean contains(int e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(final T procedure) {
            this.owner.forEach(new IntByteProcedure(){

                @Override
                public void apply(int key, byte value) {
                    procedure.apply(key);
                }
            });
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(final T predicate) {
            this.owner.forEach(new IntBytePredicate(){

                @Override
                public boolean apply(int key, byte value) {
                    return predicate.apply(key);
                }
            });
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(int e) {
            boolean hasKey = this.owner.containsKey(e);
            if (hasKey) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<IntByteCursor> {
        private final IntByteCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = IntByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntByteCursor();
        }

        @Override
        protected IntByteCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    int existing = IntByteHashMap.this.keys[this.slot];
                    if (existing != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.key = existing;
                        this.cursor.value = IntByteHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && IntByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0;
                this.cursor.value = IntByteHashMap.this.values[this.max];
                return this.cursor;
            }
            return (IntByteCursor)this.done();
        }
    }
}

