/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.costosys.dbconnection;

import de.julielab.costosys.configuration.FieldConfig;
import de.julielab.costosys.dbconnection.CoStoSysConnection;
import de.julielab.costosys.dbconnection.ConnectionClosable;
import de.julielab.costosys.dbconnection.DBCThreadedIterator;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.xml.JulieXMLTools;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Exchanger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedColumnsToRetrieveIterator
extends DBCThreadedIterator<byte[][]> {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadedColumnsToRetrieveIterator.class);
    private static int arrayResToListThreadCounter;
    private static int arrayFromDBThreadCounter;
    private DataBaseConnector dbc;

    public ThreadedColumnsToRetrieveIterator(DataBaseConnector dbc, CoStoSysConnection conn, List<Object[]> ids, String table, String schemaName) {
        this.dbc = dbc;
        String[] tables = new String[1];
        String[] schemaNames = new String[1];
        tables[0] = table;
        schemaNames[0] = schemaName;
        this.backgroundThread = new ArrayResToListThread(conn, this.listExchanger, ids, tables, null, schemaNames);
        this.update();
    }

    public ThreadedColumnsToRetrieveIterator(DataBaseConnector dbc, List<Object[]> ids, String table, String schemaName) {
        this(dbc, null, ids, table, schemaName);
    }

    public ThreadedColumnsToRetrieveIterator(DataBaseConnector dbc, List<Object[]> ids, String table, String whereClause, String schemaName) {
        this(dbc, null, ids, table, whereClause, schemaName);
    }

    public ThreadedColumnsToRetrieveIterator(DataBaseConnector dbc, CoStoSysConnection conn, List<Object[]> ids, String table, String whereClause, String schemaName) {
        this.dbc = dbc;
        String[] tables = new String[1];
        String[] schemaNames = new String[1];
        tables[0] = table;
        schemaNames[0] = schemaName;
        this.backgroundThread = new ArrayResToListThread(conn, this.listExchanger, ids, tables, whereClause, schemaNames);
        this.update();
    }

    public ThreadedColumnsToRetrieveIterator(DataBaseConnector dbc, CoStoSysConnection conn, List<Object[]> ids, String[] tables, String[] schemaNames) {
        this.dbc = dbc;
        this.backgroundThread = new ArrayResToListThread(conn, this.listExchanger, ids, tables, null, schemaNames);
        this.update();
    }

    public ThreadedColumnsToRetrieveIterator(DataBaseConnector dbc, List<Object[]> ids, String[] tables, String[] schemaNames) {
        this(dbc, null, ids, tables, schemaNames);
    }

    @Override
    public void close() {
        ((ArrayResToListThread)this.backgroundThread).end();
    }

    @Override
    public void join() throws InterruptedException {
        ((ArrayResToListThread)this.backgroundThread).join();
    }

    private class ArrayFromDBThread
    extends Thread
    implements ConnectionClosable {
        private final Logger log = LoggerFactory.getLogger(ArrayFromDBThread.class);
        private final boolean externalConnectionGiven;
        private Iterator<Object[]> keyIter;
        private Exchanger<ResultSet> resExchanger;
        private StringBuilder queryBuilder;
        private ResultSet currentRes;
        private String selectFrom;
        private CoStoSysConnection conn;
        private String whereClause = null;
        private FieldConfig fieldConfig;
        private volatile boolean end;
        private boolean joined = false;
        private String dataTable;
        private String dataSchema;

        public ArrayFromDBThread(CoStoSysConnection conn, Exchanger<ResultSet> resExchanger, List<Object[]> keyList, String[] table, String whereClause, String[] schemaName) {
            this.externalConnectionGiven = conn != null;
            this.conn = conn;
            this.resExchanger = resExchanger;
            this.keyIter = keyList.iterator();
            this.queryBuilder = new StringBuilder();
            this.whereClause = whereClause;
            this.dataTable = table[0];
            this.dataSchema = schemaName[0];
            if (table.length > 1 && schemaName.length > 1) {
                this.joined = true;
            }
            this.buildSelectFrom(table, schemaName);
            this.setName("ArrayFromDBThread-" + ++arrayFromDBThreadCounter);
            this.setDaemon(true);
            this.start();
        }

        private void buildSelectFrom(String[] table, String[] schemaName) {
            if (!this.joined) {
                this.fieldConfig = ThreadedColumnsToRetrieveIterator.this.dbc.getFieldConfiguration(this.dataSchema);
                this.selectFrom = "SELECT " + StringUtils.join((Object[])this.fieldConfig.getColumnsToRetrieve(), (String)",") + " FROM " + this.dataTable + " WHERE ";
            } else {
                String[] primaryKey = null;
                ArrayList<CallSite> select = new ArrayList<CallSite>();
                ArrayList<CallSite> leftJoin = new ArrayList<CallSite>();
                for (int i = 0; i < table.length; ++i) {
                    this.fieldConfig = ThreadedColumnsToRetrieveIterator.this.dbc.getFieldConfiguration(schemaName[i]);
                    String[] columnsToRetrieve = this.fieldConfig.getColumnsToRetrieve();
                    for (int j = 0; j < columnsToRetrieve.length; ++j) {
                        String column = table[i] + "." + columnsToRetrieve[j];
                        select.add((CallSite)((Object)column));
                    }
                    if (i == 0) {
                        primaryKey = this.fieldConfig.getPrimaryKey();
                        continue;
                    }
                    Object primaryKeyMatch = "";
                    for (int j = 0; j < primaryKey.length; ++j) {
                        primaryKeyMatch = table[0] + "." + primaryKey[j] + "=" + table[i] + "." + primaryKey[j];
                        if (j == primaryKey.length - 1) continue;
                        primaryKeyMatch = (String)primaryKeyMatch + " AND ";
                    }
                    String join = "LEFT JOIN " + table[i] + " ON " + (String)primaryKeyMatch;
                    leftJoin.add((CallSite)((Object)join));
                }
                this.selectFrom = "SELECT " + StringUtils.join(select, (String)",") + " FROM " + table[0] + " " + StringUtils.join(leftJoin, (String)" ") + " WHERE ";
                this.log.trace("Querying data via SQL: {}", (Object)this.selectFrom);
            }
        }

        @Override
        public void run() {
            if (!this.externalConnectionGiven) {
                this.conn = ThreadedColumnsToRetrieveIterator.this.dbc.obtainOrReserveConnection();
            } else {
                this.conn.incrementUsageNumber();
            }
            try {
                while (this.keyIter.hasNext() && !this.end) {
                    this.currentRes = this.getFromDB();
                    this.resExchanger.exchange(this.currentRes);
                }
                this.resExchanger.exchange(null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
            this.log.debug("ArrayFromDBThread has finished");
        }

        private ResultSet getFromDB() {
            ResultSet res = null;
            String sql = null;
            try {
                this.queryBuilder.delete(0, this.queryBuilder.capacity());
                Statement stmt = this.conn.createStatement();
                ArrayList<CallSite> pkConjunction = new ArrayList<CallSite>();
                for (int i = 0; this.keyIter.hasNext() && i < ThreadedColumnsToRetrieveIterator.this.dbc.getQueryBatchSize(); ++i) {
                    String fieldName;
                    int j;
                    Object[] keys = this.keyIter.next();
                    Object[] nameValuePairs = new String[keys.length];
                    if (!this.joined) {
                        for (j = 0; j < keys.length; ++j) {
                            fieldName = this.fieldConfig.getPrimaryKey()[j];
                            nameValuePairs[j] = String.format("%s = '%s'", fieldName, keys[j]);
                        }
                    } else {
                        for (j = 0; j < keys.length; ++j) {
                            fieldName = this.fieldConfig.getPrimaryKey()[j];
                            nameValuePairs[j] = String.format("%s = '%s'", this.dataTable + "." + fieldName, keys[j]);
                        }
                    }
                    pkConjunction.add((CallSite)((Object)("(" + StringUtils.join((Object[])nameValuePairs, (String)" AND ") + ")")));
                }
                this.queryBuilder.append(this.selectFrom);
                this.queryBuilder.append("(");
                this.queryBuilder.append(StringUtils.join(pkConjunction, (String)" OR "));
                this.queryBuilder.append(")");
                if (this.whereClause != null) {
                    this.queryBuilder.append(" AND " + this.whereClause);
                }
                sql = this.queryBuilder.toString();
                LOG.trace("Fetching data with command \"{}\"", (Object)sql);
                res = stmt.executeQuery(sql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                LOG.error("SQL: " + sql);
            }
            return res;
        }

        public void end() {
            this.end = true;
            this.closeConnection();
        }

        @Override
        public void closeConnection() {
            this.conn.close();
        }
    }

    private class ArrayResToListThread
    extends Thread
    implements ConnectionClosable {
        private final Logger log = LoggerFactory.getLogger(ArrayResToListThread.class);
        private final ArrayFromDBThread arrayFromDBThread;
        private Exchanger<List<byte[][]>> listExchanger;
        private Exchanger<ResultSet> resExchanger = new Exchanger();
        private ResultSet currentRes;
        private ArrayList<byte[][]> currentList;
        private String[] schemaName;
        private boolean joined = false;
        private volatile boolean end = false;

        ArrayResToListThread(CoStoSysConnection conn, Exchanger<List<byte[][]>> listExchanger, List<Object[]> keyList, String[] tables, String whereClause, String[] schemaName) {
            this.listExchanger = listExchanger;
            this.schemaName = schemaName;
            if (tables.length > 1) {
                this.joined = true;
            }
            this.arrayFromDBThread = new ArrayFromDBThread(conn, this.resExchanger, keyList, tables, whereClause, schemaName);
            try {
                this.currentRes = this.resExchanger.exchange(null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setName("ArrayRestoListThread-" + ++arrayResToListThreadCounter);
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            Pair<Integer, List<Map<String, String>>> numColumnsAndFields = ThreadedColumnsToRetrieveIterator.this.dbc.getNumColumnsAndFields(this.joined, this.schemaName);
            int numColumns = (Integer)numColumnsAndFields.getLeft();
            List fields = (List)numColumnsAndFields.getRight();
            int i = 0;
            byte[][] retrievedData = null;
            try {
                while (this.currentRes != null && !this.end) {
                    this.currentList = new ArrayList();
                    while (this.currentRes.next()) {
                        retrievedData = new byte[numColumns][];
                        for (i = 0; i < retrievedData.length; ++i) {
                            retrievedData[i] = this.currentRes.getBytes(i + 1);
                            if (!Boolean.parseBoolean((String)((Map)fields.get(i)).get("gzip")) || retrievedData[i] == null) continue;
                            try {
                                retrievedData[i] = JulieXMLTools.unGzipData((byte[])retrievedData[i]);
                                continue;
                            }
                            catch (ZipException e) {
                                this.log.warn("Got error with message {}. The data for column {} is flagged to be in GZIP format but it wasn't. The original data is returned instead of un-gzipped data.", (Object)e.getMessage(), ((Map)fields.get(i)).get("name"));
                            }
                        }
                        this.currentList.add(retrievedData);
                    }
                    if (!this.currentList.isEmpty()) {
                        this.listExchanger.exchange(this.currentList);
                    }
                    this.currentRes = this.resExchanger.exchange(null);
                }
                this.listExchanger.exchange(null);
            }
            catch (IOException | InterruptedException | SQLException e) {
                this.log.error("Exception occured while reading data from result set, index {}. Corresponding field in schema definition is: {}. Read data was: \"{}\"", new Object[]{i + 1, fields.get(i), new String(retrievedData[i], StandardCharsets.UTF_8)});
                byte[][] d = retrievedData;
                this.log.error("All retrieved data was {}", IntStream.rangeClosed(0, i).mapToObj(j -> new String(d[j], StandardCharsets.UTF_8)).collect(Collectors.toList()));
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                this.log.debug("NPE on: Index {}, field {}, data {}", new Object[]{i, fields.get(i), retrievedData != null ? retrievedData[i] : null});
                throw e;
            }
            this.log.debug("ArrayResToListThread has finished");
        }

        public void end() {
            this.arrayFromDBThread.end();
            this.end = true;
        }

        @Override
        public void closeConnection() {
            this.arrayFromDBThread.closeConnection();
        }
    }
}

