/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.costosys.dbconnection;

import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.costosys.dbconnection.util.CoStoSysSQLRuntimeException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoStoSysConnection
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(CoStoSysConnection.class);
    private DataBaseConnector dbc;
    private Connection connection;
    private AtomicInteger numUsing;

    public CoStoSysConnection(DataBaseConnector dbc, Connection connection, boolean newlyReserved) {
        this.dbc = dbc;
        this.connection = connection;
        this.numUsing = new AtomicInteger(1);
        log.trace("Initial usage: Connection {} is now used {} times by thread {}", new Object[]{connection, this.numUsing.get(), Thread.currentThread().getName()});
    }

    public void incrementUsageNumber() {
        this.numUsing.incrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace("Increased usage by thread {}: Connection {} is now used {} times", new Object[]{Thread.currentThread().getName(), this.connection, this.numUsing.get()});
        }
    }

    public synchronized void release() throws SQLException {
        int num = this.numUsing.decrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace("Decreased usage by thread {}: Connection {} is now used {} times", new Object[]{Thread.currentThread().getName(), this.connection, this.numUsing.get()});
        }
        if (num == 0) {
            log.trace("Connection {} is not used any more and is released", (Object)this.connection);
            this.dbc.releaseConnection(this);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void close() {
        try {
            this.release();
        }
        catch (SQLException e) {
            throw new CoStoSysSQLRuntimeException(e);
        }
    }

    public Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(sql);
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    public void setAutoCommit(boolean b) throws SQLException {
        this.connection.setAutoCommit(b);
    }
}

