/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.costosys.configuration;

import com.ximpleware.AutoPilot;
import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import de.julielab.costosys.configuration.ConfigBase;
import de.julielab.costosys.configuration.DBConfig;
import de.julielab.costosys.configuration.FieldConfig;
import de.julielab.costosys.configuration.FieldConfigurationManager;
import de.julielab.xml.JulieXMLTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigReader {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigReader.class);
    private static final String DEFAULT_DEFINITION = "/defaultConfiguration.xml";
    static final String XPATH_ACTIVE_TABLE_SCHEMA = "//activeTableSchema";
    private static final String XPATH_ACTIVE_DB = "//activeDBConnection";
    private static final String XPATH_ACTIVE_PG_SCHEMA = "//activePostgresSchema";
    private static final String XPATH_MAX_CONNS = "//maxActiveDBConnections";
    private static final String XPATH_CONF_DBS = "//DBConnections";
    private static final String XPATH_CONF_SCHEMAS = "//tableSchemas";
    private static final String XPATH_CONF_DB = "//DBConnection";
    private static final String XPATH_CONF_SCHEMA = "//tableSchema";
    private static final int INDEX_SCHEMA = 0;
    private static final int INDEX_DB = 1;
    private static final int INDEX_PG_SCHEMA = 2;
    private static final int INDEX_MAX_CONNS = 3;
    private static final int INDEX_DATA_TABLE = 4;
    private static final int INDEX_DATA_SCHEMA = 5;
    private static final String XPATH_DATA_TABLE = "//dataTable";
    private static final String XPATH_DATA_SCHEMA = "//activeDataPostgresSchema";
    private static final String ATTRIBUTE_NAME = "name";
    private FieldConfigurationManager fieldConfigs;
    private DBConfig dbConf;
    private String activeDataTable;
    private String activeSchemaName;
    private byte[] mergedConfigData;
    private String activeDataSchema;
    private List<String> schemaNames;

    public ConfigReader(InputStream def) {
        try {
            byte[] userConfData = null;
            InputStream is = this.getClass().getResourceAsStream(DEFAULT_DEFINITION);
            byte[] defaultConfData = IOUtils.toByteArray((InputStream)is);
            is.close();
            if (def != null) {
                userConfData = IOUtils.toByteArray((InputStream)def);
                def.close();
            }
            this.mergedConfigData = ConfigReader.mergeConfigData(defaultConfData, userConfData);
            this.schemaNames = this.getAllSchemaNames(this.mergedConfigData);
            this.fieldConfigs = new FieldConfigurationManager();
            for (String schemaName : this.schemaNames) {
                this.fieldConfigs.put(schemaName, new FieldConfig(this.mergedConfigData, schemaName));
            }
            this.dbConf = new DBConfig(this.mergedConfigData);
            this.activeDataTable = ConfigBase.getActiveConfig(this.mergedConfigData, XPATH_DATA_TABLE);
            this.activeDataSchema = ConfigBase.getActiveConfig(this.mergedConfigData, XPATH_DATA_SCHEMA);
            this.activeSchemaName = ConfigBase.getActiveConfig(this.mergedConfigData, XPATH_ACTIVE_TABLE_SCHEMA);
            LOG.debug("Active data table: {}", (Object)this.activeDataTable);
            LOG.debug("Active Postgres data schema: {}", (Object)this.activeDataSchema);
            LOG.debug("Active table schema: {}", (Object)this.activeSchemaName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (VTDException e) {
            LOG.error("Parsing of configuration file failed:", (Throwable)e);
        }
    }

    private List<String> getAllSchemaNames(byte[] mergedConfigData) throws VTDException {
        ArrayList<String> schemaNames = new ArrayList<String>();
        VTDGen vg = new VTDGen();
        vg.setDoc(mergedConfigData);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot schemaAP = new AutoPilot(vn);
        schemaAP.selectXPath(XPATH_CONF_SCHEMA);
        AutoPilot schemaNameAP = new AutoPilot(vn);
        schemaNameAP.selectXPath("@name");
        while (schemaAP.evalXPath() != -1) {
            schemaNames.add(schemaNameAP.evalXPathToString());
        }
        return schemaNames;
    }

    private static byte[] mergeConfigData(byte[] defaultConfData, byte[] userConfData) throws VTDException, IOException {
        int newTextIndex;
        VTDGen vg = new VTDGen();
        vg.setDoc(defaultConfData);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        if (userConfData == null) {
            return defaultConfData;
        }
        XMLModifier xm = new XMLModifier(vn);
        byte[][] userDefs = ConfigReader.extractConfigData(userConfData);
        if (userDefs[0] != null) {
            ap.selectXPath(XPATH_CONF_SCHEMA);
            if (ap.evalXPath() != -1) {
                xm.insertAfterElement(userDefs[0]);
            }
        }
        if (userDefs[1] != null) {
            ap.selectXPath(XPATH_CONF_DB);
            if (ap.evalXPath() != -1) {
                xm.insertAfterElement(userDefs[1]);
            }
        }
        Object[] activeConfs = ConfigReader.getActiveConfigurations(userConfData);
        LOG.debug("Found the following active configurations in the user data: {}", (Object)Arrays.toString(activeConfs));
        if (((String)activeConfs[0]).length() > 0) {
            newTextIndex = JulieXMLTools.setElementText((VTDNav)vn, (AutoPilot)ap, (XMLModifier)xm, (String)XPATH_ACTIVE_TABLE_SCHEMA, (String)activeConfs[0]);
            LOG.trace("Set the active table schema to {}. Returned new index: {}", activeConfs[0], (Object)newTextIndex);
            if (newTextIndex == -1) {
                throw new IllegalStateException("There is no active table schema defined. Please define an active table schema in your user  configuration. The user configuration is: " + new String(userConfData, StandardCharsets.UTF_8));
            }
        }
        if (((String)activeConfs[1]).length() > 0 && (newTextIndex = JulieXMLTools.setElementText((VTDNav)vn, (AutoPilot)ap, (XMLModifier)xm, (String)XPATH_ACTIVE_DB, (String)activeConfs[1])) == -1) {
            LOG.warn("The default configuration does not define an active database connection.");
        }
        if (((String)activeConfs[2]).length() > 0 && (newTextIndex = JulieXMLTools.setElementText((VTDNav)vn, (AutoPilot)ap, (XMLModifier)xm, (String)XPATH_ACTIVE_PG_SCHEMA, (String)activeConfs[2])) == -1) {
            throw new IllegalStateException("Unexpected error: The default configuration does not define an active Postgres schema. Please define an active Postgres schema in your user configuration.");
        }
        if (((String)activeConfs[3]).length() > 0 && (newTextIndex = JulieXMLTools.setElementText((VTDNav)vn, (AutoPilot)ap, (XMLModifier)xm, (String)XPATH_MAX_CONNS, (String)activeConfs[3])) == -1) {
            LOG.warn("Unexpected error: The default configuration does not define a maximal number of database connections");
        }
        if (((String)activeConfs[4]).length() > 0 && (newTextIndex = JulieXMLTools.setElementText((VTDNav)vn, (AutoPilot)ap, (XMLModifier)xm, (String)XPATH_DATA_TABLE, (String)activeConfs[4])) == -1) {
            throw new IllegalStateException("Unexpected error: The default configuration does not define a _data table. Please define a _data table in your user configuration.");
        }
        if (((String)activeConfs[5]).length() > 0 && (newTextIndex = JulieXMLTools.setElementText((VTDNav)vn, (AutoPilot)ap, (XMLModifier)xm, (String)XPATH_DATA_SCHEMA, (String)activeConfs[5])) == -1) {
            throw new IllegalStateException("Unexpected error: The default configuration does not define an active data Postgres schema. Please define a data postgres schema in your user configuration.");
        }
        vn = xm.outputAndReparse();
        String doublet = ConfigReader.getDoublet(vn, XPATH_CONF_SCHEMA);
        if (doublet != null) {
            throw new IllegalStateException("Unexpected error: You may not define " + doublet + "as this schema is already defined in the default configuration!");
        }
        doublet = ConfigReader.getDoublet(vn, XPATH_CONF_DB);
        if (doublet != null) {
            throw new IllegalStateException("Unexpected error: You may not define " + doublet + "as this connection is already defined in the default configuration!");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        xm.output((OutputStream)os);
        return os.toByteArray();
    }

    private static String getDoublet(VTDNav vn, String xpath) {
        String doublet = "";
        AutoPilot ap = new AutoPilot(vn);
        try {
            ap.selectXPath(xpath);
            int index = ap.evalXPath();
            HashSet<String> found = new HashSet<String>();
            while (index != -1) {
                int attrIndex = vn.getAttrVal(ATTRIBUTE_NAME);
                if (attrIndex != -1) {
                    String name = vn.toString(attrIndex);
                    if (found.contains(name)) {
                        doublet = doublet.concat(name).concat(", ");
                    } else {
                        found.add(name);
                    }
                }
                index = ap.evalXPath();
            }
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new IllegalStateException(e);
        }
        return doublet.equals("") ? null : doublet;
    }

    private static String[] getActiveConfigurations(byte[] confData) throws VTDException {
        VTDGen vg = new VTDGen();
        vg.setDoc(confData);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        String[] activeConfigurations = new String[6];
        ap.selectXPath(XPATH_ACTIVE_PG_SCHEMA);
        activeConfigurations[2] = ap.evalXPathToString();
        ap.selectXPath(XPATH_ACTIVE_TABLE_SCHEMA);
        activeConfigurations[0] = ap.evalXPathToString();
        ap.selectXPath(XPATH_ACTIVE_DB);
        activeConfigurations[1] = ap.evalXPathToString();
        ap.selectXPath(XPATH_MAX_CONNS);
        activeConfigurations[3] = ap.evalXPathToString();
        ap.selectXPath(XPATH_DATA_TABLE);
        activeConfigurations[4] = ap.evalXPathToString();
        ap.selectXPath(XPATH_DATA_SCHEMA);
        activeConfigurations[5] = ap.evalXPathToString();
        return activeConfigurations;
    }

    private static byte[][] extractConfigData(byte[] confData) throws VTDException {
        String fragment;
        byte[][] configData = new byte[2][];
        VTDGen vg = new VTDGen();
        vg.setDoc(confData);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        ap.selectXPath(XPATH_CONF_SCHEMAS);
        if (ap.evalXPath() != -1) {
            fragment = JulieXMLTools.getFragment((VTDNav)vn, (int)1, (boolean)true);
            configData[0] = fragment.getBytes();
        }
        ap.selectXPath(XPATH_CONF_DBS);
        if (ap.evalXPath() != -1) {
            fragment = JulieXMLTools.getFragment((VTDNav)vn, (int)1, (boolean)true);
            configData[1] = fragment.getBytes();
        }
        return configData;
    }

    public DBConfig getDatabaseConfig() {
        return this.dbConf;
    }

    public FieldConfigurationManager getFieldConfigs() {
        return this.fieldConfigs;
    }

    public String getActiveDataTable() {
        return this.activeDataTable;
    }

    public String getActiveDataSchema() {
        return this.activeDataSchema;
    }

    public String getActiveSchemaName() {
        return this.activeSchemaName;
    }

    public byte[] getMergedConfigData() {
        return this.mergedConfigData;
    }

    public List<String> getTableSchemaNames() {
        return this.schemaNames;
    }
}

