/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public class BytesTransportRequest
extends TransportRequest {
    BytesReference bytes;
    Version version;

    public BytesTransportRequest() {
    }

    public BytesTransportRequest(BytesReference bytes, Version version2) {
        this.bytes = bytes;
        this.version = version2;
    }

    public Version version() {
        return this.version;
    }

    public BytesReference bytes() {
        return this.bytes;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.bytes = in.readBytesReference();
        this.version = in.getVersion();
    }

    public void writeThin(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.bytes.length());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.bytes);
    }
}

