/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.mapper.CompletionFieldMapper;
import org.elasticsearch.index.mapper.CompletionFieldMapper2x;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionContext;
import org.elasticsearch.search.suggest.completion.FuzzyOptions;
import org.elasticsearch.search.suggest.completion.RegexOptions;
import org.elasticsearch.search.suggest.completion.context.ContextMapping;
import org.elasticsearch.search.suggest.completion2x.context.CategoryContextMapping;
import org.elasticsearch.search.suggest.completion2x.context.ContextMapping;
import org.elasticsearch.search.suggest.completion2x.context.GeolocationContextMapping;

public class CompletionSuggestionBuilder
extends SuggestionBuilder<CompletionSuggestionBuilder> {
    static final String SUGGESTION_NAME = "completion";
    static final ParseField CONTEXTS_FIELD = new ParseField("contexts", "context");
    private static final ObjectParser<InnerBuilder, Void> PARSER = new ObjectParser("completion", null);
    protected FuzzyOptions fuzzyOptions;
    protected RegexOptions regexOptions;
    protected BytesReference contextBytes = null;

    public CompletionSuggestionBuilder(String field) {
        super(field);
    }

    private CompletionSuggestionBuilder(String fieldname, CompletionSuggestionBuilder in) {
        super(fieldname, in);
        this.fuzzyOptions = in.fuzzyOptions;
        this.regexOptions = in.regexOptions;
        this.contextBytes = in.contextBytes;
    }

    public CompletionSuggestionBuilder(StreamInput in) throws IOException {
        super(in);
        this.fuzzyOptions = in.readOptionalWriteable(FuzzyOptions::new);
        this.regexOptions = in.readOptionalWriteable(RegexOptions::new);
        this.contextBytes = in.readOptionalBytesReference();
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.fuzzyOptions);
        out.writeOptionalWriteable(this.regexOptions);
        out.writeOptionalBytesReference(this.contextBytes);
    }

    @Override
    public CompletionSuggestionBuilder prefix(String prefix) {
        super.prefix(prefix);
        return this;
    }

    public CompletionSuggestionBuilder prefix(String prefix, Fuzziness fuzziness) {
        super.prefix(prefix);
        this.fuzzyOptions = new FuzzyOptions.Builder().setFuzziness(fuzziness).build();
        return this;
    }

    public CompletionSuggestionBuilder prefix(String prefix, FuzzyOptions fuzzyOptions) {
        super.prefix(prefix);
        this.fuzzyOptions = fuzzyOptions;
        return this;
    }

    @Override
    public CompletionSuggestionBuilder regex(String regex) {
        super.regex(regex);
        return this;
    }

    public CompletionSuggestionBuilder regex(String regex, RegexOptions regexOptions) {
        this.regex(regex);
        this.regexOptions = regexOptions;
        return this;
    }

    public CompletionSuggestionBuilder contexts(Map<String, List<? extends ToXContent>> queryContexts) {
        Objects.requireNonNull(queryContexts, "contexts must not be null");
        try {
            XContentBuilder contentBuilder = XContentFactory.jsonBuilder();
            contentBuilder.startObject();
            for (Map.Entry<String, List<? extends ToXContent>> contextEntry : queryContexts.entrySet()) {
                contentBuilder.startArray(contextEntry.getKey());
                for (ToXContent toXContent : contextEntry.getValue()) {
                    toXContent.toXContent(contentBuilder, EMPTY_PARAMS);
                }
                contentBuilder.endArray();
            }
            contentBuilder.endObject();
            return this.contexts(contentBuilder);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private CompletionSuggestionBuilder contexts(XContentBuilder contextBuilder) {
        this.contextBytes = contextBuilder.bytes();
        return this;
    }

    public CompletionSuggestionBuilder contexts(Contexts2x contexts2x) {
        Objects.requireNonNull(contexts2x, "contexts must not be null");
        try {
            XContentBuilder contentBuilder = XContentFactory.jsonBuilder();
            contentBuilder.startObject();
            for (ContextMapping.ContextQuery contextQuery : contexts2x.contextQueries) {
                contextQuery.toXContent(contentBuilder, EMPTY_PARAMS);
            }
            contentBuilder.endObject();
            return this.contexts(contentBuilder);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.fuzzyOptions != null) {
            this.fuzzyOptions.toXContent(builder, params);
        }
        if (this.regexOptions != null) {
            this.regexOptions.toXContent(builder, params);
        }
        if (this.contextBytes != null) {
            builder.rawField(CONTEXTS_FIELD.getPreferredName(), this.contextBytes);
        }
        return builder;
    }

    public static CompletionSuggestionBuilder fromXContent(XContentParser parser2) throws IOException {
        InnerBuilder builder = new InnerBuilder();
        PARSER.parse(parser2, builder, null);
        String field = builder.field;
        if (field == null) {
            throw new ElasticsearchParseException("the required field option [" + FIELDNAME_FIELD.getPreferredName() + "] is missing", new Object[0]);
        }
        return new CompletionSuggestionBuilder(field, builder);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public SuggestionSearchContext.SuggestionContext build(QueryShardContext context) throws IOException {
        block35: {
            block34: {
                suggestionContext = new CompletionSuggestionContext(context);
                mapperService = context.getMapperService();
                this.populateCommonFields(mapperService, suggestionContext);
                suggestionContext.setFuzzyOptions(this.fuzzyOptions);
                suggestionContext.setRegexOptions(this.regexOptions);
                mappedFieldType = mapperService.fullName(suggestionContext.getField());
                if (mappedFieldType == null || !(mappedFieldType instanceof CompletionFieldMapper.CompletionFieldType) && !(mappedFieldType instanceof CompletionFieldMapper2x.CompletionFieldType)) {
                    throw new IllegalArgumentException("Field [" + suggestionContext.getField() + "] is not a completion suggest field");
                }
                if (!(mappedFieldType instanceof CompletionFieldMapper.CompletionFieldType)) break block34;
                type = (CompletionFieldMapper.CompletionFieldType)mappedFieldType;
                suggestionContext.setFieldType(type);
                if (type.hasContextMappings() && this.contextBytes != null) {
                    contextParser = XContentFactory.xContent(this.contextBytes).createParser(context.getXContentRegistry(), this.contextBytes);
                    var7_9 = null;
                    try {
                        if (!type.hasContextMappings() || contextParser == null) ** GOTO lbl79
                        contextMappings = type.getContextMappings();
                        contextParser.nextToken();
                        queryContexts = new HashMap<String, List<ContextMapping.InternalQueryContext>>(contextMappings.size());
                        if (!CompletionSuggestionBuilder.$assertionsDisabled && contextParser.currentToken() != XContentParser.Token.START_OBJECT) {
                            throw new AssertionError();
                        }
                        while ((currentToken = contextParser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (currentToken != XContentParser.Token.FIELD_NAME) continue;
                            currentFieldName = contextParser.currentName();
                            mapping = contextMappings.get(currentFieldName);
                            queryContexts.put(currentFieldName, mapping.parseQueryContext(context.newParseContext(contextParser)));
                        }
                        suggestionContext.setQueryContexts(queryContexts);
                    }
                    catch (Throwable var8_13) {
                        var7_9 = var8_13;
                        throw var8_13;
                    }
                    finally {
                        if (contextParser != null) {
                            if (var7_9 != null) {
                                try {
                                    contextParser.close();
                                }
                                catch (Throwable var8_12) {
                                    var7_9.addSuppressed(var8_12);
                                }
                            } else {
                                contextParser.close();
                            }
                        }
                    }
                } else if (this.contextBytes != null) {
                    throw new IllegalArgumentException("suggester [" + type.name() + "] doesn't expect any context");
                }
                break block35;
            }
            if (!(mappedFieldType instanceof CompletionFieldMapper2x.CompletionFieldType)) break block35;
            type = (CompletionFieldMapper2x.CompletionFieldType)mappedFieldType;
            suggestionContext.setFieldType2x(type);
            if (!type.requiresContext()) ** GOTO lbl77
            if (this.contextBytes != null) {
                contextParser = XContentFactory.xContent(this.contextBytes).createParser(suggestionContext.getShardContext().getXContentRegistry(), this.contextBytes);
                var7_10 = null;
                try {
                    contextParser.nextToken();
                    suggestionContext.setContextQueries(ContextMapping.ContextQuery.parseQueries(type.getContextMapping(), contextParser));
                }
                catch (Throwable var8_15) {
                    var7_10 = var8_15;
                    throw var8_15;
                }
                finally {
                    if (contextParser != null) {
                        if (var7_10 != null) {
                            try {
                                contextParser.close();
                            }
                            catch (Throwable var8_14) {
                                var7_10.addSuppressed(var8_14);
                            }
                        } else {
                            contextParser.close();
                        }
                    }
                }
            } else {
                throw new IllegalArgumentException("suggester [completion] requires context to be setup");
lbl77:
                // 1 sources

                if (this.contextBytes != null) {
                    throw new IllegalArgumentException("suggester [completion] doesn't expect any context");
                }
            }
        }
        if (!CompletionSuggestionBuilder.$assertionsDisabled && suggestionContext.getFieldType() == null && suggestionContext.getFieldType2x() == null) {
            throw new AssertionError((Object)"no completion field type set");
        }
        return suggestionContext;
    }

    @Override
    public String getWriteableName() {
        return SUGGESTION_NAME;
    }

    @Override
    protected boolean doEquals(CompletionSuggestionBuilder other) {
        return Objects.equals(this.fuzzyOptions, other.fuzzyOptions) && Objects.equals(this.regexOptions, other.regexOptions) && Objects.equals(this.contextBytes, other.contextBytes);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fuzzyOptions, this.regexOptions, this.contextBytes);
    }

    static {
        PARSER.declareField((parser2, completionSuggestionContext, context) -> {
            if (parser2.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                if (parser2.booleanValue()) {
                    completionSuggestionContext.fuzzyOptions = new FuzzyOptions.Builder().build();
                }
            } else {
                completionSuggestionContext.fuzzyOptions = FuzzyOptions.parse(parser2);
            }
        }, FuzzyOptions.FUZZY_OPTIONS, ObjectParser.ValueType.OBJECT_OR_BOOLEAN);
        PARSER.declareField((parser2, completionSuggestionContext, context) -> {
            completionSuggestionContext.regexOptions = RegexOptions.parse(parser2);
        }, RegexOptions.REGEX_OPTIONS, ObjectParser.ValueType.OBJECT);
        PARSER.declareString((rec$, x$0) -> ((InnerBuilder)rec$).field(x$0), FIELDNAME_FIELD);
        PARSER.declareString(SuggestionBuilder::analyzer, ANALYZER_FIELD);
        PARSER.declareInt(SuggestionBuilder::size, SIZE_FIELD);
        PARSER.declareInt(SuggestionBuilder::shardSize, SHARDSIZE_FIELD);
        PARSER.declareField((p, v, c) -> {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.copyCurrentStructure(p);
            v.contextBytes = builder.bytes();
            p.skipChildren();
        }, CONTEXTS_FIELD, ObjectParser.ValueType.OBJECT);
    }

    private static class InnerBuilder
    extends CompletionSuggestionBuilder {
        private String field;

        InnerBuilder() {
            super("_na_");
        }

        private InnerBuilder field(String field) {
            this.field = field;
            return this;
        }
    }

    public static class Contexts2x {
        private List<ContextMapping.ContextQuery> contextQueries = new ArrayList<ContextMapping.ContextQuery>();

        private Contexts2x addContextQuery(ContextMapping.ContextQuery ctx) {
            this.contextQueries.add(ctx);
            return this;
        }

        @Deprecated
        public Contexts2x addGeoLocation(String name, double lat, double lon, int ... precisions) {
            return this.addContextQuery(GeolocationContextMapping.query(name, lat, lon, precisions));
        }

        @Deprecated
        public Contexts2x addGeoLocationWithPrecision(String name, double lat, double lon, String ... precisions) {
            return this.addContextQuery(GeolocationContextMapping.query(name, lat, lon, precisions));
        }

        @Deprecated
        public Contexts2x addGeoLocation(String name, String geohash) {
            return this.addContextQuery(GeolocationContextMapping.query(name, geohash, new int[0]));
        }

        @Deprecated
        public Contexts2x addCategory(String name, CharSequence ... categories) {
            return this.addContextQuery(CategoryContextMapping.query(name, categories));
        }

        @Deprecated
        public Contexts2x addCategory(String name, Iterable<? extends CharSequence> categories) {
            return this.addContextQuery(CategoryContextMapping.query(name, categories));
        }

        @Deprecated
        public Contexts2x addContextField(String name, CharSequence ... fieldvalues) {
            return this.addContextQuery(CategoryContextMapping.query(name, fieldvalues));
        }

        @Deprecated
        public Contexts2x addContextField(String name, Iterable<? extends CharSequence> fieldvalues) {
            return this.addContextQuery(CategoryContextMapping.query(name, fieldvalues));
        }
    }
}

