/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortFieldAndFormat;
import org.elasticsearch.search.sort.SortMode;
import org.elasticsearch.search.sort.SortOrder;

public class ScriptSortBuilder
extends SortBuilder<ScriptSortBuilder> {
    public static final String NAME = "_script";
    public static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    public static final ParseField SCRIPT_FIELD = new ParseField("script", new String[0]);
    public static final ParseField SORTMODE_FIELD = new ParseField("mode", new String[0]);
    private final Script script;
    private final ScriptSortType type;
    private SortMode sortMode;
    private QueryBuilder nestedFilter;
    private String nestedPath;
    private static ConstructingObjectParser<ScriptSortBuilder, QueryParseContext> PARSER = new ConstructingObjectParser("_script", a -> new ScriptSortBuilder((Script)a[0], (ScriptSortType)a[1]));

    public ScriptSortBuilder(Script script, ScriptSortType type) {
        Objects.requireNonNull(script, "script cannot be null");
        Objects.requireNonNull(type, "type cannot be null");
        this.script = script;
        this.type = type;
    }

    ScriptSortBuilder(ScriptSortBuilder original) {
        this.script = original.script;
        this.type = original.type;
        this.order = original.order;
        this.sortMode = original.sortMode;
        this.nestedFilter = original.nestedFilter;
        this.nestedPath = original.nestedPath;
    }

    public ScriptSortBuilder(StreamInput in) throws IOException {
        this.script = new Script(in);
        this.type = ScriptSortType.readFromStream(in);
        this.order = SortOrder.readFromStream(in);
        this.sortMode = in.readOptionalWriteable(SortMode::readFromStream);
        this.nestedPath = in.readOptionalString();
        this.nestedFilter = in.readOptionalNamedWriteable(QueryBuilder.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
        this.type.writeTo(out);
        this.order.writeTo(out);
        out.writeOptionalWriteable(this.sortMode);
        out.writeOptionalString(this.nestedPath);
        out.writeOptionalNamedWriteable(this.nestedFilter);
    }

    public Script script() {
        return this.script;
    }

    public ScriptSortType type() {
        return this.type;
    }

    public ScriptSortBuilder sortMode(SortMode sortMode) {
        Objects.requireNonNull(sortMode, "sort mode cannot be null.");
        if (ScriptSortType.STRING.equals(this.type) && (sortMode == SortMode.SUM || sortMode == SortMode.AVG || sortMode == SortMode.MEDIAN)) {
            throw new IllegalArgumentException("script sort of type [string] doesn't support mode [" + sortMode + "]");
        }
        this.sortMode = sortMode;
        return this;
    }

    public SortMode sortMode() {
        return this.sortMode;
    }

    public ScriptSortBuilder setNestedFilter(QueryBuilder nestedFilter) {
        this.nestedFilter = nestedFilter;
        return this;
    }

    public QueryBuilder getNestedFilter() {
        return this.nestedFilter;
    }

    public ScriptSortBuilder setNestedPath(String nestedPath) {
        this.nestedPath = nestedPath;
        return this;
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.field(SCRIPT_FIELD.getPreferredName(), this.script);
        builder.field(TYPE_FIELD.getPreferredName(), this.type);
        builder.field(ORDER_FIELD.getPreferredName(), this.order);
        if (this.sortMode != null) {
            builder.field(SORTMODE_FIELD.getPreferredName(), this.sortMode);
        }
        if (this.nestedPath != null) {
            builder.field(NESTED_PATH_FIELD.getPreferredName(), this.nestedPath);
        }
        if (this.nestedFilter != null) {
            builder.field(NESTED_FILTER_FIELD.getPreferredName(), this.nestedFilter, builderParams);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static ScriptSortBuilder fromXContent(QueryParseContext context, String elementName) throws IOException {
        return PARSER.apply(context.parser(), context);
    }

    @Override
    public SortFieldAndFormat build(QueryShardContext context) throws IOException {
        IndexFieldData.XFieldComparatorSource fieldComparatorSource;
        boolean reverse;
        final SearchScript searchScript = context.getSearchScript(this.script, ScriptContext.Standard.SEARCH);
        MultiValueMode valueMode = null;
        if (this.sortMode != null) {
            valueMode = MultiValueMode.fromString(this.sortMode.toString());
        }
        boolean bl = reverse = this.order == SortOrder.DESC;
        if (valueMode == null) {
            valueMode = reverse ? MultiValueMode.MAX : MultiValueMode.MIN;
        }
        IndexFieldData.XFieldComparatorSource.Nested nested = ScriptSortBuilder.resolveNested(context, this.nestedPath, this.nestedFilter);
        switch (this.type) {
            case STRING: {
                fieldComparatorSource = new BytesRefFieldComparatorSource(null, null, valueMode, nested){
                    LeafSearchScript leafScript;

                    @Override
                    protected SortedBinaryDocValues getValues(LeafReaderContext context) throws IOException {
                        this.leafScript = searchScript.getLeafSearchScript(context);
                        BinaryDocValues values = new BinaryDocValues(){
                            final BytesRefBuilder spare = new BytesRefBuilder();

                            @Override
                            public BytesRef get(int docID) {
                                leafScript.setDocument(docID);
                                this.spare.copyChars(leafScript.run().toString());
                                return this.spare.get();
                            }
                        };
                        return FieldData.singleton(values, null);
                    }

                    @Override
                    protected void setScorer(Scorer scorer) {
                        this.leafScript.setScorer(scorer);
                    }
                };
                break;
            }
            case NUMBER: {
                fieldComparatorSource = new DoubleValuesComparatorSource(null, Double.MAX_VALUE, valueMode, nested){
                    LeafSearchScript leafScript;

                    @Override
                    protected SortedNumericDoubleValues getValues(LeafReaderContext context) throws IOException {
                        this.leafScript = searchScript.getLeafSearchScript(context);
                        NumericDoubleValues values = new NumericDoubleValues(){

                            @Override
                            public double get(int docID) {
                                leafScript.setDocument(docID);
                                return leafScript.runAsDouble();
                            }
                        };
                        return FieldData.singleton(values, null);
                    }

                    @Override
                    protected void setScorer(Scorer scorer) {
                        this.leafScript.setScorer(scorer);
                    }
                };
                break;
            }
            default: {
                throw new QueryShardException(context, "custom script sort type [" + this.type + "] not supported", new Object[0]);
            }
        }
        return new SortFieldAndFormat(new SortField(NAME, fieldComparatorSource, reverse), DocValueFormat.RAW);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ScriptSortBuilder other = (ScriptSortBuilder)object;
        return Objects.equals(this.script, other.script) && Objects.equals(this.type, other.type) && Objects.equals(this.order, other.order) && Objects.equals(this.sortMode, other.sortMode) && Objects.equals(this.nestedFilter, other.nestedFilter) && Objects.equals(this.nestedPath, other.nestedPath);
    }

    public int hashCode() {
        return Objects.hash(this.script, this.type, this.order, this.sortMode, this.nestedFilter, this.nestedPath);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser2, context) -> Script.parse(parser2, context.getDefaultScriptLanguage()), Script.SCRIPT_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> ScriptSortType.fromString(p.text()), TYPE_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareString((b, v) -> {
            ScriptSortBuilder cfr_ignored_0 = (ScriptSortBuilder)b.order(SortOrder.fromString(v));
        }, ORDER_FIELD);
        PARSER.declareString((b, v) -> b.sortMode(SortMode.fromString(v)), SORTMODE_FIELD);
        PARSER.declareString(ScriptSortBuilder::setNestedPath, NESTED_PATH_FIELD);
        PARSER.declareObject(ScriptSortBuilder::setNestedFilter, SortBuilder::parseNestedFilter, NESTED_FILTER_FIELD);
    }

    public static enum ScriptSortType implements Writeable
    {
        STRING,
        NUMBER;


        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal());
        }

        static ScriptSortType readFromStream(StreamInput in) throws IOException {
            int ordinal = in.readVInt();
            if (ordinal < 0 || ordinal >= ScriptSortType.values().length) {
                throw new IOException("Unknown ScriptSortType ordinal [" + ordinal + "]");
            }
            return ScriptSortType.values()[ordinal];
        }

        public static ScriptSortType fromString(String str) {
            Objects.requireNonNull(str, "input string is null");
            switch (str.toLowerCase(Locale.ROOT)) {
                case "string": {
                    return STRING;
                }
                case "number": {
                    return NUMBER;
                }
            }
            throw new IllegalArgumentException("Unknown ScriptSortType [" + str + "]");
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

