/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import org.apache.lucene.index.NumericDocValues;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.SearchContext;

public final class VersionFetchSubPhase
implements FetchSubPhase {
    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (!context.version() || context.storedFieldsContext() != null && !context.storedFieldsContext().fetchFields()) {
            return;
        }
        long version2 = -1L;
        try {
            NumericDocValues versions = hitContext.reader().getNumericDocValues("_version");
            if (versions != null) {
                version2 = versions.get(hitContext.docId());
            }
        }
        catch (IOException e) {
            throw new ElasticsearchException("Could not retrieve version", (Throwable)e, new Object[0]);
        }
        hitContext.hit().version(version2 < 0L ? -1L : version2);
    }
}

