/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.AcknowledgedRestListener;

public class RestIndexPutAliasAction
extends BaseRestHandler {
    public RestIndexPutAliasAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_aliases/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_aliases/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_alias", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_alias", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_aliases/{name}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_aliases/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_aliases", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        String alias = request.param("name");
        Map<String, Object> filter = null;
        String routing = null;
        String indexRouting = null;
        String searchRouting = null;
        if (request.hasContent()) {
            try (XContentParser parser2 = request.contentParser();){
                XContentParser.Token token = parser2.nextToken();
                if (token == null) {
                    throw new IllegalArgumentException("No index alias is specified");
                }
                String currentFieldName = null;
                while ((token = parser2.nextToken()) != null) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser2.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if ("index".equals(currentFieldName)) {
                            indices = Strings.splitStringByCommaToArray(parser2.text());
                            continue;
                        }
                        if ("alias".equals(currentFieldName)) {
                            alias = parser2.text();
                            continue;
                        }
                        if ("routing".equals(currentFieldName)) {
                            routing = parser2.textOrNull();
                            continue;
                        }
                        if ("indexRouting".equals(currentFieldName) || "index-routing".equals(currentFieldName) || "index_routing".equals(currentFieldName)) {
                            indexRouting = parser2.textOrNull();
                            continue;
                        }
                        if (!"searchRouting".equals(currentFieldName) && !"search-routing".equals(currentFieldName) && !"search_routing".equals(currentFieldName)) continue;
                        searchRouting = parser2.textOrNull();
                        continue;
                    }
                    if (token != XContentParser.Token.START_OBJECT || !"filter".equals(currentFieldName)) continue;
                    filter = parser2.mapOrdered();
                }
            }
        }
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        indicesAliasesRequest.timeout(request.paramAsTime("timeout", indicesAliasesRequest.timeout()));
        indicesAliasesRequest.masterNodeTimeout(request.paramAsTime("master_timeout", indicesAliasesRequest.masterNodeTimeout()));
        IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.add().indices(indices).alias(alias);
        if (routing != null) {
            aliasAction.routing(routing);
        }
        if (searchRouting != null) {
            aliasAction.searchRouting(searchRouting);
        }
        if (indexRouting != null) {
            aliasAction.indexRouting(indexRouting);
        }
        if (filter != null) {
            aliasAction.filter(filter);
        }
        indicesAliasesRequest.addAliasAction(aliasAction);
        return channel -> client.admin().indices().aliases(indicesAliasesRequest, new AcknowledgedRestListener<IndicesAliasesResponse>((RestChannel)channel));
    }
}

