/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestFieldCapabilitiesAction
extends BaseRestHandler {
    public RestFieldCapabilitiesAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_field_caps", this);
        controller.registerHandler(RestRequest.Method.POST, "/_field_caps", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_field_caps", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_field_caps", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        FieldCapabilitiesRequest fieldRequest;
        if (request.hasContentOrSourceParam() && request.hasParam("fields")) {
            throw new IllegalArgumentException("can't specify a request body and [fields] request parameter, either specify a request body or the [fields] request parameter");
        }
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        if (request.hasContentOrSourceParam()) {
            try (XContentParser parser2 = request.contentOrSourceParamParser();){
                fieldRequest = FieldCapabilitiesRequest.parseFields(parser2);
            }
        } else {
            fieldRequest = new FieldCapabilitiesRequest();
            fieldRequest.fields(Strings.splitStringByCommaToArray(request.param("fields")));
        }
        fieldRequest.indices(indices);
        fieldRequest.indicesOptions(IndicesOptions.fromRequest(request, fieldRequest.indicesOptions()));
        return channel -> client.fieldCaps(fieldRequest, (ActionListener<FieldCapabilitiesResponse>)new RestBuilderListener<FieldCapabilitiesResponse>(channel){

            @Override
            public RestResponse buildResponse(FieldCapabilitiesResponse response, XContentBuilder builder) throws Exception {
                RestStatus status = RestStatus.OK;
                builder.startObject();
                response.toXContent(builder, request);
                builder.endObject();
                return new BytesRestResponse(status, builder);
            }
        });
    }
}

