/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.PluginInfo;
import org.elasticsearch.plugins.PluginSecurity;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.ProgressInputStream;

class InstallPluginCommand
extends EnvironmentAwareCommand {
    private static final String PROPERTY_STAGING_ID = "es.plugins.staging";
    static final int PLUGIN_EXISTS = 1;
    static final int PLUGIN_MALFORMED = 2;
    static final Set<String> MODULES;
    static final Set<String> OFFICIAL_PLUGINS;
    private final OptionSpec<Void> batchOption;
    private final OptionSpec<String> arguments;
    static final Set<PosixFilePermission> BIN_DIR_PERMS;
    static final Set<PosixFilePermission> BIN_FILES_PERMS;
    static final Set<PosixFilePermission> CONFIG_DIR_PERMS;
    static final Set<PosixFilePermission> CONFIG_FILES_PERMS;
    static final Set<PosixFilePermission> PLUGIN_DIR_PERMS;
    static final Set<PosixFilePermission> PLUGIN_FILES_PERMS;
    private final List<Path> pathsToDeleteOnShutdown = new ArrayList<Path>();

    InstallPluginCommand() {
        super("Install a plugin");
        this.batchOption = this.parser.acceptsAll(Arrays.asList("b", "batch"), "Enable batch mode explicitly, automatic confirmation of security permission");
        this.arguments = this.parser.nonOptions("plugin id");
    }

    @Override
    protected void printAdditionalHelp(Terminal terminal2) {
        terminal2.println("The following official plugins may be installed by name:");
        for (String plugin : OFFICIAL_PLUGINS) {
            terminal2.println("  " + plugin);
        }
        terminal2.println("");
    }

    @Override
    protected void execute(Terminal terminal2, OptionSet options, Environment env) throws Exception {
        String pluginId = this.arguments.value(options);
        boolean isBatch = options.has(this.batchOption) || System.console() == null;
        this.execute(terminal2, pluginId, isBatch, env);
    }

    void execute(Terminal terminal2, String pluginId, boolean isBatch, Environment env) throws Exception {
        if (pluginId == null) {
            throw new UserException(64, "plugin id is required");
        }
        if (!Files.exists(env.pluginsFile(), new LinkOption[0])) {
            terminal2.println("Plugins directory [" + env.pluginsFile() + "] does not exist. Creating...");
            Files.createDirectory(env.pluginsFile(), new FileAttribute[0]);
        }
        Path pluginZip = this.download(terminal2, pluginId, env.tmpFile());
        Path extractedZip = this.unzip(pluginZip, env.pluginsFile());
        this.install(terminal2, isBatch, extractedZip, env);
    }

    private Path download(Terminal terminal2, String pluginId, Path tmpDir) throws Exception {
        if (OFFICIAL_PLUGINS.contains(pluginId)) {
            String version2 = Version.CURRENT.toString();
            String stagingHash = System.getProperty(PROPERTY_STAGING_ID);
            String url = stagingHash != null ? String.format(Locale.ROOT, "https://staging.elastic.co/%3$s-%1$s/downloads/elasticsearch-plugins/%2$s/%2$s-%3$s.zip", stagingHash, pluginId, version2) : String.format(Locale.ROOT, "https://artifacts.elastic.co/downloads/elasticsearch-plugins/%1$s/%1$s-%2$s.zip", pluginId, version2);
            terminal2.println("-> Downloading " + pluginId + " from elastic");
            return this.downloadZipAndChecksum(terminal2, url, tmpDir);
        }
        String[] coordinates = pluginId.split(":");
        if (coordinates.length == 3 && !pluginId.contains("/")) {
            String mavenUrl = String.format(Locale.ROOT, "https://repo1.maven.org/maven2/%1$s/%2$s/%3$s/%2$s-%3$s.zip", coordinates[0].replace(".", "/"), coordinates[1], coordinates[2]);
            terminal2.println("-> Downloading " + pluginId + " from maven central");
            return this.downloadZipAndChecksum(terminal2, mavenUrl, tmpDir);
        }
        if (!pluginId.contains(":/")) {
            List<String> plugins = this.checkMisspelledPlugin(pluginId);
            String msg = "Unknown plugin " + pluginId;
            if (!plugins.isEmpty()) {
                msg = msg + ", did you mean " + (plugins.size() == 1 ? "[" + plugins.get(0) + "]" : "any of " + plugins.toString()) + "?";
            }
            throw new UserException(64, msg);
        }
        terminal2.println("-> Downloading " + URLDecoder.decode(pluginId, "UTF-8"));
        return this.downloadZip(terminal2, pluginId, tmpDir);
    }

    private List<String> checkMisspelledPlugin(String pluginId) {
        LevensteinDistance ld = new LevensteinDistance();
        ArrayList<Tuple<Float, String>> scoredKeys = new ArrayList<Tuple<Float, String>>();
        for (String officialPlugin : OFFICIAL_PLUGINS) {
            float distance = ld.getDistance(pluginId, officialPlugin);
            if (!(distance > 0.7f)) continue;
            scoredKeys.add(new Tuple<Float, String>(Float.valueOf(distance), officialPlugin));
        }
        CollectionUtil.timSort(scoredKeys, (a, b) -> ((Float)b.v1()).compareTo((Float)a.v1()));
        return scoredKeys.stream().map(a -> (String)a.v2()).collect(Collectors.toList());
    }

    private Path downloadZip(Terminal terminal2, String urlString, Path tmpDir) throws IOException {
        terminal2.println(Terminal.Verbosity.VERBOSE, "Retrieving zip from " + urlString);
        URL url = new URL(urlString);
        Path zip = Files.createTempFile(tmpDir, null, ".zip", new FileAttribute[0]);
        URLConnection urlConnection = url.openConnection();
        urlConnection.addRequestProperty("User-Agent", "elasticsearch-plugin-installer");
        int contentLength = urlConnection.getContentLength();
        try (TerminalProgressInputStream in = new TerminalProgressInputStream(urlConnection.getInputStream(), contentLength, terminal2);){
            Files.copy(in, zip, StandardCopyOption.REPLACE_EXISTING);
        }
        return zip;
    }

    private Path downloadZipAndChecksum(Terminal terminal2, String urlString, Path tmpDir) throws Exception {
        String expectedChecksum;
        Path zip = this.downloadZip(terminal2, urlString, tmpDir);
        this.pathsToDeleteOnShutdown.add(zip);
        URL checksumUrl = new URL(urlString + ".sha1");
        try (InputStream in = checksumUrl.openStream();){
            BufferedReader checksumReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            expectedChecksum = checksumReader.readLine();
            if (checksumReader.readLine() != null) {
                throw new UserException(74, "Invalid checksum file at " + checksumUrl);
            }
        }
        byte[] zipbytes = Files.readAllBytes(zip);
        String gotChecksum = MessageDigests.toHexString(MessageDigests.sha1().digest(zipbytes));
        if (!expectedChecksum.equals(gotChecksum)) {
            throw new UserException(74, "SHA1 mismatch, expected " + expectedChecksum + " but got " + gotChecksum);
        }
        return zip;
    }

    private Path unzip(Path zip, Path pluginsDir) throws IOException, UserException {
        Path target = this.stagingDirectory(pluginsDir);
        this.pathsToDeleteOnShutdown.add(target);
        boolean hasEsDir = false;
        try (ZipInputStream zipInput = new ZipInputStream(Files.newInputStream(zip, new OpenOption[0]));){
            ZipEntry entry;
            byte[] buffer = new byte[8192];
            while ((entry = zipInput.getNextEntry()) != null) {
                if (!entry.getName().startsWith("elasticsearch/")) continue;
                hasEsDir = true;
                Path targetFile = target.resolve(entry.getName().substring("elasticsearch/".length()));
                if (!targetFile.normalize().startsWith(target)) {
                    throw new UserException(2, "Zip contains entry name '" + entry.getName() + "' resolving outside of plugin directory");
                }
                if (!Files.isSymbolicLink(targetFile.getParent())) {
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                }
                if (!entry.isDirectory()) {
                    try (OutputStream out = Files.newOutputStream(targetFile, new OpenOption[0]);){
                        int len;
                        while ((len = zipInput.read(buffer)) >= 0) {
                            out.write(buffer, 0, len);
                        }
                    }
                }
                zipInput.closeEntry();
            }
        }
        Files.delete(zip);
        if (!hasEsDir) {
            IOUtils.rm(target);
            throw new UserException(2, "`elasticsearch` directory is missing in the plugin zip");
        }
        return target;
    }

    private Path stagingDirectory(Path pluginsDir) throws IOException {
        try {
            return Files.createTempDirectory(pluginsDir, ".installing-", PosixFilePermissions.asFileAttribute(PLUGIN_DIR_PERMS));
        }
        catch (IllegalArgumentException e) {
            StackTraceElement[] elements = e.getStackTrace();
            if (elements.length >= 1 && elements[0].getClassName().equals("com.google.common.jimfs.AttributeService") && elements[0].getMethodName().equals("setAttributeInternal")) {
                return this.stagingDirectoryWithoutPosixPermissions(pluginsDir);
            }
            throw e;
        }
        catch (UnsupportedOperationException e) {
            return this.stagingDirectoryWithoutPosixPermissions(pluginsDir);
        }
    }

    private Path stagingDirectoryWithoutPosixPermissions(Path pluginsDir) throws IOException {
        return Files.createTempDirectory(pluginsDir, ".installing-", new FileAttribute[0]);
    }

    private PluginInfo verify(Terminal terminal2, Path pluginRoot, boolean isBatch, Environment env) throws Exception {
        PluginInfo info = PluginInfo.readFromProperties(pluginRoot);
        Path destination = env.pluginsFile().resolve(info.getName());
        if (Files.exists(destination, new LinkOption[0])) {
            String message = String.format(Locale.ROOT, "plugin directory [%s] already exists; if you need to update the plugin, uninstall it first using command 'remove %s'", destination.toAbsolutePath(), info.getName());
            throw new UserException(1, message);
        }
        terminal2.println(Terminal.Verbosity.VERBOSE, info.toString());
        if (MODULES.contains(info.getName())) {
            throw new UserException(64, "plugin '" + info.getName() + "' cannot be installed like this, it is a system module");
        }
        this.jarHellCheck(pluginRoot, env.pluginsFile());
        Path policy = pluginRoot.resolve("plugin-security.policy");
        if (Files.exists(policy, new LinkOption[0])) {
            PluginSecurity.readPolicy(info, policy, terminal2, env::tmpFile, isBatch);
        }
        return info;
    }

    void jarHellCheck(Path candidate, Path pluginsDir) throws Exception {
        Path[] pluginJars;
        HashSet<URL> jars = new HashSet<URL>(JarHell.parseClassPath());
        PluginsService.getPluginBundles(pluginsDir);
        for (Path jar : pluginJars = FileSystemUtils.files(candidate, "*.jar")) {
            if (jars.add(jar.toUri().toURL())) continue;
            throw new IllegalStateException("jar hell! duplicate plugin jar: " + jar);
        }
        JarHell.checkJarHell(jars);
    }

    private void install(Terminal terminal2, boolean isBatch, Path tmpRoot, Environment env) throws Exception {
        ArrayList<Path> deleteOnFailure = new ArrayList<Path>();
        deleteOnFailure.add(tmpRoot);
        try {
            Path tmpConfigDir;
            PluginInfo info = this.verify(terminal2, tmpRoot, isBatch, env);
            Path destination = env.pluginsFile().resolve(info.getName());
            Path tmpBinDir = tmpRoot.resolve("bin");
            if (Files.exists(tmpBinDir, new LinkOption[0])) {
                Path destBinDir = env.binFile().resolve(info.getName());
                deleteOnFailure.add(destBinDir);
                this.installBin(info, tmpBinDir, destBinDir);
            }
            if (Files.exists(tmpConfigDir = tmpRoot.resolve("config"), new LinkOption[0])) {
                this.installConfig(info, tmpConfigDir, env.configFile().resolve(info.getName()));
            }
            Files.move(tmpRoot, destination, StandardCopyOption.ATOMIC_MOVE);
            Files.walkFileTree(destination, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path pluginFile, BasicFileAttributes attrs) throws IOException {
                    if (Files.isDirectory(pluginFile, new LinkOption[0])) {
                        InstallPluginCommand.setFileAttributes(pluginFile, PLUGIN_DIR_PERMS);
                    } else {
                        Path parentDir = pluginFile.getParent().getFileName();
                        if ("bin".equals(parentDir.toString())) {
                            InstallPluginCommand.setFileAttributes(pluginFile, BIN_FILES_PERMS);
                        } else {
                            InstallPluginCommand.setFileAttributes(pluginFile, PLUGIN_FILES_PERMS);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            terminal2.println("-> Installed " + info.getName());
        }
        catch (Exception installProblem) {
            try {
                IOUtils.rm(deleteOnFailure.toArray(new Path[0]));
            }
            catch (IOException exceptionWhileRemovingFiles) {
                installProblem.addSuppressed(exceptionWhileRemovingFiles);
            }
            throw installProblem;
        }
    }

    private void installBin(PluginInfo info, Path tmpBinDir, Path destBinDir) throws Exception {
        if (!Files.isDirectory(tmpBinDir, new LinkOption[0])) {
            throw new UserException(2, "bin in plugin " + info.getName() + " is not a directory");
        }
        Files.createDirectory(destBinDir, new FileAttribute[0]);
        InstallPluginCommand.setFileAttributes(destBinDir, BIN_DIR_PERMS);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tmpBinDir);){
            for (Path srcFile : stream) {
                if (Files.isDirectory(srcFile, new LinkOption[0])) {
                    throw new UserException(2, "Directories not allowed in bin dir for plugin " + info.getName() + ", found " + srcFile.getFileName());
                }
                Path destFile = destBinDir.resolve(tmpBinDir.relativize(srcFile));
                Files.copy(srcFile, destFile, new CopyOption[0]);
                InstallPluginCommand.setFileAttributes(destFile, BIN_FILES_PERMS);
            }
        }
        IOUtils.rm(tmpBinDir);
    }

    private void installConfig(PluginInfo info, Path tmpConfigDir, Path destConfigDir) throws Exception {
        PosixFileAttributes destConfigDirAttributes;
        if (!Files.isDirectory(tmpConfigDir, new LinkOption[0])) {
            throw new UserException(2, "config in plugin " + info.getName() + " is not a directory");
        }
        Files.createDirectories(destConfigDir, new FileAttribute[0]);
        InstallPluginCommand.setFileAttributes(destConfigDir, CONFIG_DIR_PERMS);
        PosixFileAttributeView destConfigDirAttributesView = Files.getFileAttributeView(destConfigDir.getParent(), PosixFileAttributeView.class, new LinkOption[0]);
        PosixFileAttributes posixFileAttributes = destConfigDirAttributes = destConfigDirAttributesView != null ? destConfigDirAttributesView.readAttributes() : null;
        if (destConfigDirAttributes != null) {
            InstallPluginCommand.setOwnerGroup(destConfigDir, destConfigDirAttributes);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tmpConfigDir);){
            for (Path srcFile : stream) {
                if (Files.isDirectory(srcFile, new LinkOption[0])) {
                    throw new UserException(2, "Directories not allowed in config dir for plugin " + info.getName());
                }
                Path destFile = destConfigDir.resolve(tmpConfigDir.relativize(srcFile));
                if (Files.exists(destFile, new LinkOption[0])) continue;
                Files.copy(srcFile, destFile, new CopyOption[0]);
                InstallPluginCommand.setFileAttributes(destFile, CONFIG_FILES_PERMS);
                if (destConfigDirAttributes == null) continue;
                InstallPluginCommand.setOwnerGroup(destFile, destConfigDirAttributes);
            }
        }
        IOUtils.rm(tmpConfigDir);
    }

    private static void setOwnerGroup(Path path, PosixFileAttributes attributes) throws IOException {
        Objects.requireNonNull(attributes);
        PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        assert (fileAttributeView != null);
        fileAttributeView.setOwner(attributes.owner());
        fileAttributeView.setGroup(attributes.group());
    }

    private static void setFileAttributes(Path path, Set<PosixFilePermission> permissions) throws IOException {
        PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (fileAttributeView != null) {
            Files.setPosixFilePermissions(path, permissions);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.rm(this.pathsToDeleteOnShutdown.toArray(new Path[this.pathsToDeleteOnShutdown.size()]));
    }

    static {
        String line;
        Throwable throwable;
        BufferedReader reader2;
        Throwable throwable2;
        InputStream stream;
        try {
            stream = InstallPluginCommand.class.getResourceAsStream("/modules.txt");
            throwable2 = null;
            try {
                reader2 = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                throwable = null;
                try {
                    HashSet<String> modules = new HashSet<String>();
                    line = reader2.readLine();
                    while (line != null) {
                        modules.add(line.trim());
                        line = reader2.readLine();
                    }
                    MODULES = Collections.unmodifiableSet(modules);
                }
                catch (Throwable modules) {
                    throwable = modules;
                    throw modules;
                }
                finally {
                    if (reader2 != null) {
                        if (throwable != null) {
                            try {
                                reader2.close();
                            }
                            catch (Throwable modules) {
                                throwable.addSuppressed(modules);
                            }
                        } else {
                            reader2.close();
                        }
                    }
                }
            }
            catch (Throwable reader2) {
                throwable2 = reader2;
                throw reader2;
            }
            finally {
                if (stream != null) {
                    if (throwable2 != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable reader2) {
                            throwable2.addSuppressed(reader2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            stream = InstallPluginCommand.class.getResourceAsStream("/plugins.txt");
            throwable2 = null;
            try {
                reader2 = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                throwable = null;
                try {
                    TreeSet<String> plugins = new TreeSet<String>();
                    line = reader2.readLine();
                    while (line != null) {
                        plugins.add(line.trim());
                        line = reader2.readLine();
                    }
                    plugins.add("x-pack");
                    OFFICIAL_PLUGINS = Collections.unmodifiableSet(plugins);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (reader2 != null) {
                        if (throwable != null) {
                            try {
                                reader2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            reader2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                if (stream != null) {
                    if (throwable2 != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        BIN_DIR_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxr-xr-x"));
        BIN_FILES_PERMS = BIN_DIR_PERMS;
        CONFIG_DIR_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxr-x---"));
        CONFIG_FILES_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rw-rw----"));
        PLUGIN_DIR_PERMS = BIN_DIR_PERMS;
        PLUGIN_FILES_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rw-r--r--"));
    }

    private class TerminalProgressInputStream
    extends ProgressInputStream {
        private final Terminal terminal;
        private int width;
        private final boolean enabled;

        TerminalProgressInputStream(InputStream is, int expectedTotalSize, Terminal terminal2) {
            super(is, expectedTotalSize);
            this.width = 50;
            this.terminal = terminal2;
            this.enabled = expectedTotalSize > 0;
        }

        @Override
        public void onProgress(int percent) {
            if (this.enabled) {
                int currentPosition = percent * this.width / 100;
                StringBuilder sb = new StringBuilder("\r[");
                sb.append(String.join((CharSequence)"=", Collections.nCopies(currentPosition, "")));
                if (currentPosition > 0 && percent < 100) {
                    sb.append(">");
                }
                sb.append(String.join((CharSequence)" ", Collections.nCopies(this.width - currentPosition, "")));
                sb.append("] %s\u00a0\u00a0 ");
                if (percent == 100) {
                    sb.append("\n");
                }
                this.terminal.print(Terminal.Verbosity.NORMAL, String.format(Locale.ROOT, sb.toString(), percent + "%"));
            }
        }
    }
}

