/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.io.Reader;
import java.util.Locale;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.elasticsearch.Version;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public enum PreBuiltCharFilters {
    HTML_STRIP(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public Reader create(Reader tokenStream, Version version2) {
            return new HTMLStripCharFilter(tokenStream);
        }
    };

    protected final PreBuiltCacheFactory.PreBuiltCache<CharFilterFactory> cache;

    public abstract Reader create(Reader var1, Version var2);

    private PreBuiltCharFilters(PreBuiltCacheFactory.CachingStrategy cachingStrategy) {
        this.cache = PreBuiltCacheFactory.getCache(cachingStrategy);
    }

    public synchronized CharFilterFactory getCharFilterFactory(final Version version2) {
        CharFilterFactory charFilterFactory = this.cache.get(version2);
        if (charFilterFactory == null) {
            final String finalName = this.name();
            charFilterFactory = new CharFilterFactory(){

                @Override
                public String name() {
                    return finalName.toLowerCase(Locale.ROOT);
                }

                @Override
                public Reader create(Reader tokenStream) {
                    return PreBuiltCharFilters.valueOf(finalName).create(tokenStream, version2);
                }
            };
            this.cache.put(version2, charFilterFactory);
        }
        return charFilterFactory;
    }

    public static PreBuiltCharFilters getOrDefault(String name, PreBuiltCharFilters defaultCharFilter) {
        try {
            return PreBuiltCharFilters.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return defaultCharFilter;
        }
    }
}

