/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TwoPhaseCommit;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasablePagedBytesReference;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShardComponent;
import org.elasticsearch.index.translog.BaseTranslogReader;
import org.elasticsearch.index.translog.BufferedChecksumStreamInput;
import org.elasticsearch.index.translog.BufferedChecksumStreamOutput;
import org.elasticsearch.index.translog.ChannelFactory;
import org.elasticsearch.index.translog.Checkpoint;
import org.elasticsearch.index.translog.MultiSnapshot;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogCorruptedException;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TranslogReader;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.index.translog.TranslogWriter;
import org.elasticsearch.index.translog.TruncatedTranslogException;

public class Translog
extends AbstractIndexShardComponent
implements IndexShardComponent,
Closeable,
TwoPhaseCommit {
    public static final String TRANSLOG_GENERATION_KEY = "translog_generation";
    public static final String TRANSLOG_UUID_KEY = "translog_uuid";
    public static final String TRANSLOG_FILE_PREFIX = "translog-";
    public static final String TRANSLOG_FILE_SUFFIX = ".tlog";
    public static final String CHECKPOINT_SUFFIX = ".ckp";
    public static final String CHECKPOINT_FILE_NAME = "translog.ckp";
    static final Pattern PARSE_STRICT_ID_PATTERN = Pattern.compile("^translog-(\\d+)(\\.tlog)$");
    private final List<TranslogReader> readers;
    private final Set<View> outstandingViews;
    private BigArrays bigArrays;
    protected final ReleasableLock readLock;
    protected final ReleasableLock writeLock;
    private final Path location;
    private TranslogWriter current;
    private static final long NOT_SET_GENERATION = -1L;
    private volatile long currentCommittingGeneration;
    private volatile long lastCommittedTranslogFileGeneration;
    private final AtomicBoolean closed;
    private final TranslogConfig config;
    private final String translogUUID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Translog(TranslogConfig config, TranslogGeneration translogGeneration) throws IOException {
        block10: {
            super(config.getShardId(), config.getIndexSettings());
            this.readers = new ArrayList<TranslogReader>();
            this.outstandingViews = ConcurrentCollections.newConcurrentSet();
            this.currentCommittingGeneration = -1L;
            this.lastCommittedTranslogFileGeneration = -1L;
            this.closed = new AtomicBoolean();
            this.config = config;
            this.translogUUID = translogGeneration == null || translogGeneration.translogUUID == null ? UUIDs.randomBase64UUID() : translogGeneration.translogUUID;
            this.bigArrays = config.getBigArrays();
            ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
            this.readLock = new ReleasableLock(rwl.readLock());
            this.writeLock = new ReleasableLock(rwl.writeLock());
            this.location = config.getTranslogPath();
            Files.createDirectories(this.location, new FileAttribute[0]);
            try {
                if (translogGeneration != null) {
                    Checkpoint checkpoint = this.readCheckpoint();
                    Path nextTranslogFile = this.location.resolve(Translog.getFilename(checkpoint.generation + 1L));
                    Path currentCheckpointFile = this.location.resolve(Translog.getCommitCheckpointFileName(checkpoint.generation));
                    assert (!Files.exists(nextTranslogFile, new LinkOption[0]) || Files.size(nextTranslogFile) <= (long)TranslogWriter.getHeaderLength(this.translogUUID)) : "unexpected translog file: [" + nextTranslogFile + "]";
                    if (Files.exists(currentCheckpointFile, new LinkOption[0]) && Files.deleteIfExists(nextTranslogFile)) {
                        this.logger.warn("deleted previously created, but not yet committed, next generation [{}]. This can happen due to a tragic exception when creating a new generation", (Object)nextTranslogFile.getFileName());
                    }
                    this.readers.addAll(this.recoverFromFiles(translogGeneration, checkpoint));
                    if (this.readers.isEmpty()) {
                        throw new IllegalStateException("at least one reader must be recovered");
                    }
                    boolean success = false;
                    try {
                        this.current = this.createWriter(checkpoint.generation + 1L);
                        this.lastCommittedTranslogFileGeneration = translogGeneration.translogFileGeneration;
                        success = true;
                        break block10;
                    }
                    finally {
                        if (!success) {
                            IOUtils.closeWhileHandlingException(this.readers);
                        }
                    }
                }
                IOUtils.rm(this.location);
                this.logger.debug("wipe translog location - creating new translog");
                Files.createDirectories(this.location, new FileAttribute[0]);
                long generation = 1L;
                Checkpoint checkpoint = new Checkpoint(0L, 0, 1L);
                Path checkpointFile = this.location.resolve(CHECKPOINT_FILE_NAME);
                Checkpoint.write(this.getChannelFactory(), checkpointFile, checkpoint, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
                IOUtils.fsync(checkpointFile, false);
                this.current = this.createWriter(1L);
                this.lastCommittedTranslogFileGeneration = -1L;
            }
            catch (Exception e) {
                IOUtils.closeWhileHandlingException(this.current);
                IOUtils.closeWhileHandlingException(this.readers);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<TranslogReader> recoverFromFiles(TranslogGeneration translogGeneration, Checkpoint checkpoint) throws IOException {
        boolean success = false;
        ArrayList<TranslogReader> foundTranslogs = new ArrayList<TranslogReader>();
        Path tempFile = Files.createTempFile(this.location, TRANSLOG_FILE_PREFIX, TRANSLOG_FILE_SUFFIX, new FileAttribute[0]);
        boolean tempFileRenamed = false;
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.logger.debug("open uncommitted translog checkpoint {}", (Object)checkpoint);
            String checkpointTranslogFile = Translog.getFilename(checkpoint.generation);
            for (long i = translogGeneration.translogFileGeneration; i < checkpoint.generation; ++i) {
                Path committedTranslogFile = this.location.resolve(Translog.getFilename(i));
                if (!Files.exists(committedTranslogFile, new LinkOption[0])) {
                    throw new IllegalStateException("translog file doesn't exist with generation: " + i + " lastCommitted: " + this.lastCommittedTranslogFileGeneration + " checkpoint: " + checkpoint.generation + " - translog ids must be consecutive");
                }
                TranslogReader reader = this.openReader(committedTranslogFile, Checkpoint.read(this.location.resolve(Translog.getCommitCheckpointFileName(i))));
                foundTranslogs.add(reader);
                this.logger.debug("recovered local translog from checkpoint {}", (Object)checkpoint);
            }
            foundTranslogs.add(this.openReader(this.location.resolve(checkpointTranslogFile), checkpoint));
            Path commitCheckpoint = this.location.resolve(Translog.getCommitCheckpointFileName(checkpoint.generation));
            if (Files.exists(commitCheckpoint, new LinkOption[0])) {
                Checkpoint checkpointFromDisk = Checkpoint.read(commitCheckpoint);
                if (!checkpoint.equals(checkpointFromDisk)) {
                    throw new IllegalStateException("Checkpoint file " + commitCheckpoint.getFileName() + " already exists but has corrupted content expected: " + checkpoint + " but got: " + checkpointFromDisk);
                }
            } else {
                Files.copy(this.location.resolve(CHECKPOINT_FILE_NAME), tempFile, StandardCopyOption.REPLACE_EXISTING);
                IOUtils.fsync(tempFile, false);
                Files.move(tempFile, commitCheckpoint, StandardCopyOption.ATOMIC_MOVE);
                tempFileRenamed = true;
                IOUtils.fsync(commitCheckpoint.getParent(), true);
            }
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException(foundTranslogs);
            }
            if (!tempFileRenamed) {
                try {
                    Files.delete(tempFile);
                }
                catch (IOException ex) {
                    this.logger.warn(() -> new ParameterizedMessage("failed to delete temp file {}", (Object)tempFile), (Throwable)ex);
                }
            }
        }
        return foundTranslogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TranslogReader openReader(Path path, Checkpoint checkpoint) throws IOException {
        TranslogReader translogReader;
        FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
        try {
            assert (Translog.parseIdFromFileName(path) == checkpoint.generation) : "expected generation: " + Translog.parseIdFromFileName(path) + " but got: " + checkpoint.generation;
            TranslogReader reader = TranslogReader.open(channel, path, checkpoint, this.translogUUID);
            channel = null;
            translogReader = reader;
        }
        catch (Throwable throwable) {
            IOUtils.close(channel);
            throw throwable;
        }
        IOUtils.close(channel);
        return translogReader;
    }

    public static long parseIdFromFileName(Path translogFile) {
        String fileName = translogFile.getFileName().toString();
        Matcher matcher = PARSE_STRICT_ID_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            try {
                return Long.parseLong(matcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("number formatting issue in a file that passed PARSE_STRICT_ID_PATTERN: " + fileName + "]", e);
            }
        }
        throw new IllegalArgumentException("can't parse id from file: " + fileName);
    }

    public boolean isOpen() {
        return !this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try (ReleasableLock lock = this.writeLock.acquire();){
                try {
                    this.current.sync();
                }
                finally {
                    this.closeFilesIfNoPendingViews();
                }
            }
            finally {
                this.logger.debug("translog closed");
            }
        }
    }

    public Path location() {
        return this.location;
    }

    public long currentFileGeneration() {
        try (ReleasableLock lock = this.readLock.acquire();){
            long l = this.current.getGeneration();
            return l;
        }
    }

    public int totalOperations() {
        return this.totalOperations(this.lastCommittedTranslogFileGeneration);
    }

    public long sizeInBytes() {
        return this.sizeInBytes(this.lastCommittedTranslogFileGeneration);
    }

    private int totalOperations(long minGeneration) {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            int n = Stream.concat(this.readers.stream(), Stream.of(this.current)).filter(r -> r.getGeneration() >= minGeneration).mapToInt(BaseTranslogReader::totalOperations).sum();
            return n;
        }
    }

    private long sizeInBytes(long minGeneration) {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            long l = Stream.concat(this.readers.stream(), Stream.of(this.current)).filter(r -> r.getGeneration() >= minGeneration).mapToLong(BaseTranslogReader::sizeInBytes).sum();
            return l;
        }
    }

    TranslogWriter createWriter(long fileGeneration) throws IOException {
        TranslogWriter newFile;
        try {
            newFile = TranslogWriter.create(this.shardId, this.translogUUID, fileGeneration, this.location.resolve(Translog.getFilename(fileGeneration)), this.getChannelFactory(), this.config.getBufferSize());
        }
        catch (IOException e) {
            throw new TranslogException(this.shardId, "failed to create new translog file", e);
        }
        return newFile;
    }

    /*
     * Exception decompiling
     */
    public Location add(Operation operation) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Location getLastWriteLocation() {
        try (ReleasableLock lock = this.readLock.acquire();){
            Location location = new Location(this.current.generation, this.current.sizeInBytes() - 1L, Integer.MAX_VALUE);
            return location;
        }
    }

    public Snapshot newSnapshot() {
        return this.createSnapshot(Long.MIN_VALUE);
    }

    private Snapshot createSnapshot(long minGeneration) {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            Snapshot[] snapshots = (Snapshot[])Stream.concat(this.readers.stream(), Stream.of(this.current)).filter(reader -> reader.getGeneration() >= minGeneration).map(BaseTranslogReader::newSnapshot).toArray(Snapshot[]::new);
            MultiSnapshot multiSnapshot = new MultiSnapshot(snapshots);
            return multiSnapshot;
        }
    }

    public View newView() {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            View view = new View(this.lastCommittedTranslogFileGeneration);
            this.outstandingViews.add(view);
            View view2 = view;
            return view2;
        }
    }

    public void sync() throws IOException {
        try (ReleasableLock lock = this.readLock.acquire();){
            if (!this.closed.get()) {
                this.current.sync();
            }
        }
        catch (Exception ex) {
            try {
                this.closeOnTragicEvent(ex);
            }
            catch (Exception inner) {
                ex.addSuppressed(inner);
            }
            throw ex;
        }
    }

    public boolean syncNeeded() {
        try (ReleasableLock lock = this.readLock.acquire();){
            boolean bl = this.current.syncNeeded();
            return bl;
        }
    }

    public static String getFilename(long generation) {
        return TRANSLOG_FILE_PREFIX + generation + TRANSLOG_FILE_SUFFIX;
    }

    static String getCommitCheckpointFileName(long generation) {
        return TRANSLOG_FILE_PREFIX + generation + CHECKPOINT_SUFFIX;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean ensureSynced(Location location) throws IOException {
        try (ReleasableLock lock = this.readLock.acquire();){
            if (location.generation != this.current.getGeneration()) return false;
            this.ensureOpen();
            boolean bl = this.current.syncUpTo(location.translogLocation + (long)location.size);
            return bl;
        }
        catch (Exception ex) {
            try {
                this.closeOnTragicEvent(ex);
                throw ex;
            }
            catch (Exception inner) {
                ex.addSuppressed(inner);
            }
            throw ex;
        }
    }

    public boolean ensureSynced(Stream<Location> locations) throws IOException {
        Optional<Location> max = locations.max(Location::compareTo);
        if (max.isPresent()) {
            return this.ensureSynced(max.get());
        }
        return false;
    }

    private void closeOnTragicEvent(Exception ex) {
        if (this.current.getTragicException() != null) {
            try {
                this.close();
            }
            catch (AlreadyClosedException alreadyClosedException) {
            }
            catch (Exception inner) {
                assert (ex != inner.getCause());
                ex.addSuppressed(inner);
            }
        }
    }

    public TranslogStats stats() {
        try (ReleasableLock lock = this.readLock.acquire();){
            TranslogStats translogStats = new TranslogStats(this.totalOperations(), this.sizeInBytes());
            return translogStats;
        }
    }

    public TranslogConfig getConfig() {
        return this.config;
    }

    private static void verifyChecksum(BufferedChecksumStreamInput in) throws IOException {
        long expectedChecksum = in.getChecksum();
        long readChecksum = (long)in.readInt() & 0xFFFFFFFFL;
        if (readChecksum != expectedChecksum) {
            throw new TranslogCorruptedException("translog stream is corrupted, expected: 0x" + Long.toHexString(expectedChecksum) + ", got: 0x" + Long.toHexString(readChecksum));
        }
    }

    public static List<Operation> readOperations(StreamInput input) throws IOException {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        int numOps = input.readInt();
        BufferedChecksumStreamInput checksumStreamInput = new BufferedChecksumStreamInput(input);
        for (int i = 0; i < numOps; ++i) {
            operations.add(Translog.readOperation(checksumStreamInput));
        }
        return operations;
    }

    static Operation readOperation(BufferedChecksumStreamInput in) throws IOException {
        Operation operation;
        try {
            int opSize = in.readInt();
            if (opSize < 4) {
                throw new TranslogCorruptedException("operation size must be at least 4 but was: " + opSize);
            }
            in.resetDigest();
            if (in.markSupported()) {
                in.mark(opSize);
                in.skip(opSize - 4);
                Translog.verifyChecksum(in);
                in.reset();
            }
            operation = Operation.readType(in);
            Translog.verifyChecksum(in);
        }
        catch (TranslogCorruptedException e) {
            throw e;
        }
        catch (EOFException e) {
            throw new TruncatedTranslogException("reached premature end of file, translog is truncated", e);
        }
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOperations(StreamOutput outStream, List<Operation> toWrite) throws IOException {
        ReleasableBytesStreamOutput out = new ReleasableBytesStreamOutput(BigArrays.NON_RECYCLING_INSTANCE);
        try {
            outStream.writeInt(toWrite.size());
            BufferedChecksumStreamOutput checksumStreamOutput = new BufferedChecksumStreamOutput(out);
            for (Operation op : toWrite) {
                out.reset();
                long start = out.position();
                out.skip(4);
                Translog.writeOperationNoSize(checksumStreamOutput, op);
                long end = out.position();
                int operationSize = (int)(out.position() - 4L - start);
                out.seek(start);
                out.writeInt(operationSize);
                out.seek(end);
                ReleasablePagedBytesReference bytes = out.bytes();
                bytes.writeTo(outStream);
            }
        }
        catch (Throwable throwable) {
            Releasables.close(out.bytes());
            throw throwable;
        }
        Releasables.close(out.bytes());
    }

    public static void writeOperationNoSize(BufferedChecksumStreamOutput out, Operation op) throws IOException {
        out.resetDigest();
        Operation.writeType(op, out);
        long checksum = out.getChecksum();
        out.writeInt((int)checksum);
    }

    @Override
    public long prepareCommit() throws IOException {
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            if (this.currentCommittingGeneration != -1L) {
                throw new IllegalStateException("already committing a translog with generation: " + this.currentCommittingGeneration);
            }
            this.currentCommittingGeneration = this.current.getGeneration();
            TranslogReader currentCommittingTranslog = this.current.closeIntoReader();
            this.readers.add(currentCommittingTranslog);
            Path checkpoint = this.location.resolve(CHECKPOINT_FILE_NAME);
            assert (Checkpoint.read((Path)checkpoint).generation == currentCommittingTranslog.getGeneration());
            Path commitCheckpoint = this.location.resolve(Translog.getCommitCheckpointFileName(currentCommittingTranslog.getGeneration()));
            Files.copy(checkpoint, commitCheckpoint, new CopyOption[0]);
            IOUtils.fsync(commitCheckpoint, false);
            IOUtils.fsync(commitCheckpoint.getParent(), true);
            this.current = this.createWriter(this.current.getGeneration() + 1L);
            this.logger.trace("current translog set to [{}]", (Object)this.current.getGeneration());
        }
        catch (Exception e) {
            IOUtils.closeWhileHandlingException(this);
            throw e;
        }
        return 0L;
    }

    @Override
    public long commit() throws IOException {
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            if (this.currentCommittingGeneration == -1L) {
                this.prepareCommit();
            }
            assert (this.currentCommittingGeneration != -1L);
            assert (this.readers.stream().filter(r -> r.getGeneration() == this.currentCommittingGeneration).findFirst().isPresent()) : "reader list doesn't contain committing generation [" + this.currentCommittingGeneration + "]";
            this.lastCommittedTranslogFileGeneration = this.current.getGeneration();
            this.currentCommittingGeneration = -1L;
            this.trimUnreferencedReaders();
        }
        return 0L;
    }

    void trimUnreferencedReaders() {
        try (ReleasableLock ignored = this.writeLock.acquire();){
            if (this.closed.get()) {
                return;
            }
            long minReferencedGen = this.outstandingViews.stream().mapToLong(View::minTranslogGeneration).min().orElse(Long.MAX_VALUE);
            long finalMinReferencedGen = minReferencedGen = Math.min(this.lastCommittedTranslogFileGeneration, minReferencedGen);
            List unreferenced = this.readers.stream().filter(r -> r.getGeneration() < finalMinReferencedGen).collect(Collectors.toList());
            for (TranslogReader unreferencedReader : unreferenced) {
                Path translogPath = unreferencedReader.path();
                this.logger.trace("delete translog file - not referenced and not current anymore {}", (Object)translogPath);
                IOUtils.closeWhileHandlingException(unreferencedReader);
                IOUtils.deleteFilesIgnoringExceptions(translogPath, translogPath.resolveSibling(Translog.getCommitCheckpointFileName(unreferencedReader.getGeneration())));
            }
            this.readers.removeAll(unreferenced);
        }
    }

    void closeFilesIfNoPendingViews() throws IOException {
        try (ReleasableLock ignored = this.writeLock.acquire();){
            if (this.closed.get() && this.outstandingViews.isEmpty()) {
                this.logger.trace("closing files. translog is closed and there are no pending views");
                ArrayList<TranslogReader> toClose = new ArrayList<TranslogReader>(this.readers);
                toClose.add((TranslogReader)((Object)this.current));
                IOUtils.close(toClose);
            }
        }
    }

    @Override
    public void rollback() throws IOException {
        this.ensureOpen();
        this.close();
    }

    public TranslogGeneration getGeneration() {
        try (ReleasableLock lock = this.writeLock.acquire();){
            TranslogGeneration translogGeneration = new TranslogGeneration(this.translogUUID, this.currentFileGeneration());
            return translogGeneration;
        }
    }

    public boolean isCurrent(TranslogGeneration generation) {
        try (ReleasableLock lock = this.writeLock.acquire();){
            if (generation != null) {
                if (!generation.translogUUID.equals(this.translogUUID)) {
                    throw new IllegalArgumentException("commit belongs to a different translog: " + generation.translogUUID + " vs. " + this.translogUUID);
                }
                boolean bl = generation.translogFileGeneration == this.currentFileGeneration();
                return bl;
            }
        }
        return false;
    }

    long getFirstOperationPosition() {
        return this.current.getFirstOperationOffset();
    }

    private void ensureOpen() {
        if (this.closed.get()) {
            throw new AlreadyClosedException("translog is already closed", this.current.getTragicException());
        }
    }

    int getNumOpenViews() {
        return this.outstandingViews.size();
    }

    ChannelFactory getChannelFactory() {
        return FileChannel::open;
    }

    public Exception getTragicException() {
        return this.current.getTragicException();
    }

    final Checkpoint readCheckpoint() throws IOException {
        return Checkpoint.read(this.location.resolve(CHECKPOINT_FILE_NAME));
    }

    public String getTranslogUUID() {
        return this.translogUUID;
    }

    public static final class TranslogGeneration {
        public final String translogUUID;
        public final long translogFileGeneration;

        public TranslogGeneration(String translogUUID, long translogFileGeneration) {
            this.translogUUID = translogUUID;
            this.translogFileGeneration = translogFileGeneration;
        }
    }

    public static enum Durability {
        ASYNC,
        REQUEST;

    }

    public static class Delete
    implements Operation {
        public static final int SERIALIZATION_FORMAT = 2;
        private final Term uid;
        private final long version;
        private final VersionType versionType;

        public Delete(StreamInput in) throws IOException {
            int format = in.readVInt();
            assert (format == 2) : "format was: " + format;
            this.uid = new Term(in.readString(), in.readString());
            this.version = in.readLong();
            this.versionType = VersionType.fromValue(in.readByte());
            assert (this.versionType.validateVersionForWrites(this.version));
        }

        public Delete(Engine.Delete delete, Engine.DeleteResult deleteResult) {
            this.uid = delete.uid();
            this.version = deleteResult.getVersion();
            this.versionType = delete.versionType();
        }

        public Delete(Term uid) {
            this(uid, -3L, VersionType.INTERNAL);
        }

        public Delete(Term uid, long version2, VersionType versionType) {
            this.uid = uid;
            this.version = version2;
            this.versionType = versionType;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.DELETE;
        }

        @Override
        public long estimateSize() {
            return (this.uid.field().length() + this.uid.text().length()) * 2 + 20;
        }

        public Term uid() {
            return this.uid;
        }

        public long version() {
            return this.version;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        @Override
        public Source getSource() {
            throw new IllegalStateException("trying to read doc source from delete operation");
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(2);
            out.writeString(this.uid.field());
            out.writeString(this.uid.text());
            out.writeLong(this.version);
            out.writeByte(this.versionType.getValue());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Delete delete = (Delete)o;
            return this.version == delete.version && this.uid.equals(delete.uid) && this.versionType == delete.versionType;
        }

        public int hashCode() {
            int result = this.uid.hashCode();
            result = 31 * result + Long.hashCode(this.version);
            result = 31 * result + this.versionType.hashCode();
            return result;
        }

        public String toString() {
            return "Delete{uid=" + this.uid + '}';
        }
    }

    public static class Index
    implements Operation {
        public static final int FORMAT_2x = 6;
        public static final int FORMAT_AUTO_GENERATED_IDS = 7;
        public static final int SERIALIZATION_FORMAT = 7;
        private final String id;
        private final long autoGeneratedIdTimestamp;
        private final String type;
        private final long version;
        private final VersionType versionType;
        private final BytesReference source;
        private final String routing;
        private final String parent;
        private final long timestamp;
        private final long ttl;

        public Index(StreamInput in) throws IOException {
            int format = in.readVInt();
            assert (format >= 6) : "format was: " + format;
            this.id = in.readString();
            this.type = in.readString();
            this.source = in.readBytesReference();
            this.routing = in.readOptionalString();
            this.parent = in.readOptionalString();
            this.version = in.readLong();
            this.timestamp = in.readLong();
            this.ttl = in.readLong();
            this.versionType = VersionType.fromValue(in.readByte());
            assert (this.versionType.validateVersionForWrites(this.version));
            this.autoGeneratedIdTimestamp = format >= 7 ? in.readLong() : -1L;
        }

        public Index(Engine.Index index, Engine.IndexResult indexResult) {
            this.id = index.id();
            this.type = index.type();
            this.source = index.source();
            this.routing = index.routing();
            this.parent = index.parent();
            this.version = indexResult.getVersion();
            this.timestamp = index.timestamp();
            this.ttl = index.ttl();
            this.versionType = index.versionType();
            this.autoGeneratedIdTimestamp = index.getAutoGeneratedIdTimestamp();
        }

        public Index(String type, String id, byte[] source) {
            this.type = type;
            this.id = id;
            this.source = new BytesArray(source);
            this.version = -3L;
            this.versionType = VersionType.INTERNAL;
            this.routing = null;
            this.parent = null;
            this.timestamp = 0L;
            this.ttl = 0L;
            this.autoGeneratedIdTimestamp = -1L;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.INDEX;
        }

        @Override
        public long estimateSize() {
            return (this.id.length() + this.type.length()) * 2 + this.source.length() + 12;
        }

        public String type() {
            return this.type;
        }

        public String id() {
            return this.id;
        }

        public String routing() {
            return this.routing;
        }

        public String parent() {
            return this.parent;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long ttl() {
            return this.ttl;
        }

        public BytesReference source() {
            return this.source;
        }

        public long version() {
            return this.version;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        @Override
        public Source getSource() {
            return new Source(this.source, this.routing, this.parent, this.timestamp, this.ttl);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(7);
            out.writeString(this.id);
            out.writeString(this.type);
            out.writeBytesReference(this.source);
            out.writeOptionalString(this.routing);
            out.writeOptionalString(this.parent);
            out.writeLong(this.version);
            out.writeLong(this.timestamp);
            out.writeLong(this.ttl);
            out.writeByte(this.versionType.getValue());
            out.writeLong(this.autoGeneratedIdTimestamp);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Index index = (Index)o;
            if (!(this.version == index.version && this.timestamp == index.timestamp && this.ttl == index.ttl && this.id.equals(index.id) && this.type.equals(index.type) && this.versionType == index.versionType && this.autoGeneratedIdTimestamp == index.autoGeneratedIdTimestamp && this.source.equals(index.source))) {
                return false;
            }
            if (this.routing != null ? !this.routing.equals(index.routing) : index.routing != null) {
                return false;
            }
            return !(this.parent == null ? index.parent != null : !this.parent.equals(index.parent));
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + Long.hashCode(this.version);
            result = 31 * result + this.versionType.hashCode();
            result = 31 * result + this.source.hashCode();
            result = 31 * result + (this.routing != null ? this.routing.hashCode() : 0);
            result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
            result = 31 * result + Long.hashCode(this.timestamp);
            result = 31 * result + Long.hashCode(this.autoGeneratedIdTimestamp);
            result = 31 * result + Long.hashCode(this.ttl);
            return result;
        }

        public String toString() {
            return "Index{id='" + this.id + '\'' + ", type='" + this.type + '\'' + '}';
        }

        public long getAutoGeneratedIdTimestamp() {
            return this.autoGeneratedIdTimestamp;
        }
    }

    public static class Source {
        public final BytesReference source;
        public final String routing;
        public final String parent;
        public final long timestamp;
        public final long ttl;

        public Source(BytesReference source, String routing, String parent, long timestamp, long ttl) {
            this.source = source;
            this.routing = routing;
            this.parent = parent;
            this.timestamp = timestamp;
            this.ttl = ttl;
        }
    }

    public static interface Operation
    extends Writeable {
        public Type opType();

        public long estimateSize();

        public Source getSource();

        public static Operation readType(StreamInput input) throws IOException {
            Type type = Type.fromId(input.readByte());
            switch (type) {
                case CREATE: {
                    return new Index(input);
                }
                case DELETE: {
                    return new Delete(input);
                }
                case INDEX: {
                    return new Index(input);
                }
            }
            throw new IOException("No type for [" + (Object)((Object)type) + "]");
        }

        public static void writeType(Operation operation, StreamOutput output) throws IOException {
            output.writeByte(operation.opType().id());
            operation.writeTo(output);
        }

        public static enum Type {
            CREATE(1),
            INDEX(2),
            DELETE(3);

            private final byte id;

            private Type(byte id) {
                this.id = id;
            }

            public byte id() {
                return this.id;
            }

            public static Type fromId(byte id) {
                switch (id) {
                    case 1: {
                        return CREATE;
                    }
                    case 2: {
                        return INDEX;
                    }
                    case 3: {
                        return DELETE;
                    }
                }
                throw new IllegalArgumentException("No type mapped for [" + id + "]");
            }
        }
    }

    public static interface Snapshot {
        public int totalOperations();

        public Operation next() throws IOException;
    }

    public static class Location
    implements Comparable<Location> {
        public final long generation;
        public final long translogLocation;
        public final int size;

        Location(long generation, long translogLocation, int size) {
            this.generation = generation;
            this.translogLocation = translogLocation;
            this.size = size;
        }

        public String toString() {
            return "[generation: " + this.generation + ", location: " + this.translogLocation + ", size: " + this.size + "]";
        }

        @Override
        public int compareTo(Location o) {
            if (this.generation == o.generation) {
                return Long.compare(this.translogLocation, o.translogLocation);
            }
            return Long.compare(this.generation, o.generation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            if (this.generation != location.generation) {
                return false;
            }
            if (this.translogLocation != location.translogLocation) {
                return false;
            }
            return this.size == location.size;
        }

        public int hashCode() {
            int result = Long.hashCode(this.generation);
            result = 31 * result + Long.hashCode(this.translogLocation);
            result = 31 * result + this.size;
            return result;
        }
    }

    public class View
    implements Closeable {
        AtomicBoolean closed = new AtomicBoolean();
        final long minGeneration;

        View(long minGeneration) {
            this.minGeneration = minGeneration;
        }

        public long minTranslogGeneration() {
            return this.minGeneration;
        }

        public int totalOperations() {
            return Translog.this.totalOperations(this.minGeneration);
        }

        public long sizeInBytes() {
            return Translog.this.sizeInBytes(this.minGeneration);
        }

        public Snapshot snapshot() {
            this.ensureOpen();
            return Translog.this.createSnapshot(this.minGeneration);
        }

        void ensureOpen() {
            if (this.closed.get()) {
                throw new AlreadyClosedException("View is already closed");
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.closed.getAndSet(true)) {
                Translog.this.logger.trace("closing view starting at translog [{}]", (Object)this.minTranslogGeneration());
                boolean removed = Translog.this.outstandingViews.remove(this);
                assert (removed) : "View was never set but was supposed to be removed";
                Translog.this.trimUnreferencedReaders();
                Translog.this.closeFilesIfNoPendingViews();
            }
        }
    }
}

