/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanBoostQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanQuery;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.SpanQueryBuilder;

public class SpanMultiTermQueryBuilder
extends AbstractQueryBuilder<SpanMultiTermQueryBuilder>
implements SpanQueryBuilder {
    public static final String NAME = "span_multi";
    private static final ParseField MATCH_FIELD = new ParseField("match", new String[0]);
    private final MultiTermQueryBuilder multiTermQueryBuilder;

    public SpanMultiTermQueryBuilder(MultiTermQueryBuilder multiTermQueryBuilder) {
        if (multiTermQueryBuilder == null) {
            throw new IllegalArgumentException("inner multi term query cannot be null");
        }
        this.multiTermQueryBuilder = multiTermQueryBuilder;
    }

    public SpanMultiTermQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.multiTermQueryBuilder = (MultiTermQueryBuilder)in.readNamedWriteable(QueryBuilder.class);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.multiTermQueryBuilder);
    }

    public MultiTermQueryBuilder innerQuery() {
        return this.multiTermQueryBuilder;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(MATCH_FIELD.getPreferredName());
        this.multiTermQueryBuilder.toXContent(builder, params);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<SpanMultiTermQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser2 = parseContext.parser();
        String currentFieldName = null;
        MultiTermQueryBuilder subQuery = null;
        String queryName = null;
        float boost = 1.0f;
        while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser2.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (MATCH_FIELD.match(currentFieldName)) {
                    Optional<QueryBuilder> query = parseContext.parseInnerQueryBuilder();
                    if (!query.isPresent() || !(query.get() instanceof MultiTermQueryBuilder)) {
                        throw new ParsingException(parser2.getTokenLocation(), "[span_multi] [" + MATCH_FIELD.getPreferredName() + "] must be of type multi term query", new Object[0]);
                    }
                    subQuery = (MultiTermQueryBuilder)query.get();
                    continue;
                }
                throw new ParsingException(parser2.getTokenLocation(), "[span_multi] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                queryName = parser2.text();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                boost = parser2.floatValue();
                continue;
            }
            throw new ParsingException(parser2.getTokenLocation(), "[span_multi] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (subQuery == null) {
            throw new ParsingException(parser2.getTokenLocation(), "[span_multi] must have [" + MATCH_FIELD.getPreferredName() + "] multi term query clause", new Object[0]);
        }
        return Optional.of(((SpanMultiTermQueryBuilder)new SpanMultiTermQueryBuilder(subQuery).queryName(queryName)).boost(boost));
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query subQuery = this.multiTermQueryBuilder.toQuery(context);
        float boost = 1.0f;
        if (subQuery instanceof BoostQuery) {
            BoostQuery boostQuery = (BoostQuery)subQuery;
            subQuery = boostQuery.getQuery();
            boost = boostQuery.getBoost();
        }
        assert (!(subQuery instanceof SpanBoostQuery));
        if (!(subQuery instanceof MultiTermQuery)) {
            throw new UnsupportedOperationException("unsupported inner query, should be " + MultiTermQuery.class.getName() + " but was " + subQuery.getClass().getName());
        }
        SpanQuery wrapper = new SpanMultiTermQueryWrapper<MultiTermQuery>((MultiTermQuery)subQuery);
        if (boost != 1.0f) {
            wrapper = new SpanBoostQuery(wrapper, boost);
        }
        return wrapper;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.multiTermQueryBuilder);
    }

    @Override
    protected boolean doEquals(SpanMultiTermQueryBuilder other) {
        return Objects.equals(this.multiTermQueryBuilder, other.multiTermQueryBuilder);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

