/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.search.lookup.SourceLookup;

public class GetResult
implements Streamable,
Iterable<GetField>,
ToXContentObject {
    private static final String _INDEX = "_index";
    private static final String _TYPE = "_type";
    private static final String _ID = "_id";
    private static final String _VERSION = "_version";
    private static final String FOUND = "found";
    private static final String FIELDS = "fields";
    private String index;
    private String type;
    private String id;
    private long version;
    private boolean exists;
    private Map<String, GetField> fields;
    private Map<String, Object> sourceAsMap;
    private BytesReference source;
    private byte[] sourceAsBytes;

    GetResult() {
    }

    public GetResult(String index, String type, String id, long version2, boolean exists, BytesReference source, Map<String, GetField> fields) {
        this.index = index;
        this.type = type;
        this.id = id;
        this.version = version2;
        this.exists = exists;
        this.source = source;
        this.fields = fields;
        if (this.fields == null) {
            this.fields = Collections.emptyMap();
        }
    }

    public boolean isExists() {
        return this.exists;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public byte[] source() {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsBytes != null) {
            return this.sourceAsBytes;
        }
        this.sourceAsBytes = BytesReference.toBytes(this.sourceRef());
        return this.sourceAsBytes;
    }

    public BytesReference sourceRef() {
        if (this.source == null) {
            return null;
        }
        try {
            this.source = CompressorFactory.uncompressIfNeeded(this.source);
            return this.source;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to decompress source", (Throwable)e, new Object[0]);
        }
    }

    public BytesReference internalSourceRef() {
        return this.source;
    }

    public boolean isSourceEmpty() {
        return this.source == null;
    }

    public String sourceAsString() {
        if (this.source == null) {
            return null;
        }
        BytesReference source = this.sourceRef();
        try {
            return XContentHelper.convertToJson(source, false);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to convert source to a json string", new Object[0]);
        }
    }

    public Map<String, Object> sourceAsMap() throws ElasticsearchParseException {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsMap != null) {
            return this.sourceAsMap;
        }
        this.sourceAsMap = SourceLookup.sourceAsMap(this.source);
        return this.sourceAsMap;
    }

    public Map<String, Object> getSource() {
        return this.sourceAsMap();
    }

    public Map<String, GetField> getFields() {
        return this.fields;
    }

    public GetField field(String name) {
        return this.fields.get(name);
    }

    @Override
    public Iterator<GetField> iterator() {
        if (this.fields == null) {
            return Collections.emptyIterator();
        }
        return this.fields.values().iterator();
    }

    public XContentBuilder toXContentEmbedded(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ArrayList<GetField> metaFields = new ArrayList<GetField>();
        ArrayList<GetField> otherFields = new ArrayList<GetField>();
        if (this.fields != null && !this.fields.isEmpty()) {
            for (GetField field : this.fields.values()) {
                if (field.getValues().isEmpty()) continue;
                if (field.isMetadataField()) {
                    metaFields.add(field);
                    continue;
                }
                otherFields.add(field);
            }
        }
        for (GetField field : metaFields) {
            builder.field(field.getName(), field.getValue());
        }
        builder.field(FOUND, this.exists);
        if (this.source != null) {
            XContentHelper.writeRawField("_source", this.source, builder, params);
        }
        if (!otherFields.isEmpty()) {
            builder.startObject(FIELDS);
            for (GetField field : otherFields) {
                field.toXContent(builder, params);
            }
            builder.endObject();
        }
        return builder;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(_INDEX, this.index);
        builder.field(_TYPE, this.type);
        builder.field(_ID, this.id);
        if (this.isExists()) {
            if (this.version != -1L) {
                builder.field(_VERSION, this.version);
            }
            this.toXContentEmbedded(builder, params);
        } else {
            builder.field(FOUND, false);
        }
        builder.endObject();
        return builder;
    }

    public static GetResult fromXContentEmbedded(XContentParser parser2) throws IOException {
        XContentParser.Token token = parser2.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser2::getTokenLocation);
        String currentFieldName = parser2.currentName();
        String index = null;
        String type = null;
        String id = null;
        long version2 = -1L;
        boolean found = false;
        BytesReference source = null;
        HashMap<String, GetField> fields = new HashMap<String, GetField>();
        while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser2.currentName();
                continue;
            }
            if (token.isValue()) {
                if (_INDEX.equals(currentFieldName)) {
                    index = parser2.text();
                    continue;
                }
                if (_TYPE.equals(currentFieldName)) {
                    type = parser2.text();
                    continue;
                }
                if (_ID.equals(currentFieldName)) {
                    id = parser2.text();
                    continue;
                }
                if (_VERSION.equals(currentFieldName)) {
                    version2 = parser2.longValue();
                    continue;
                }
                if (FOUND.equals(currentFieldName)) {
                    found = parser2.booleanValue();
                    continue;
                }
                fields.put(currentFieldName, new GetField(currentFieldName, Collections.singletonList(parser2.objectText())));
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            if ("_source".equals(currentFieldName)) {
                XContentBuilder builder = XContentBuilder.builder(parser2.contentType().xContent());
                Throwable throwable = null;
                try {
                    builder.copyCurrentStructure(parser2);
                    source = builder.bytes();
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (builder == null) continue;
                    if (throwable != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    builder.close();
                    continue;
                }
            }
            if (FIELDS.equals(currentFieldName)) {
                while (parser2.nextToken() != XContentParser.Token.END_OBJECT) {
                    GetField getField = GetField.fromXContent(parser2);
                    fields.put(getField.getName(), getField);
                }
                continue;
            }
            XContentParserUtils.throwUnknownField(currentFieldName, parser2.getTokenLocation());
        }
        return new GetResult(index, type, id, version2, found, source, fields);
    }

    public static GetResult fromXContent(XContentParser parser2) throws IOException {
        XContentParser.Token token = parser2.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser2::getTokenLocation);
        return GetResult.fromXContentEmbedded(parser2);
    }

    public static GetResult readGetResult(StreamInput in) throws IOException {
        GetResult result = new GetResult();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = in.readString();
        this.type = in.readOptionalString();
        this.id = in.readString();
        this.version = in.readLong();
        this.exists = in.readBoolean();
        if (this.exists) {
            int size;
            this.source = in.readBytesReference();
            if (this.source.length() == 0) {
                this.source = null;
            }
            if ((size = in.readVInt()) == 0) {
                this.fields = Collections.emptyMap();
            } else {
                this.fields = new HashMap<String, GetField>(size);
                for (int i = 0; i < size; ++i) {
                    GetField field = GetField.readGetField(in);
                    this.fields.put(field.getName(), field);
                }
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeOptionalString(this.type);
        out.writeString(this.id);
        out.writeLong(this.version);
        out.writeBoolean(this.exists);
        if (this.exists) {
            out.writeBytesReference(this.source);
            if (this.fields == null) {
                out.writeVInt(0);
            } else {
                out.writeVInt(this.fields.size());
                for (GetField field : this.fields.values()) {
                    field.writeTo(out);
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetResult getResult = (GetResult)o;
        return this.version == getResult.version && this.exists == getResult.exists && Objects.equals(this.index, getResult.index) && Objects.equals(this.type, getResult.type) && Objects.equals(this.id, getResult.id) && Objects.equals(this.fields, getResult.fields) && Objects.equals(this.sourceAsMap(), getResult.sourceAsMap());
    }

    public int hashCode() {
        return Objects.hash(this.index, this.type, this.id, this.version, this.exists, this.fields, this.sourceAsMap());
    }
}

