/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.TranslogRecoveryPerformer;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.threadpool.ThreadPool;

public final class EngineConfig {
    private final ShardId shardId;
    private final TranslogRecoveryPerformer translogRecoveryPerformer;
    private final IndexSettings indexSettings;
    private final ByteSizeValue indexingBufferSize;
    private volatile boolean enableGcDeletes = true;
    private final TimeValue flushMergesAfter;
    private final String codecName;
    private final ThreadPool threadPool;
    private final Engine.Warmer warmer;
    private final Store store;
    private final SnapshotDeletionPolicy deletionPolicy;
    private final MergePolicy mergePolicy;
    private final Analyzer analyzer;
    private final Similarity similarity;
    private final CodecService codecService;
    private final Engine.EventListener eventListener;
    private final QueryCache queryCache;
    private final QueryCachingPolicy queryCachingPolicy;
    private final long maxUnsafeAutoIdTimestamp;
    @Nullable
    private final ReferenceManager.RefreshListener refreshListeners;
    public static final Setting<String> INDEX_CODEC_SETTING = new Setting<String>("index.codec", "default", s2 -> {
        switch (s2) {
            case "default": 
            case "best_compression": 
            case "lucene_default": {
                return s2;
            }
        }
        if (!Codec.availableCodecs().contains(s2)) {
            throw new IllegalArgumentException("unknown value for [index.codec] must be one of [default, best_compression] but was: " + s2);
        }
        return s2;
    }, Setting.Property.IndexScope, Setting.Property.NodeScope);
    public static final Setting<Boolean> INDEX_OPTIMIZE_AUTO_GENERATED_IDS = Setting.boolSetting("index.optimize_auto_generated_id", true, Setting.Property.IndexScope, Setting.Property.Dynamic);
    private final TranslogConfig translogConfig;
    private final OpenMode openMode;

    public EngineConfig(OpenMode openMode, ShardId shardId, ThreadPool threadPool, IndexSettings indexSettings, Engine.Warmer warmer, Store store, SnapshotDeletionPolicy deletionPolicy, MergePolicy mergePolicy, Analyzer analyzer, Similarity similarity, CodecService codecService, Engine.EventListener eventListener, TranslogRecoveryPerformer translogRecoveryPerformer, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, TranslogConfig translogConfig, TimeValue flushMergesAfter, ReferenceManager.RefreshListener refreshListeners, long maxUnsafeAutoIdTimestamp) {
        if (openMode == null) {
            throw new IllegalArgumentException("openMode must not be null");
        }
        this.shardId = shardId;
        this.indexSettings = indexSettings;
        this.threadPool = threadPool;
        this.warmer = warmer == null ? a -> {} : warmer;
        this.store = store;
        this.deletionPolicy = deletionPolicy;
        this.mergePolicy = mergePolicy;
        this.analyzer = analyzer;
        this.similarity = similarity;
        this.codecService = codecService;
        this.eventListener = eventListener;
        this.codecName = indexSettings.getValue(INDEX_CODEC_SETTING);
        this.indexingBufferSize = new ByteSizeValue(256L, ByteSizeUnit.MB);
        this.translogRecoveryPerformer = translogRecoveryPerformer;
        this.queryCache = queryCache;
        this.queryCachingPolicy = queryCachingPolicy;
        this.translogConfig = translogConfig;
        this.flushMergesAfter = flushMergesAfter;
        this.openMode = openMode;
        this.refreshListeners = refreshListeners;
        assert (maxUnsafeAutoIdTimestamp >= -1L) : "maxUnsafeAutoIdTimestamp must be >= -1 but was " + maxUnsafeAutoIdTimestamp;
        this.maxUnsafeAutoIdTimestamp = maxUnsafeAutoIdTimestamp;
    }

    public void setEnableGcDeletes(boolean enableGcDeletes) {
        this.enableGcDeletes = enableGcDeletes;
    }

    public ByteSizeValue getIndexingBufferSize() {
        return this.indexingBufferSize;
    }

    public boolean isEnableGcDeletes() {
        return this.enableGcDeletes;
    }

    public Codec getCodec() {
        return this.codecService.codec(this.codecName);
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Engine.Warmer getWarmer() {
        return this.warmer;
    }

    public Store getStore() {
        return this.store;
    }

    public SnapshotDeletionPolicy getDeletionPolicy() {
        return this.deletionPolicy;
    }

    public MergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    public Engine.EventListener getEventListener() {
        return this.eventListener;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public TranslogRecoveryPerformer getTranslogRecoveryPerformer() {
        return this.translogRecoveryPerformer;
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.queryCachingPolicy;
    }

    public TranslogConfig getTranslogConfig() {
        return this.translogConfig;
    }

    public TimeValue getFlushMergesAfter() {
        return this.flushMergesAfter;
    }

    public OpenMode getOpenMode() {
        return this.openMode;
    }

    public ReferenceManager.RefreshListener getRefreshListeners() {
        return this.refreshListeners;
    }

    public long getMaxUnsafeAutoIdTimestamp() {
        return this.indexSettings.getValue(INDEX_OPTIMIZE_AUTO_GENERATED_IDS) != false ? this.maxUnsafeAutoIdTimestamp : Long.MAX_VALUE;
    }

    public static enum OpenMode {
        CREATE_INDEX_AND_TRANSLOG,
        OPEN_INDEX_CREATE_TRANSLOG,
        OPEN_INDEX_AND_TRANSLOG;

    }
}

