/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import com.carrotsearch.hppc.ObjectArrayList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefArray;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.IntroSorter;

public class CollectionUtils {
    public static void sort(final long[] array, int len) {
        new IntroSorter(){
            long pivot;

            @Override
            protected void swap(int i, int j) {
                long tmp = array[i];
                array[i] = array[j];
                array[j] = tmp;
            }

            @Override
            protected int compare(int i, int j) {
                return Long.compare(array[i], array[j]);
            }

            @Override
            protected void setPivot(int i) {
                this.pivot = array[i];
            }

            @Override
            protected int comparePivot(int j) {
                return Long.compare(this.pivot, array[j]);
            }
        }.sort(0, len);
    }

    public static void sort(final float[] array, int len) {
        new IntroSorter(){
            float pivot;

            @Override
            protected void swap(int i, int j) {
                float tmp = array[i];
                array[i] = array[j];
                array[j] = tmp;
            }

            @Override
            protected int compare(int i, int j) {
                return Float.compare(array[i], array[j]);
            }

            @Override
            protected void setPivot(int i) {
                this.pivot = array[i];
            }

            @Override
            protected int comparePivot(int j) {
                return Float.compare(this.pivot, array[j]);
            }
        }.sort(0, len);
    }

    public static void sort(final double[] array, int len) {
        new IntroSorter(){
            double pivot;

            @Override
            protected void swap(int i, int j) {
                double tmp = array[i];
                array[i] = array[j];
                array[j] = tmp;
            }

            @Override
            protected int compare(int i, int j) {
                return Double.compare(array[i], array[j]);
            }

            @Override
            protected void setPivot(int i) {
                this.pivot = array[i];
            }

            @Override
            protected int comparePivot(int j) {
                return Double.compare(this.pivot, array[j]);
            }
        }.sort(0, len);
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static <T> List<T> rotate(List<T> list, int distance) {
        if (list.isEmpty()) {
            return list;
        }
        int d = distance % list.size();
        if (d < 0) {
            d += list.size();
        }
        if (d == 0) {
            return list;
        }
        return new RotatedList<T>(list, d);
    }

    public static void sortAndDedup(ObjectArrayList<byte[]> array) {
        int len = array.size();
        if (len > 1) {
            CollectionUtils.sort(array);
            int uniqueCount = 1;
            for (int i = 1; i < len; ++i) {
                if (Arrays.equals(array.get(i), array.get(i - 1))) continue;
                array.set(uniqueCount++, array.get(i));
            }
            array.elementsCount = uniqueCount;
        }
    }

    public static void sort(final ObjectArrayList<byte[]> array) {
        new IntroSorter(){
            byte[] pivot;

            @Override
            protected void swap(int i, int j) {
                byte[] tmp = (byte[])array.get(i);
                array.set(i, array.get(j));
                array.set(j, tmp);
            }

            @Override
            protected int compare(int i, int j) {
                return this.compare((byte[])array.get(i), (byte[])array.get(j));
            }

            @Override
            protected void setPivot(int i) {
                this.pivot = (byte[])array.get(i);
            }

            @Override
            protected int comparePivot(int j) {
                return this.compare(this.pivot, (byte[])array.get(j));
            }

            private int compare(byte[] left, byte[] right) {
                int i = 0;
                for (int j = 0; i < left.length && j < right.length; ++i, ++j) {
                    int a = left[i] & 0xFF;
                    int b = right[j] & 0xFF;
                    if (a == b) continue;
                    return a - b;
                }
                return left.length - right.length;
            }
        }.sort(0, array.size());
    }

    public static int[] toArray(Collection<Integer> ints) {
        Objects.requireNonNull(ints);
        return ints.stream().mapToInt(s2 -> s2).toArray();
    }

    public static void sort(BytesRefArray bytes, int[] indices) {
        CollectionUtils.sort(new BytesRefBuilder(), new BytesRefBuilder(), bytes, indices);
    }

    private static void sort(final BytesRefBuilder scratch, final BytesRefBuilder scratch1, final BytesRefArray bytes, final int[] indices) {
        int numValues = bytes.size();
        assert (indices.length >= numValues);
        if (numValues > 1) {
            new InPlaceMergeSorter(){
                final Comparator<BytesRef> comparator = Comparator.naturalOrder();

                @Override
                protected int compare(int i, int j) {
                    return this.comparator.compare(bytes.get(scratch, indices[i]), bytes.get(scratch1, indices[j]));
                }

                @Override
                protected void swap(int i, int j) {
                    int value_i = indices[i];
                    indices[i] = indices[j];
                    indices[j] = value_i;
                }
            }.sort(0, numValues);
        }
    }

    public static int sortAndDedup(BytesRefArray bytes, int[] indices) {
        BytesRefBuilder scratch = new BytesRefBuilder();
        BytesRefBuilder scratch1 = new BytesRefBuilder();
        int numValues = bytes.size();
        assert (indices.length >= numValues);
        if (numValues <= 1) {
            return numValues;
        }
        CollectionUtils.sort(scratch, scratch1, bytes, indices);
        int uniqueCount = 1;
        BytesRefBuilder previous = scratch;
        BytesRefBuilder current = scratch1;
        bytes.get(previous, indices[0]);
        for (int i = 1; i < numValues; ++i) {
            bytes.get(current, indices[i]);
            if (!previous.get().equals(current.get())) {
                indices[uniqueCount++] = indices[i];
            }
            BytesRefBuilder tmp = previous;
            previous = current;
            current = tmp;
        }
        return uniqueCount;
    }

    public static <E> ArrayList<E> iterableAsArrayList(Iterable<? extends E> elements) {
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        if (elements instanceof Collection) {
            return new ArrayList((Collection)elements);
        }
        ArrayList<E> list = new ArrayList<E>();
        for (E element : elements) {
            list.add(element);
        }
        return list;
    }

    public static <E> ArrayList<E> arrayAsArrayList(E ... elements) {
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        return new ArrayList<E>(Arrays.asList(elements));
    }

    public static <E> ArrayList<E> asArrayList(E first, E ... other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        ArrayList<E> list = new ArrayList<E>(1 + other.length);
        list.add(first);
        list.addAll(Arrays.asList(other));
        return list;
    }

    public static <E> ArrayList<E> asArrayList(E first, E second, E ... other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        ArrayList<E> list = new ArrayList<E>(2 + other.length);
        list.add(first);
        list.add(second);
        list.addAll(Arrays.asList(other));
        return list;
    }

    public static <E> ArrayList<E> newSingletonArrayList(E element) {
        return new ArrayList<E>(Collections.singletonList(element));
    }

    public static <E> LinkedList<E> newLinkedList(Iterable<E> elements) {
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        LinkedList<E> linkedList = new LinkedList<E>();
        for (E element : elements) {
            linkedList.add(element);
        }
        return linkedList;
    }

    public static <E> List<List<E>> eagerPartition(List<E> list, int size) {
        if (list == null) {
            throw new NullPointerException("list");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        ArrayList result = new ArrayList((int)Math.ceil(list.size() / size));
        ArrayList<E> accumulator = new ArrayList<E>(size);
        int count = 0;
        for (E element : list) {
            if (count == size) {
                result.add(accumulator);
                accumulator = new ArrayList(size);
                count = 0;
            }
            accumulator.add(element);
            ++count;
        }
        if (count > 0) {
            result.add(accumulator);
        }
        return result;
    }

    private static class RotatedList<T>
    extends AbstractList<T>
    implements RandomAccess {
        private final List<T> in;
        private final int distance;

        RotatedList(List<T> list, int distance) {
            if (distance < 0 || distance >= list.size()) {
                throw new IllegalArgumentException();
            }
            if (!(list instanceof RandomAccess)) {
                throw new IllegalArgumentException();
            }
            this.in = list;
            this.distance = distance;
        }

        @Override
        public T get(int index) {
            int idx = this.distance + index;
            if (idx < 0 || idx >= this.in.size()) {
                idx -= this.in.size();
            }
            return this.in.get(idx);
        }

        @Override
        public int size() {
            return this.in.size();
        }
    }
}

