/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.AbstractScopedSettings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.MemorySizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class Setting<T>
extends ToXContentToBytes {
    private final Key key;
    protected final Function<Settings, String> defaultValue;
    @Nullable
    private final Setting<T> fallbackSetting;
    private final Function<String, T> parser;
    private final EnumSet<Property> properties;
    private static final EnumSet<Property> EMPTY_PROPERTIES = EnumSet.noneOf(Property.class);

    private Setting(Key key, @Nullable Setting<T> fallbackSetting, Function<Settings, String> defaultValue, Function<String, T> parser2, Property ... properties) {
        assert (this instanceof SecureSetting || this.isGroupSetting() || parser2.apply(defaultValue.apply(Settings.EMPTY)) != null) : "parser returned null";
        this.key = key;
        this.fallbackSetting = fallbackSetting;
        this.defaultValue = defaultValue;
        this.parser = parser2;
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null for setting [" + key + "]");
        }
        if (properties.length == 0) {
            this.properties = EMPTY_PROPERTIES;
        } else {
            this.properties = EnumSet.copyOf(Arrays.asList(properties));
            if (this.isDynamic() && this.isFinal()) {
                throw new IllegalArgumentException("final setting [" + key + "] cannot be dynamic");
            }
        }
    }

    public Setting(Key key, Function<Settings, String> defaultValue, Function<String, T> parser2, Property ... properties) {
        this(key, null, defaultValue, parser2, properties);
    }

    public Setting(String key, String defaultValue, Function<String, T> parser2, Property ... properties) {
        this(key, (Settings s2) -> defaultValue, parser2, properties);
    }

    public Setting(String key, Function<Settings, String> defaultValue, Function<String, T> parser2, Property ... properties) {
        this((Key)new SimpleKey(key), defaultValue, parser2, properties);
    }

    public Setting(Key key, Setting<T> fallbackSetting, Function<String, T> parser2, Property ... properties) {
        this(key, fallbackSetting, fallbackSetting::getRaw, parser2, properties);
    }

    public Setting(String key, Setting<T> fallBackSetting, Function<String, T> parser2, Property ... properties) {
        this((Key)new SimpleKey(key), fallBackSetting, parser2, properties);
    }

    public final String getKey() {
        return this.key.toString();
    }

    public final Key getRawKey() {
        return this.key;
    }

    public final boolean isDynamic() {
        return this.properties.contains((Object)Property.Dynamic);
    }

    public final boolean isFinal() {
        return this.properties.contains((Object)Property.Final);
    }

    public EnumSet<Property> getProperties() {
        return this.properties;
    }

    public boolean isFiltered() {
        return this.properties.contains((Object)Property.Filtered);
    }

    public boolean hasNodeScope() {
        return this.properties.contains((Object)Property.NodeScope);
    }

    public boolean hasIndexScope() {
        return this.properties.contains((Object)Property.IndexScope);
    }

    public boolean isDeprecated() {
        return this.properties.contains((Object)Property.Deprecated);
    }

    public boolean isShared() {
        return this.properties.contains((Object)Property.Shared);
    }

    boolean isGroupSetting() {
        return false;
    }

    boolean hasComplexMatcher() {
        return this.isGroupSetting();
    }

    public String getDefaultRaw(Settings settings) {
        return this.defaultValue.apply(settings);
    }

    public T getDefault(Settings settings) {
        return this.parser.apply(this.getDefaultRaw(settings));
    }

    public boolean exists(Settings settings) {
        return settings.getAsMap().containsKey(this.getKey());
    }

    public T get(Settings settings) {
        String value = this.getRaw(settings);
        try {
            return this.parser.apply(value);
        }
        catch (ElasticsearchParseException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Failed to parse value [" + value + "] for setting [" + this.getKey() + "]", ex);
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Exception t) {
            throw new IllegalArgumentException("Failed to parse value [" + value + "] for setting [" + this.getKey() + "]", t);
        }
    }

    public void diff(Settings.Builder builder, Settings source, Settings defaultSettings) {
        if (!this.exists(source)) {
            builder.put(this.getKey(), this.getRaw(defaultSettings));
        }
    }

    public String getRaw(Settings settings) {
        this.checkDeprecation(settings);
        return settings.get(this.getKey(), this.defaultValue.apply(settings));
    }

    protected void checkDeprecation(Settings settings) {
        if (this.isDeprecated() && this.exists(settings)) {
            DeprecationLogger deprecationLogger = new DeprecationLogger(Loggers.getLogger(this.getClass()));
            deprecationLogger.deprecated("[{}] setting was deprecated in Elasticsearch and will be removed in a future release! See the breaking changes documentation for the next major version.", this.getKey());
        }
    }

    public final boolean match(String toTest) {
        return this.key.match(toTest);
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("key", this.key.toString());
        builder.field("properties", this.properties);
        builder.field("is_group_setting", this.isGroupSetting());
        builder.field("default", this.defaultValue.apply(Settings.EMPTY));
        builder.endObject();
        return builder;
    }

    public final T get(Settings primary, Settings secondary) {
        if (this.exists(primary)) {
            return this.get(primary);
        }
        if (this.exists(secondary)) {
            return this.get(secondary);
        }
        if (this.fallbackSetting == null) {
            return this.get(primary);
        }
        if (this.fallbackSetting.exists(primary)) {
            return this.fallbackSetting.get(primary);
        }
        return this.fallbackSetting.get(secondary);
    }

    public Setting<T> getConcreteSetting(String key) {
        assert (key.startsWith(this.getKey())) : "was " + key + " expected: " + this.getKey();
        return this;
    }

    final AbstractScopedSettings.SettingUpdater<T> newUpdater(Consumer<T> consumer, Logger logger) {
        return this.newUpdater(consumer, logger, s2 -> {});
    }

    AbstractScopedSettings.SettingUpdater<T> newUpdater(Consumer<T> consumer, Logger logger, Consumer<T> validator) {
        if (this.isDynamic()) {
            return new Updater(consumer, logger, validator);
        }
        throw new IllegalStateException("setting [" + this.getKey() + "] is not dynamic");
    }

    static <A, B> AbstractScopedSettings.SettingUpdater<Tuple<A, B>> compoundUpdater(final BiConsumer<A, B> consumer, final Setting<A> aSetting, final Setting<B> bSetting, final Logger logger) {
        final AbstractScopedSettings.SettingUpdater<A> aSettingUpdater = aSetting.newUpdater(null, logger);
        final AbstractScopedSettings.SettingUpdater<B> bSettingUpdater = bSetting.newUpdater(null, logger);
        return new AbstractScopedSettings.SettingUpdater<Tuple<A, B>>(){

            @Override
            public boolean hasChanged(Settings current, Settings previous) {
                return aSettingUpdater.hasChanged(current, previous) || bSettingUpdater.hasChanged(current, previous);
            }

            @Override
            public Tuple<A, B> getValue(Settings current, Settings previous) {
                return new Tuple(aSettingUpdater.getValue(current, previous), bSettingUpdater.getValue(current, previous));
            }

            @Override
            public void apply(Tuple<A, B> value, Settings current, Settings previous) {
                if (aSettingUpdater.hasChanged(current, previous)) {
                    logger.info("updating [{}] from [{}] to [{}]", (Object)aSetting.key, (Object)aSetting.getRaw(previous), (Object)aSetting.getRaw(current));
                }
                if (bSettingUpdater.hasChanged(current, previous)) {
                    logger.info("updating [{}] from [{}] to [{}]", (Object)bSetting.key, (Object)bSetting.getRaw(previous), (Object)bSetting.getRaw(current));
                }
                consumer.accept(value.v1(), value.v2());
            }

            public String toString() {
                return "CompoundUpdater for: " + aSettingUpdater + " and " + bSettingUpdater;
            }
        };
    }

    public static Setting<Float> floatSetting(String key, float defaultValue, Property ... properties) {
        return new Setting<Float>(key, s2 -> Float.toString(defaultValue), Float::parseFloat, properties);
    }

    public static Setting<Float> floatSetting(String key, float defaultValue, float minValue, Property ... properties) {
        return new Setting<Float>(key, s2 -> Float.toString(defaultValue), s2 -> {
            float value = Float.parseFloat(s2);
            if (value < minValue) {
                throw new IllegalArgumentException("Failed to parse value [" + s2 + "] for setting [" + key + "] must be >= " + minValue);
            }
            return Float.valueOf(value);
        }, properties);
    }

    public static Setting<Integer> intSetting(String key, int defaultValue, int minValue, int maxValue, Property ... properties) {
        return new Setting<Integer>(key, s2 -> Integer.toString(defaultValue), s2 -> Setting.parseInt(s2, minValue, maxValue, key), properties);
    }

    public static Setting<Integer> intSetting(String key, int defaultValue, int minValue, Property ... properties) {
        return new Setting<Integer>(key, s2 -> Integer.toString(defaultValue), s2 -> Setting.parseInt(s2, minValue, key), properties);
    }

    public static Setting<Integer> intSetting(String key, Setting<Integer> fallbackSetting, int minValue, Property ... properties) {
        return new Setting<Integer>(key, fallbackSetting, s2 -> Setting.parseInt(s2, minValue, key), properties);
    }

    public static Setting<Long> longSetting(String key, long defaultValue, long minValue, Property ... properties) {
        return new Setting<Long>(key, s2 -> Long.toString(defaultValue), s2 -> Setting.parseLong(s2, minValue, key), properties);
    }

    public static Setting<String> simpleString(String key, Property ... properties) {
        return new Setting<String>(key, s2 -> "", Function.identity(), properties);
    }

    public static int parseInt(String s2, int minValue, String key) {
        return Setting.parseInt(s2, minValue, Integer.MAX_VALUE, key);
    }

    public static int parseInt(String s2, int minValue, int maxValue, String key) {
        int value = Integer.parseInt(s2);
        if (value < minValue) {
            throw new IllegalArgumentException("Failed to parse value [" + s2 + "] for setting [" + key + "] must be >= " + minValue);
        }
        if (value > maxValue) {
            throw new IllegalArgumentException("Failed to parse value [" + s2 + "] for setting [" + key + "] must be <= " + maxValue);
        }
        return value;
    }

    public static long parseLong(String s2, long minValue, String key) {
        long value = Long.parseLong(s2);
        if (value < minValue) {
            throw new IllegalArgumentException("Failed to parse value [" + s2 + "] for setting [" + key + "] must be >= " + minValue);
        }
        return value;
    }

    public static TimeValue parseTimeValue(String s2, TimeValue minValue, String key) {
        TimeValue timeValue = TimeValue.parseTimeValue(s2, null, key);
        if (timeValue.millis() < minValue.millis()) {
            throw new IllegalArgumentException("Failed to parse value [" + s2 + "] for setting [" + key + "] must be >= " + minValue);
        }
        return timeValue;
    }

    public static Setting<Integer> intSetting(String key, int defaultValue, Property ... properties) {
        return Setting.intSetting(key, defaultValue, Integer.MIN_VALUE, properties);
    }

    public static Setting<Boolean> boolSetting(String key, boolean defaultValue, Property ... properties) {
        return new Setting<Boolean>(key, s2 -> Boolean.toString(defaultValue), value -> Setting.parseBoolean(key, value), properties);
    }

    public static Setting<Boolean> boolSetting(String key, Setting<Boolean> fallbackSetting, Property ... properties) {
        return new Setting<Boolean>(key, fallbackSetting, value -> Setting.parseBoolean(key, value), properties);
    }

    public static Setting<Boolean> boolSetting(String key, Function<Settings, String> defaultValueFn, Property ... properties) {
        return new Setting<Boolean>(key, defaultValueFn, value -> Setting.parseBoolean(key, value), properties);
    }

    private static Boolean parseBoolean(String key, String value) {
        boolean booleanValue = Booleans.parseBooleanExact(value);
        if (!Booleans.isStrictlyBoolean(value)) {
            DeprecationLogger deprecationLogger = new DeprecationLogger(Loggers.getLogger(Setting.class));
            deprecationLogger.deprecated("Expected a boolean [true/false] for setting [{}] but got [{}]", key, value);
        }
        return booleanValue;
    }

    public static Setting<ByteSizeValue> byteSizeSetting(String key, ByteSizeValue value, Property ... properties) {
        return Setting.byteSizeSetting(key, (Settings s2) -> value.toString(), properties);
    }

    public static Setting<ByteSizeValue> byteSizeSetting(String key, Setting<ByteSizeValue> fallbackSetting, Property ... properties) {
        return new Setting<ByteSizeValue>(key, fallbackSetting, s2 -> ByteSizeValue.parseBytesSizeValue(s2, key), properties);
    }

    public static Setting<ByteSizeValue> byteSizeSetting(String key, Function<Settings, String> defaultValue, Property ... properties) {
        return new Setting<ByteSizeValue>(key, defaultValue, s2 -> ByteSizeValue.parseBytesSizeValue(s2, key), properties);
    }

    public static Setting<ByteSizeValue> byteSizeSetting(String key, ByteSizeValue defaultValue, ByteSizeValue minValue, ByteSizeValue maxValue, Property ... properties) {
        return Setting.byteSizeSetting(key, (Settings s2) -> defaultValue.toString(), minValue, maxValue, properties);
    }

    public static Setting<ByteSizeValue> byteSizeSetting(String key, Function<Settings, String> defaultValue, ByteSizeValue minValue, ByteSizeValue maxValue, Property ... properties) {
        return new Setting<ByteSizeValue>(key, defaultValue, s2 -> Setting.parseByteSize(s2, minValue, maxValue, key), properties);
    }

    public static ByteSizeValue parseByteSize(String s2, ByteSizeValue minValue, ByteSizeValue maxValue, String key) {
        ByteSizeValue value = ByteSizeValue.parseBytesSizeValue(s2, key);
        if (value.getBytes() < minValue.getBytes()) {
            throw new IllegalArgumentException("Failed to parse value [" + s2 + "] for setting [" + key + "] must be >= " + minValue);
        }
        if (value.getBytes() > maxValue.getBytes()) {
            throw new IllegalArgumentException("Failed to parse value [" + s2 + "] for setting [" + key + "] must be <= " + maxValue);
        }
        return value;
    }

    public static Setting<ByteSizeValue> memorySizeSetting(String key, ByteSizeValue defaultValue, Property ... properties) {
        return Setting.memorySizeSetting(key, (Settings s2) -> defaultValue.toString(), properties);
    }

    public static Setting<ByteSizeValue> memorySizeSetting(String key, Function<Settings, String> defaultValue, Property ... properties) {
        return new Setting<ByteSizeValue>(key, defaultValue, s2 -> MemorySizeValue.parseBytesSizeValueOrHeapRatio(s2, key), properties);
    }

    public static Setting<ByteSizeValue> memorySizeSetting(String key, String defaultPercentage, Property ... properties) {
        return new Setting<ByteSizeValue>(key, s2 -> defaultPercentage, s2 -> MemorySizeValue.parseBytesSizeValueOrHeapRatio(s2, key), properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, List<String> defaultStringValue, Function<String, T> singleValueParser, Property ... properties) {
        return Setting.listSetting(key, (Settings s2) -> defaultStringValue, singleValueParser, properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, Setting<List<T>> fallbackSetting, Function<String, T> singleValueParser, Property ... properties) {
        return Setting.listSetting(key, (Settings s2) -> Setting.parseableStringToList(fallbackSetting.getRaw((Settings)s2)), singleValueParser, properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, final Function<Settings, List<String>> defaultStringValue, Function<String, T> singleValueParser, Property ... properties) {
        if (defaultStringValue.apply(Settings.EMPTY) == null) {
            throw new IllegalArgumentException("default value function must not return null");
        }
        Function<String, List> parser2 = s2 -> Setting.parseableStringToList(s2).stream().map(singleValueParser).collect(Collectors.toList());
        return new Setting<List<T>>((Key)new ListKey(key), s2 -> Setting.arrayToParsableString(((List)defaultStringValue.apply((Settings)s2)).toArray(Strings.EMPTY_ARRAY)), parser2, properties){

            @Override
            public String getRaw(Settings settings) {
                String[] array = settings.getAsArray(this.getKey(), null);
                return array == null ? (String)this.defaultValue.apply(settings) : Setting.arrayToParsableString(array);
            }

            @Override
            boolean hasComplexMatcher() {
                return true;
            }

            @Override
            public boolean exists(Settings settings) {
                boolean exists = super.exists(settings);
                return exists || settings.get(this.getKey() + ".0") != null;
            }

            @Override
            public void diff(Settings.Builder builder, Settings source, Settings defaultSettings) {
                if (!this.exists(source)) {
                    String[] asArray = defaultSettings.getAsArray(this.getKey(), null);
                    if (asArray == null) {
                        builder.putArray(this.getKey(), (List)defaultStringValue.apply(defaultSettings));
                    } else {
                        builder.putArray(this.getKey(), asArray);
                    }
                }
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> parseableStringToList(String parsableString) {
        try (XContentParser xContentParser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, parsableString);){
            XContentParser.Token token = xContentParser.nextToken();
            if (token != XContentParser.Token.START_ARRAY) {
                throw new IllegalArgumentException("expected START_ARRAY but got " + (Object)((Object)token));
            }
            ArrayList<String> list = new ArrayList<String>();
            while ((token = xContentParser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token != XContentParser.Token.VALUE_STRING) {
                    throw new IllegalArgumentException("expected VALUE_STRING but got " + (Object)((Object)token));
                }
                list.add(xContentParser.text());
            }
            ArrayList<String> arrayList2 = list;
            return arrayList2;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("failed to parse array", e);
        }
    }

    private static String arrayToParsableString(String[] array) {
        try {
            XContentBuilder builder = XContentBuilder.builder(XContentType.JSON.xContent());
            builder.startArray();
            for (String element : array) {
                builder.value(element);
            }
            builder.endArray();
            return builder.string();
        }
        catch (IOException ex) {
            throw new ElasticsearchException(ex);
        }
    }

    public static Setting<Settings> groupSetting(String key, Property ... properties) {
        return Setting.groupSetting(key, (Settings s2) -> {}, properties);
    }

    public static Setting<Settings> groupSetting(final String key, final Consumer<Settings> validator, Property ... properties) {
        return new Setting<Settings>((Key)new GroupKey(key), s2 -> "", s2 -> null, properties){

            @Override
            public boolean isGroupSetting() {
                return true;
            }

            @Override
            public String getRaw(Settings settings) {
                Settings subSettings = this.get(settings);
                try {
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    builder.startObject();
                    subSettings.toXContent(builder, EMPTY_PARAMS);
                    builder.endObject();
                    return builder.string();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Settings get(Settings settings) {
                Settings byPrefix = settings.getByPrefix(this.getKey());
                validator.accept(byPrefix);
                return byPrefix;
            }

            @Override
            public boolean exists(Settings settings) {
                for (Map.Entry<String, String> entry : settings.getAsMap().entrySet()) {
                    if (!entry.getKey().startsWith(key)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void diff(Settings.Builder builder, Settings source, Settings defaultSettings) {
                Map<String, String> leftGroup = this.get(source).getAsMap();
                Settings defaultGroup = this.get(defaultSettings);
                for (Map.Entry<String, String> entry : defaultGroup.getAsMap().entrySet()) {
                    if (leftGroup.containsKey(entry.getKey())) continue;
                    builder.put(this.getKey() + entry.getKey(), entry.getValue());
                }
            }

            @Override
            public AbstractScopedSettings.SettingUpdater<Settings> newUpdater(final Consumer<Settings> consumer, final Logger logger, final Consumer<Settings> validator2) {
                if (!this.isDynamic()) {
                    throw new IllegalStateException("setting [" + this.getKey() + "] is not dynamic");
                }
                final 3 setting = this;
                return new AbstractScopedSettings.SettingUpdater<Settings>(){

                    @Override
                    public boolean hasChanged(Settings current, Settings previous) {
                        Settings previousSettings;
                        Settings currentSettings = this.get(current);
                        return !currentSettings.equals(previousSettings = this.get(previous));
                    }

                    @Override
                    public Settings getValue(Settings current, Settings previous) {
                        Settings currentSettings = this.get(current);
                        Settings previousSettings = this.get(previous);
                        try {
                            validator2.accept(currentSettings);
                        }
                        catch (AssertionError | Exception e) {
                            throw new IllegalArgumentException("illegal value can't update [" + key + "] from [" + previousSettings.getAsMap() + "] to [" + currentSettings.getAsMap() + "]", (Throwable)e);
                        }
                        return currentSettings;
                    }

                    @Override
                    public void apply(Settings value, Settings current, Settings previous) {
                        if (logger.isInfoEnabled()) {
                            logger.info("updating [{}] from [{}] to [{}]", (Object)key, (Object)this.getRaw(previous), (Object)this.getRaw(current));
                        }
                        consumer.accept(value);
                    }

                    public String toString() {
                        return "Updater for: " + setting.toString();
                    }
                };
            }
        };
    }

    public static Setting<TimeValue> timeSetting(String key, Function<Settings, TimeValue> defaultValue, TimeValue minValue, Property ... properties) {
        return new Setting<TimeValue>(key, s2 -> ((TimeValue)defaultValue.apply((Settings)s2)).getStringRep(), s2 -> {
            TimeValue timeValue = TimeValue.parseTimeValue(s2, null, key);
            if (timeValue.millis() < minValue.millis()) {
                throw new IllegalArgumentException("Failed to parse value [" + s2 + "] for setting [" + key + "] must be >= " + minValue);
            }
            return timeValue;
        }, properties);
    }

    public static Setting<TimeValue> timeSetting(String key, TimeValue defaultValue, TimeValue minValue, Property ... properties) {
        return Setting.timeSetting(key, (Settings s2) -> defaultValue, minValue, properties);
    }

    public static Setting<TimeValue> timeSetting(String key, TimeValue defaultValue, Property ... properties) {
        return new Setting<TimeValue>(key, s2 -> defaultValue.getStringRep(), s2 -> TimeValue.parseTimeValue(s2, key), properties);
    }

    public static Setting<TimeValue> timeSetting(String key, Setting<TimeValue> fallbackSetting, Property ... properties) {
        return new Setting<TimeValue>(key, fallbackSetting, s2 -> TimeValue.parseTimeValue(s2, key), properties);
    }

    public static Setting<TimeValue> positiveTimeSetting(String key, TimeValue defaultValue, Property ... properties) {
        return Setting.timeSetting(key, defaultValue, TimeValue.timeValueMillis(0L), properties);
    }

    public static Setting<Double> doubleSetting(String key, double defaultValue, double minValue, Property ... properties) {
        return new Setting<Double>(key, s2 -> Double.toString(defaultValue), s2 -> {
            double d = Double.parseDouble(s2);
            if (d < minValue) {
                throw new IllegalArgumentException("Failed to parse value [" + s2 + "] for setting [" + key + "] must be >= " + minValue);
            }
            return d;
        }, properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Setting setting = (Setting)o;
        return Objects.equals(this.key, setting.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public static <T> AffixSetting<T> prefixKeySetting(String prefix, Function<String, Setting<T>> delegateFactory) {
        return Setting.affixKeySetting(new AffixKey(prefix), delegateFactory);
    }

    public static <T> AffixSetting<T> affixKeySetting(String prefix, String suffix, Function<String, Setting<T>> delegateFactory) {
        return Setting.affixKeySetting(new AffixKey(prefix, suffix), delegateFactory);
    }

    private static <T> AffixSetting<T> affixKeySetting(AffixKey key, Function<String, Setting<T>> delegateFactory) {
        Setting<T> delegate = delegateFactory.apply("_na_");
        return new AffixSetting<T>(key, delegate, delegateFactory);
    }

    public static final class AffixKey
    implements Key {
        private final Pattern pattern;
        private final String prefix;
        private final String suffix;

        AffixKey(String prefix) {
            this(prefix, null);
        }

        AffixKey(String prefix, String suffix) {
            assert (prefix != null || suffix != null) : "Either prefix or suffix must be non-null";
            this.prefix = prefix;
            if (!prefix.endsWith(".")) {
                throw new IllegalArgumentException("prefix must end with a '.'");
            }
            this.suffix = suffix;
            this.pattern = suffix == null ? Pattern.compile("(" + Pattern.quote(prefix) + "((?:[-\\w]+[.])*[-\\w]+$))") : Pattern.compile("(" + Pattern.quote(prefix) + "([-\\w]+)\\." + Pattern.quote(suffix) + ")(?:\\.\\d+)?");
        }

        @Override
        public boolean match(String key) {
            return this.pattern.matcher(key).matches();
        }

        String getConcreteString(String key) {
            Matcher matcher = this.pattern.matcher(key);
            if (!matcher.matches()) {
                throw new IllegalStateException("can't get concrete string for key " + key + " key doesn't match");
            }
            return matcher.group(1);
        }

        String getNamespace(String key) {
            Matcher matcher = this.pattern.matcher(key);
            if (!matcher.matches()) {
                throw new IllegalStateException("can't get concrete string for key " + key + " key doesn't match");
            }
            return matcher.group(2);
        }

        public SimpleKey toConcreteKey(String missingPart) {
            StringBuilder key = new StringBuilder();
            if (this.prefix != null) {
                key.append(this.prefix);
            }
            key.append(missingPart);
            if (this.suffix != null) {
                key.append(".");
                key.append(this.suffix);
            }
            return new SimpleKey(key.toString());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.prefix != null) {
                sb.append(this.prefix);
            }
            if (this.suffix != null) {
                sb.append('*');
                sb.append('.');
                sb.append(this.suffix);
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AffixKey that = (AffixKey)o;
            return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.suffix, that.suffix);
        }

        public int hashCode() {
            return Objects.hash(this.prefix, this.suffix);
        }
    }

    public static final class ListKey
    extends SimpleKey {
        private final Pattern pattern;

        public ListKey(String key) {
            super(key);
            this.pattern = Pattern.compile(Pattern.quote(key) + "(\\.\\d+)?");
        }

        @Override
        public boolean match(String toTest) {
            return this.pattern.matcher(toTest).matches();
        }
    }

    public static final class GroupKey
    extends SimpleKey {
        public GroupKey(String key) {
            super(key);
            if (!key.endsWith(".")) {
                throw new IllegalArgumentException("key must end with a '.'");
            }
        }

        @Override
        public boolean match(String toTest) {
            return Regex.simpleMatch(this.key + "*", toTest);
        }
    }

    public static class SimpleKey
    implements Key {
        protected final String key;

        public SimpleKey(String key) {
            this.key = key;
        }

        @Override
        public boolean match(String key) {
            return this.key.equals(key);
        }

        public String toString() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleKey simpleKey = (SimpleKey)o;
            return Objects.equals(this.key, simpleKey.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }

    public static interface Key {
        public boolean match(String var1);
    }

    private final class Updater
    implements AbstractScopedSettings.SettingUpdater<T> {
        private final Consumer<T> consumer;
        private final Logger logger;
        private final Consumer<T> accept;

        Updater(Consumer<T> consumer, Logger logger, Consumer<T> accept) {
            this.consumer = consumer;
            this.logger = logger;
            this.accept = accept;
        }

        public String toString() {
            return "Updater for: " + Setting.this.toString();
        }

        @Override
        public boolean hasChanged(Settings current, Settings previous) {
            String newValue = Setting.this.getRaw(current);
            String value = Setting.this.getRaw(previous);
            assert (!Setting.this.isGroupSetting()) : "group settings must override this method";
            assert (value != null) : "value was null but can't be unless default is null which is invalid";
            return !value.equals(newValue);
        }

        @Override
        public T getValue(Settings current, Settings previous) {
            String newValue = Setting.this.getRaw(current);
            String value = Setting.this.getRaw(previous);
            Object inst = Setting.this.get(current);
            try {
                this.accept.accept(inst);
            }
            catch (AssertionError | Exception e) {
                throw new IllegalArgumentException("illegal value can't update [" + Setting.this.key + "] from [" + value + "] to [" + newValue + "]", (Throwable)e);
            }
            return inst;
        }

        @Override
        public void apply(T value, Settings current, Settings previous) {
            this.logger.info("updating [{}] from [{}] to [{}]", (Object)Setting.this.key, (Object)Setting.this.getRaw(previous), (Object)Setting.this.getRaw(current));
            this.consumer.accept(value);
        }
    }

    public static class AffixSetting<T>
    extends Setting<T> {
        private final AffixKey key;
        private final Function<String, Setting<T>> delegateFactory;

        public AffixSetting(AffixKey key, Setting<T> delegate, Function<String, Setting<T>> delegateFactory) {
            super((Key)key, delegate.defaultValue, ((Setting)delegate).parser, ((Setting)delegate).properties.toArray(new Property[0]));
            this.key = key;
            this.delegateFactory = delegateFactory;
        }

        @Override
        boolean isGroupSetting() {
            return true;
        }

        private Stream<String> matchStream(Settings settings) {
            return settings.getAsMap().keySet().stream().filter(key -> this.match((String)key)).map(settingKey -> this.key.getConcreteString((String)settingKey));
        }

        AbstractScopedSettings.SettingUpdater<Map<AbstractScopedSettings.SettingUpdater<T>, T>> newAffixUpdater(final BiConsumer<String, T> consumer, final Logger logger, final BiConsumer<String, T> validator) {
            return new AbstractScopedSettings.SettingUpdater<Map<AbstractScopedSettings.SettingUpdater<T>, T>>(){

                @Override
                public boolean hasChanged(Settings current, Settings previous) {
                    return Stream.concat(this.matchStream(current), this.matchStream(previous)).findAny().isPresent();
                }

                @Override
                public Map<AbstractScopedSettings.SettingUpdater<T>, T> getValue(Settings current, Settings previous) {
                    IdentityHashMap result = new IdentityHashMap();
                    Stream.concat(this.matchStream(current), this.matchStream(previous)).distinct().forEach(aKey -> {
                        String namespace = key.getNamespace((String)aKey);
                        AbstractScopedSettings.SettingUpdater<Object> updater = this.getConcreteSetting((String)aKey).newUpdater(v -> consumer.accept(namespace, v), logger, v -> validator.accept(namespace, v));
                        if (updater.hasChanged(current, previous)) {
                            Object value = updater.getValue(current, previous);
                            result.put(updater, value);
                        }
                    });
                    return result;
                }

                @Override
                public void apply(Map<AbstractScopedSettings.SettingUpdater<T>, T> value, Settings current, Settings previous) {
                    for (Map.Entry entry : value.entrySet()) {
                        entry.getKey().apply(entry.getValue(), current, previous);
                    }
                }
            };
        }

        @Override
        public T get(Settings settings) {
            throw new UnsupportedOperationException("affix settings can't return values use #getConcreteSetting to obtain a concrete setting");
        }

        @Override
        public String getRaw(Settings settings) {
            throw new UnsupportedOperationException("affix settings can't return values use #getConcreteSetting to obtain a concrete setting");
        }

        @Override
        public Setting<T> getConcreteSetting(String key) {
            if (this.match(key)) {
                return this.delegateFactory.apply(key);
            }
            throw new IllegalArgumentException("key [" + key + "] must match [" + this.getKey() + "] but didn't.");
        }

        public Setting<T> getConcreteSettingForNamespace(String namespace) {
            String fullKey = this.key.toConcreteKey(namespace).toString();
            return this.getConcreteSetting(fullKey);
        }

        @Override
        public void diff(Settings.Builder builder, Settings source, Settings defaultSettings) {
            this.matchStream(defaultSettings).forEach(key -> this.getConcreteSetting((String)key).diff(builder, source, defaultSettings));
        }

        public String getNamespace(Setting<T> concreteSetting) {
            return this.key.getNamespace(concreteSetting.getKey());
        }

        public Stream<Setting<T>> getAllConcreteSettings(Settings settings) {
            return this.matchStream(settings).distinct().map(this::getConcreteSetting);
        }
    }

    public static enum Property {
        Filtered,
        Shared,
        Dynamic,
        Final,
        Deprecated,
        NodeScope,
        IndexScope;

    }
}

