/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.util.ArrayList;
import java.util.Collections;
import joptsimple.OptionSet;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.env.Environment;

class ListKeyStoreCommand
extends EnvironmentAwareCommand {
    ListKeyStoreCommand() {
        super("List entries in the keystore");
    }

    @Override
    protected void execute(Terminal terminal2, OptionSet options, Environment env) throws Exception {
        KeyStoreWrapper keystore = KeyStoreWrapper.load(env.configFile());
        if (keystore == null) {
            throw new UserException(65, "Elasticsearch keystore not found. Use 'create' command to create one.");
        }
        keystore.decrypt(new char[0]);
        ArrayList<String> sortedEntries = new ArrayList<String>(keystore.getSettingNames());
        Collections.sort(sortedEntries);
        for (String entry : sortedEntries) {
            terminal2.println(entry);
        }
    }
}

