/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class JavaVersion
implements Comparable<JavaVersion> {
    private final List<Integer> version;
    private static final JavaVersion CURRENT = JavaVersion.parse(System.getProperty("java.specification.version"));

    public List<Integer> getVersion() {
        return this.version;
    }

    private JavaVersion(List<Integer> version2) {
        if (version2.size() >= 2 && version2.get(0) == 1 && version2.get(1) == 8) {
            version2 = new ArrayList<Integer>(version2.subList(1, version2.size()));
        }
        this.version = Collections.unmodifiableList(version2);
    }

    public static JavaVersion parse(String value) {
        String[] components;
        Objects.requireNonNull(value);
        if (!JavaVersion.isValid(value)) {
            throw new IllegalArgumentException("value");
        }
        ArrayList<Integer> version2 = new ArrayList<Integer>();
        for (String component : components = value.split("\\.")) {
            version2.add(Integer.valueOf(component));
        }
        return new JavaVersion(version2);
    }

    public static boolean isValid(String value) {
        return value.matches("^0*[0-9]+(\\.[0-9]+)*$");
    }

    public static JavaVersion current() {
        return CURRENT;
    }

    @Override
    public int compareTo(JavaVersion o) {
        int len = Math.max(this.version.size(), o.version.size());
        for (int i = 0; i < len; ++i) {
            int s2;
            int d = i < this.version.size() ? this.version.get(i) : 0;
            int n = s2 = i < o.version.size() ? o.version.get(i) : 0;
            if (s2 < d) {
                return 1;
            }
            if (s2 <= d) continue;
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.compareTo((JavaVersion)o) == 0;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        return this.version.stream().map(v -> Integer.toString(v)).collect(Collectors.joining("."));
    }
}

