/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.search.InitialSearchPhase;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseContext;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.transport.Transport;

abstract class AbstractSearchAsyncAction<Result extends SearchPhaseResult>
extends InitialSearchPhase<Result>
implements SearchPhaseContext {
    private static final float DEFAULT_INDEX_BOOST = 1.0f;
    private final Logger logger;
    private final SearchTransportService searchTransportService;
    private final Executor executor;
    private final ActionListener<SearchResponse> listener;
    private final SearchRequest request;
    private final Function<String, Transport.Connection> nodeIdToConnection;
    private final SearchTask task;
    private final InitialSearchPhase.SearchPhaseResults<Result> results;
    private final long clusterStateVersion;
    private final Map<String, AliasFilter> aliasFilter;
    private final Map<String, Float> concreteIndexBoosts;
    private final SetOnce<AtomicArray<ShardSearchFailure>> shardFailures = new SetOnce();
    private final Object shardFailuresMutex = new Object();
    private final AtomicInteger successfulOps = new AtomicInteger();
    private final TransportSearchAction.SearchTimeProvider timeProvider;

    protected AbstractSearchAsyncAction(String name, Logger logger, SearchTransportService searchTransportService, Function<String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, long clusterStateVersion, SearchTask task, InitialSearchPhase.SearchPhaseResults<Result> resultConsumer) {
        super(name, request, shardsIts, logger);
        this.timeProvider = timeProvider;
        this.logger = logger;
        this.searchTransportService = searchTransportService;
        this.executor = executor;
        this.request = request;
        this.task = task;
        this.listener = listener;
        this.nodeIdToConnection = nodeIdToConnection;
        this.clusterStateVersion = clusterStateVersion;
        this.concreteIndexBoosts = concreteIndexBoosts;
        this.aliasFilter = aliasFilter;
        this.results = resultConsumer;
    }

    long buildTookInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.timeProvider.getRelativeCurrentNanos() - this.timeProvider.getRelativeStartNanos());
    }

    public final void start() {
        if (this.getNumShards() == 0) {
            this.listener.onResponse(new SearchResponse(InternalSearchResponse.empty(), null, 0, 0, this.buildTookInMillis(), ShardSearchFailure.EMPTY_ARRAY));
            return;
        }
        this.executePhase(this);
    }

    @Override
    public final void executeNextPhase(SearchPhase currentPhase, SearchPhase nextPhase) {
        if (this.successfulOps.get() == 0) {
            if (this.logger.isDebugEnabled()) {
                ShardOperationFailedException[] shardSearchFailures = ExceptionsHelper.groupBy(this.buildShardFailures());
                ElasticsearchException cause = shardSearchFailures.length == 0 ? null : ElasticsearchException.guessRootCauses(shardSearchFailures[0].getCause())[0];
                this.logger.debug(() -> new ParameterizedMessage("All shards failed for phase: [{}]", (Object)this.getName()), (Throwable)cause);
            }
            this.onPhaseFailure(currentPhase, "all shards failed", null);
        } else {
            if (this.logger.isTraceEnabled()) {
                String resultsFrom = this.results.getSuccessfulResults().map(r -> r.getSearchShardTarget().toString()).collect(Collectors.joining(","));
                this.logger.trace("[{}] Moving to next phase: [{}], based on results from: {} (cluster state version: {})", (Object)currentPhase.getName(), (Object)nextPhase.getName(), (Object)resultsFrom, (Object)this.clusterStateVersion);
            }
            this.executePhase(nextPhase);
        }
    }

    private void executePhase(SearchPhase phase) {
        try {
            phase.run();
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(() -> new ParameterizedMessage("Failed to execute [{}] while moving to [{}] phase", (Object)this.request, (Object)phase.getName()), (Throwable)e);
            }
            this.onPhaseFailure(phase, "", e);
        }
    }

    private ShardSearchFailure[] buildShardFailures() {
        AtomicArray<ShardSearchFailure> shardFailures = this.shardFailures.get();
        if (shardFailures == null) {
            return ShardSearchFailure.EMPTY_ARRAY;
        }
        List<ShardSearchFailure> entries = shardFailures.asList();
        ShardSearchFailure[] failures = new ShardSearchFailure[entries.size()];
        for (int i = 0; i < failures.length; ++i) {
            failures[i] = entries.get(i);
        }
        return failures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onShardFailure(int shardIndex, @Nullable SearchShardTarget shardTarget, Exception e) {
        ShardSearchFailure failure;
        if (TransportActions.isShardNotAvailableException(e)) {
            return;
        }
        AtomicArray<ShardSearchFailure> shardFailures = this.shardFailures.get();
        if (shardFailures == null) {
            Object object = this.shardFailuresMutex;
            synchronized (object) {
                shardFailures = this.shardFailures.get();
                if (shardFailures == null) {
                    shardFailures = new AtomicArray(this.getNumShards());
                    this.shardFailures.set(shardFailures);
                }
            }
        }
        if ((failure = shardFailures.get(shardIndex)) == null) {
            shardFailures.set(shardIndex, new ShardSearchFailure(e, shardTarget));
        } else if (TransportActions.isReadOverrideException(e)) {
            shardFailures.set(shardIndex, new ShardSearchFailure(e, shardTarget));
        }
        if (this.results.hasResult(shardIndex)) {
            assert (failure == null) : "shard failed before but shouldn't: " + failure;
            this.successfulOps.decrementAndGet();
        }
    }

    private void raisePhaseFailure(SearchPhaseExecutionException exception) {
        this.results.getSuccessfulResults().forEach(entry -> {
            try {
                SearchShardTarget searchShardTarget = entry.getSearchShardTarget();
                Transport.Connection connection = this.nodeIdToConnection.apply(searchShardTarget.getNodeId());
                this.sendReleaseSearchContext(entry.getRequestId(), connection, searchShardTarget.getOriginalIndices());
            }
            catch (Exception inner) {
                inner.addSuppressed(exception);
                this.logger.trace("failed to release context", (Throwable)inner);
            }
        });
        this.listener.onFailure(exception);
    }

    @Override
    public final void onShardSuccess(Result result) {
        AtomicArray<ShardSearchFailure> shardFailures;
        this.successfulOps.incrementAndGet();
        this.results.consumeResult(result);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("got first-phase result from {}", (Object)(result != null ? ((SearchPhaseResult)result).getSearchShardTarget() : null));
        }
        if ((shardFailures = this.shardFailures.get()) != null) {
            shardFailures.set(((SearchPhaseResult)result).getShardIndex(), null);
        }
    }

    @Override
    public final void onPhaseDone() {
        this.executeNextPhase(this, this.getNextPhase(this.results, this));
    }

    @Override
    public final int getNumShards() {
        return this.results.getNumShards();
    }

    @Override
    public final Logger getLogger() {
        return this.logger;
    }

    @Override
    public final SearchTask getTask() {
        return this.task;
    }

    @Override
    public final SearchRequest getRequest() {
        return this.request;
    }

    @Override
    public final SearchResponse buildSearchResponse(InternalSearchResponse internalSearchResponse, String scrollId) {
        return new SearchResponse(internalSearchResponse, scrollId, this.getNumShards(), this.successfulOps.get(), this.buildTookInMillis(), this.buildShardFailures());
    }

    @Override
    public final void onPhaseFailure(SearchPhase phase, String msg, Throwable cause) {
        this.raisePhaseFailure(new SearchPhaseExecutionException(phase.getName(), msg, cause, this.buildShardFailures()));
    }

    @Override
    public final Transport.Connection getConnection(String nodeId) {
        return this.nodeIdToConnection.apply(nodeId);
    }

    @Override
    public final SearchTransportService getSearchTransport() {
        return this.searchTransportService;
    }

    @Override
    public final void execute(Runnable command) {
        this.executor.execute(command);
    }

    @Override
    public final void onResponse(SearchResponse response) {
        this.listener.onResponse(response);
    }

    @Override
    public final void onFailure(Exception e) {
        this.listener.onFailure(e);
    }

    @Override
    public final ShardSearchTransportRequest buildShardSearchRequest(SearchShardIterator shardIt, ShardRouting shard) {
        AliasFilter filter = this.aliasFilter.get(shard.index().getUUID());
        assert (filter != null);
        float indexBoost = this.concreteIndexBoosts.getOrDefault(shard.index().getUUID(), Float.valueOf(1.0f)).floatValue();
        return new ShardSearchTransportRequest(shardIt.getOriginalIndices(), this.request, shardIt.shardId(), this.getNumShards(), filter, indexBoost, this.timeProvider.getAbsoluteStartMillis());
    }

    protected abstract SearchPhase getNextPhase(InitialSearchPhase.SearchPhaseResults<Result> var1, SearchPhaseContext var2);
}

