/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointMultiTermQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointTermsEnum;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.SparseFixedBitSet;

@Deprecated
final class GeoPointTermQueryConstantScoreWrapper<Q extends GeoPointMultiTermQuery>
extends Query {
    protected final Q query;

    protected GeoPointTermQueryConstantScoreWrapper(Q query) {
        this.query = query;
    }

    public Q getQuery() {
        return this.query;
    }

    @Override
    public String toString(String field) {
        return ((Query)this.query).toString();
    }

    @Override
    public final boolean equals(Object other) {
        return this.sameClassAs(other) && ((MultiTermQuery)this.query).equals(((GeoPointTermQueryConstantScoreWrapper)other).query);
    }

    @Override
    public final int hashCode() {
        return 31 * this.classHash() + ((MultiTermQuery)this.query).hashCode();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                Terms terms = context.reader().terms(((MultiTermQuery)GeoPointTermQueryConstantScoreWrapper.this.query).getField());
                if (terms == null) {
                    return null;
                }
                final GeoPointTermsEnum termsEnum = (GeoPointTermsEnum)((GeoPointMultiTermQuery)GeoPointTermQueryConstantScoreWrapper.this.query).getTermsEnum(terms, null);
                assert (termsEnum != null);
                LeafReader reader = context.reader();
                DocIdSetBuilder builder = new DocIdSetBuilder(reader.maxDoc(), terms);
                final BitSet preApproved = (long)terms.getDocCount() * 100L < (long)reader.maxDoc() ? new SparseFixedBitSet(reader.maxDoc()) : new FixedBitSet(reader.maxDoc());
                PostingsEnum docs = null;
                while (termsEnum.next() != null) {
                    docs = termsEnum.postings(docs, 0);
                    if (termsEnum.boundaryTerm()) {
                        builder.add(docs);
                        continue;
                    }
                    int numDocs = termsEnum.docFreq();
                    DocIdSetBuilder.BulkAdder adder = builder.grow(numDocs);
                    for (int i = 0; i < numDocs; ++i) {
                        int docId = docs.nextDoc();
                        adder.add(docId);
                        preApproved.set(docId);
                    }
                }
                DocIdSet set = builder.build();
                final DocIdSetIterator disi = set.iterator();
                if (disi == null) {
                    return null;
                }
                final SortedNumericDocValues sdv = reader.getSortedNumericDocValues(((MultiTermQuery)GeoPointTermQueryConstantScoreWrapper.this.query).getField());
                TwoPhaseIterator iterator = new TwoPhaseIterator(disi){

                    @Override
                    public boolean matches() throws IOException {
                        int docId = disi.docID();
                        if (preApproved.get(docId)) {
                            return true;
                        }
                        sdv.setDocument(docId);
                        int count = sdv.count();
                        for (int i = 0; i < count; ++i) {
                            long hash = sdv.valueAt(i);
                            if (!termsEnum.postFilter(GeoPointField.decodeLatitude(hash), GeoPointField.decodeLongitude(hash))) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 20.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), iterator);
            }
        };
    }
}

