/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.highlight.WeightedSpanTerm;
import org.apache.lucene.search.highlight.WeightedSpanTermExtractor;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.util.BytesRef;

public class PhraseHelper {
    public static final PhraseHelper NONE = new PhraseHelper(new MatchAllDocsQuery(), "_ignored_", s2 -> false, spanQuery -> null, query -> null, true);
    private static final Comparator<? super Spans> SPANS_COMPARATOR = (o1, o2) -> {
        int cmp = Integer.compare(o1.docID(), o2.docID());
        if (cmp != 0) {
            return cmp;
        }
        if (o1.docID() == Integer.MAX_VALUE) {
            return 0;
        }
        cmp = Integer.compare(o1.startPosition(), o2.startPosition());
        if (cmp != 0) {
            return cmp;
        }
        return Integer.compare(o1.endPosition(), o2.endPosition());
    };
    private final String fieldName;
    private final Set<Term> positionInsensitiveTerms;
    private final Set<SpanQuery> spanQueries;
    private final boolean willRewrite;
    private final Predicate<String> fieldMatcher;

    public PhraseHelper(final Query query, String field, final Predicate<String> fieldMatcher, final Function<SpanQuery, Boolean> rewriteQueryPred, final Function<Query, Collection<Query>> preExtractRewriteFunction, final boolean ignoreQueriesNeedingRewrite) {
        this.fieldName = field;
        this.fieldMatcher = fieldMatcher;
        this.positionInsensitiveTerms = new FieldFilteringTermSet();
        this.spanQueries = new HashSet<SpanQuery>();
        final boolean[] mustRewriteHolder = new boolean[]{false};
        new WeightedSpanTermExtractor(field){
            {
                super(defaultField);
                this.setExpandMultiTermQuery(true);
                try {
                    this.extract(query, 1.0f, null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void extract(Query query2, float boost, Map<String, WeightedSpanTerm> terms) throws IOException {
                Collection newQueriesToExtract = (Collection)preExtractRewriteFunction.apply(query2);
                if (newQueriesToExtract != null) {
                    for (Query newQuery : newQueriesToExtract) {
                        this.extract(newQuery, boost, terms);
                    }
                } else {
                    super.extract(query2, boost, terms);
                }
            }

            @Override
            protected boolean isQueryUnsupported(Class<? extends Query> clazz) {
                if (clazz.isAssignableFrom(MultiTermQuery.class)) {
                    return true;
                }
                return true;
            }

            @Override
            protected void extractWeightedTerms(Map<String, WeightedSpanTerm> terms, Query query2, float boost) throws IOException {
                query2.createWeight(UnifiedHighlighter.EMPTY_INDEXSEARCHER, false).extractTerms(PhraseHelper.this.positionInsensitiveTerms);
            }

            @Override
            protected void extractWeightedSpanTerms(Map<String, WeightedSpanTerm> terms, SpanQuery spanQuery, float boost) throws IOException {
                HashSet<String> fieldNameSet = new HashSet<String>();
                this.collectSpanQueryFields(spanQuery, fieldNameSet);
                for (String spanField : fieldNameSet) {
                    if (fieldMatcher.test(spanField)) continue;
                    return;
                }
                boolean mustRewriteQuery = this.mustRewriteQuery(spanQuery);
                if (ignoreQueriesNeedingRewrite && mustRewriteQuery) {
                    return;
                }
                mustRewriteHolder[0] = mustRewriteHolder[0] | mustRewriteQuery;
                PhraseHelper.this.spanQueries.add(spanQuery);
            }

            @Override
            protected boolean mustRewriteQuery(SpanQuery spanQuery) {
                Boolean rewriteQ = (Boolean)rewriteQueryPred.apply(spanQuery);
                return rewriteQ != null ? rewriteQ.booleanValue() : super.mustRewriteQuery(spanQuery);
            }
        };
        this.willRewrite = mustRewriteHolder[0];
    }

    Set<SpanQuery> getSpanQueries() {
        return this.spanQueries;
    }

    boolean hasPositionSensitivity() {
        return !this.spanQueries.isEmpty();
    }

    boolean willRewrite() {
        return this.willRewrite;
    }

    Map<BytesRef, Spans> getTermToSpans(LeafReader leafReader, int doc) throws IOException {
        if (this.spanQueries.isEmpty()) {
            return Collections.emptyMap();
        }
        SingleFieldFilterLeafReader filteredReader = new SingleFieldFilterLeafReader(leafReader, this.fieldName);
        HashMap<BytesRef, Spans> result = new HashMap<BytesRef, Spans>();
        for (SpanQuery spanQuery : this.spanQueries) {
            this.getTermToSpans(spanQuery, filteredReader.getContext(), doc, result);
        }
        return result;
    }

    private void getTermToSpans(SpanQuery spanQuery, LeafReaderContext readerContext, int doc, Map<BytesRef, Spans> result) throws IOException {
        IndexSearcher searcher = new IndexSearcher(readerContext.reader());
        searcher.setQueryCache(null);
        if (this.willRewrite) {
            spanQuery = (SpanQuery)searcher.rewrite(spanQuery);
        }
        FieldFilteringTermSet termSet = new FieldFilteringTermSet();
        searcher.createWeight(spanQuery, false).extractTerms(termSet);
        SpanWeight spanWeight = (SpanWeight)searcher.createNormalizedWeight(spanQuery, false);
        Spans spans = spanWeight.getSpans(readerContext, SpanWeight.Postings.POSITIONS);
        if (spans == null) {
            return;
        }
        TwoPhaseIterator twoPhaseIterator = spans.asTwoPhaseIterator();
        if (twoPhaseIterator != null ? twoPhaseIterator.approximation().advance(doc) != doc || !twoPhaseIterator.matches() : spans.advance(doc) != doc) {
            return;
        }
        CachedSpans cachedSpansSource = new CachedSpans(spans);
        spans = null;
        for (Term queryTerm : termSet) {
            if (this.positionInsensitiveTerms.contains(queryTerm)) continue;
            CachedSpans cachedSpans = new CachedSpans(cachedSpansSource);
            Spans existingSpans = result.get(queryTerm.bytes());
            if (existingSpans != null) {
                if (existingSpans instanceof MultiSpans) {
                    ((MultiSpans)existingSpans).addSpans(cachedSpans);
                    continue;
                }
                MultiSpans multiSpans = new MultiSpans();
                multiSpans.addSpans(existingSpans);
                multiSpans.addSpans(cachedSpans);
                result.put(queryTerm.bytes(), multiSpans);
                continue;
            }
            result.put(queryTerm.bytes(), cachedSpans);
        }
    }

    List<BytesRef> expandTermsIfRewrite(BytesRef[] terms, Map<BytesRef, Spans> strictPhrasesTermToSpans) {
        if (this.willRewrite()) {
            LinkedHashSet<BytesRef> allTermSet = new LinkedHashSet<BytesRef>(terms.length + strictPhrasesTermToSpans.size());
            Collections.addAll(allTermSet, terms);
            if (allTermSet.addAll(strictPhrasesTermToSpans.keySet())) {
                List<BytesRef> sourceTerms = Arrays.asList(allTermSet.toArray(new BytesRef[allTermSet.size()]));
                sourceTerms.sort(Comparator.naturalOrder());
                return sourceTerms;
            }
        }
        return Arrays.asList(terms);
    }

    PostingsEnum filterPostings(final BytesRef term, final PostingsEnum postingsEnum, final Spans spans) throws IOException {
        if (spans == null) {
            if (!this.hasPositionSensitivity() || this.positionInsensitiveTerms.contains(new Term(this.fieldName, term))) {
                return postingsEnum;
            }
            return null;
        }
        if (postingsEnum.docID() != spans.docID()) {
            throw new IllegalStateException("Spans & Postings doc ID misaligned or not positioned");
        }
        return new FilterLeafReader.FilterPostingsEnum(postingsEnum){
            int remainingPositions;
            {
                super(x0);
                this.remainingPositions = postingsEnum.freq();
            }

            public String toString() {
                String where;
                try {
                    where = "[" + this.startOffset() + ":" + this.endOffset() + "]";
                }
                catch (IOException e) {
                    where = "[" + e + "]";
                }
                return "'" + term.utf8ToString() + "'@" + where + " filtered by " + spans;
            }

            @Override
            public int nextDoc() throws IOException {
                throw new IllegalStateException("not expected");
            }

            @Override
            public int advance(int target) throws IOException {
                throw new IllegalStateException("not expected");
            }

            @Override
            public int nextPosition() throws IOException {
                block0: while (this.remainingPositions > 0) {
                    int thisPos = super.nextPosition();
                    --this.remainingPositions;
                    while (spans.endPosition() <= thisPos) {
                        if (spans.nextStartPosition() == Integer.MAX_VALUE) break block0;
                        assert (spans.docID() == postingsEnum.docID());
                    }
                    if (thisPos < spans.startPosition()) continue;
                    assert (thisPos < spans.endPosition());
                    return thisPos;
                }
                this.remainingPositions = -1;
                return Integer.MAX_VALUE;
            }

            @Override
            public int startOffset() throws IOException {
                return this.remainingPositions >= 0 ? super.startOffset() : Integer.MAX_VALUE;
            }

            @Override
            public int endOffset() throws IOException {
                return this.remainingPositions >= 0 ? super.endOffset() : Integer.MAX_VALUE;
            }
        };
    }

    static /* synthetic */ Comparator access$500() {
        return SPANS_COMPARATOR;
    }

    private static class CachedSpans
    extends Spans {
        final int docId;
        final ArrayList<CachedSpan> cachedSpanList;
        int index = -1;

        CachedSpans(Spans spans) throws IOException {
            this.docId = spans.docID();
            assert (this.docId != -1);
            this.cachedSpanList = new ArrayList();
            while (spans.nextStartPosition() != Integer.MAX_VALUE) {
                this.cachedSpanList.add(new CachedSpan(spans.startPosition(), spans.endPosition()));
            }
            assert (!this.cachedSpanList.isEmpty());
        }

        CachedSpans(CachedSpans cloneMe) {
            this.docId = cloneMe.docId;
            this.cachedSpanList = cloneMe.cachedSpanList;
        }

        @Override
        public int nextDoc() throws IOException {
            throw new UnsupportedOperationException("Not expected");
        }

        @Override
        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException("Not expected");
        }

        @Override
        public int docID() {
            return this.docId;
        }

        @Override
        public long cost() {
            return 1L;
        }

        @Override
        public int nextStartPosition() throws IOException {
            ++this.index;
            return this.startPosition();
        }

        @Override
        public int startPosition() {
            return this.index < 0 ? -1 : (this.index >= this.cachedSpanList.size() ? Integer.MAX_VALUE : this.cachedSpanList.get((int)this.index).start);
        }

        @Override
        public int endPosition() {
            return this.index < 0 ? -1 : (this.index >= this.cachedSpanList.size() ? Integer.MAX_VALUE : this.cachedSpanList.get((int)this.index).end);
        }

        @Override
        public int width() {
            return this.endPosition() - this.startPosition();
        }

        @Override
        public void collect(SpanCollector collector) throws IOException {
            throw new UnsupportedOperationException("Not expected");
        }

        @Override
        public float positionsCost() {
            return 1.0f;
        }

        private static class CachedSpan {
            final int start;
            final int end;

            CachedSpan(int start, int end) {
                this.start = start;
                this.end = end;
            }
        }
    }

    static final class SingleFieldFilterLeafReader
    extends FilterLeafReader {
        final String fieldName;

        SingleFieldFilterLeafReader(LeafReader in, String fieldName) {
            super(in);
            this.fieldName = fieldName;
        }

        @Override
        public FieldInfos getFieldInfos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Fields fields() throws IOException {
            return new FilterLeafReader.FilterFields(super.fields()){

                @Override
                public Terms terms(String field) throws IOException {
                    return super.terms(fieldName);
                }

                @Override
                public Iterator<String> iterator() {
                    return Collections.singletonList(fieldName).iterator();
                }

                @Override
                public int size() {
                    return 1;
                }
            };
        }

        @Override
        public NumericDocValues getNumericDocValues(String field) throws IOException {
            return super.getNumericDocValues(this.fieldName);
        }

        @Override
        public BinaryDocValues getBinaryDocValues(String field) throws IOException {
            return super.getBinaryDocValues(this.fieldName);
        }

        @Override
        public SortedDocValues getSortedDocValues(String field) throws IOException {
            return super.getSortedDocValues(this.fieldName);
        }

        @Override
        public NumericDocValues getNormValues(String field) throws IOException {
            return super.getNormValues(this.fieldName);
        }
    }

    static class MultiSpans
    extends Spans {
        final PriorityQueue<Spans> spansQueue = new PriorityQueue(PhraseHelper.access$500());
        long cost;

        MultiSpans() {
        }

        void addSpans(Spans spans) {
            if (spans.docID() < 0 || spans.docID() == Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Expecting given spans to be in a positioned state.");
            }
            this.spansQueue.add(spans);
            this.cost = Math.max(this.cost, spans.cost());
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.spansQueue.isEmpty()) {
                return Integer.MAX_VALUE;
            }
            return this.advance(this.spansQueue.peek().docID() + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            if (this.spansQueue.isEmpty()) {
                return Integer.MAX_VALUE;
            }
            while (true) {
                Spans spans;
                if ((spans = this.spansQueue.peek()).docID() >= target) {
                    return spans.docID();
                }
                this.spansQueue.remove();
                if (spans.advance(target) != Integer.MAX_VALUE) {
                    this.spansQueue.add(spans);
                    continue;
                }
                if (this.spansQueue.isEmpty()) break;
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int docID() {
            if (this.spansQueue.isEmpty()) {
                return Integer.MAX_VALUE;
            }
            return this.spansQueue.peek().docID();
        }

        @Override
        public long cost() {
            return this.cost;
        }

        @Override
        public int nextStartPosition() throws IOException {
            Spans headSpans;
            boolean atDocStart = false;
            while (this.spansQueue.peek().startPosition() == -1) {
                atDocStart = true;
                headSpans = (Spans)this.spansQueue.remove();
                headSpans.nextStartPosition();
                this.spansQueue.add(headSpans);
            }
            if (!atDocStart) {
                headSpans = (Spans)this.spansQueue.remove();
                headSpans.nextStartPosition();
                this.spansQueue.add(headSpans);
            }
            return this.startPosition();
        }

        @Override
        public int startPosition() {
            return this.spansQueue.peek().startPosition();
        }

        @Override
        public int endPosition() {
            return this.spansQueue.peek().endPosition();
        }

        @Override
        public int width() {
            return this.spansQueue.peek().width();
        }

        @Override
        public void collect(SpanCollector collector) throws IOException {
            this.spansQueue.peek().collect(collector);
        }

        @Override
        public float positionsCost() {
            return 100.0f;
        }
    }

    private class FieldFilteringTermSet
    extends TreeSet<Term> {
        private FieldFilteringTermSet() {
        }

        @Override
        public boolean add(Term term) {
            if (PhraseHelper.this.fieldMatcher.test(term.field())) {
                if (term.field().equals(PhraseHelper.this.fieldName)) {
                    return super.add(term);
                }
                return super.add(new Term(PhraseHelper.this.fieldName, term.bytes()));
            }
            return false;
        }
    }
}

