/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import org.apache.lucene.search.similarities.Axiomatic;
import org.apache.lucene.search.similarities.BasicStats;

public class AxiomaticF3EXP
extends Axiomatic {
    public AxiomaticF3EXP(float s2, int queryLen, float k) {
        super(s2, queryLen, k);
    }

    public AxiomaticF3EXP(float s2, int queryLen) {
        this(s2, queryLen, 0.35f);
    }

    @Override
    public String toString() {
        return "F3EXP";
    }

    @Override
    protected float tf(BasicStats stats, float freq, float docLen) {
        if ((double)freq <= 0.0) {
            return 0.0f;
        }
        return (float)(1.0 + Math.log(1.0 + Math.log(freq)));
    }

    @Override
    protected float ln(BasicStats stats, float freq, float docLen) {
        return 1.0f;
    }

    @Override
    protected float tfln(BasicStats stats, float freq, float docLen) {
        return 1.0f;
    }

    @Override
    protected float idf(BasicStats stats, float freq, float docLen) {
        return (float)Math.pow(((double)stats.getNumberOfDocuments() + 1.0) / (double)stats.getDocFreq(), this.k);
    }

    @Override
    protected float gamma(BasicStats stats, float freq, float docLen) {
        return (docLen - (float)this.queryLen) * this.s * (float)this.queryLen / stats.getAvgFieldLength();
    }
}

