/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public abstract class ConstantScoreWeight
extends Weight {
    private float boost;
    private float queryNorm;
    private float queryWeight;

    protected ConstantScoreWeight(Query query) {
        super(query);
        this.normalize(1.0f, 1.0f);
    }

    @Override
    public void extractTerms(Set<Term> terms) {
    }

    @Override
    public final float getValueForNormalization() throws IOException {
        return this.queryWeight * this.queryWeight;
    }

    @Override
    public void normalize(float norm, float boost) {
        this.boost = boost;
        this.queryNorm = norm;
        this.queryWeight = this.queryNorm * boost;
    }

    protected final float queryNorm() {
        return this.queryNorm;
    }

    protected final float boost() {
        return this.boost;
    }

    protected final float score() {
        return this.queryWeight;
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        boolean exists;
        Scorer s2 = this.scorer(context);
        if (s2 == null) {
            exists = false;
        } else {
            TwoPhaseIterator twoPhase = s2.twoPhaseIterator();
            if (twoPhase == null) {
                exists = s2.iterator().advance(doc) == doc;
            } else {
                boolean bl = exists = twoPhase.approximation().advance(doc) == doc && twoPhase.matches();
            }
        }
        if (exists) {
            return Explanation.match(this.queryWeight, this.getQuery().toString() + ", product of:", Explanation.match(this.boost, "boost", new Explanation[0]), Explanation.match(this.queryNorm, "queryNorm", new Explanation[0]));
        }
        return Explanation.noMatch(this.getQuery().toString() + " doesn't match id " + doc, new Explanation[0]);
    }
}

