/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConjunctionScorer;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ReqOptSumScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

class BooleanTopLevelScorers {
    BooleanTopLevelScorers() {
    }

    static class ReqMultiOptScorer
    extends ReqOptSumScorer {
        private final int requiredCount;
        private final float[] coords;

        public ReqMultiOptScorer(Scorer reqScorer, Scorer optScorer, int requiredCount, float[] coords) {
            super(reqScorer, optScorer);
            this.requiredCount = requiredCount;
            this.coords = coords;
        }

        @Override
        public float score() throws IOException {
            int curDoc = this.reqScorer.docID();
            float score = this.reqScorer.score();
            int optScorerDoc = this.optIterator.docID();
            if (optScorerDoc < curDoc) {
                optScorerDoc = this.optIterator.advance(curDoc);
            }
            score = optScorerDoc == curDoc ? (score + this.optScorer.score()) * this.coords[this.requiredCount + this.optScorer.freq()] : (score *= this.coords[this.requiredCount]);
            return score;
        }
    }

    static class ReqSingleOptScorer
    extends ReqOptSumScorer {
        private final float coordReq;
        private final float coordBoth;

        public ReqSingleOptScorer(Scorer reqScorer, Scorer optScorer, float coordReq, float coordBoth) {
            super(reqScorer, optScorer);
            this.coordReq = coordReq;
            this.coordBoth = coordBoth;
        }

        @Override
        public float score() throws IOException {
            int curDoc = this.reqScorer.docID();
            float score = this.reqScorer.score();
            int optScorerDoc = this.optIterator.docID();
            if (optScorerDoc < curDoc) {
                optScorerDoc = this.optIterator.advance(curDoc);
            }
            score = optScorerDoc == curDoc ? (score + this.optScorer.score()) * this.coordBoth : (score *= this.coordReq);
            return score;
        }
    }

    static class CoordinatingConjunctionScorer
    extends ConjunctionScorer {
        private final float[] coords;
        private final int reqCount;
        private final Scorer req;
        private final Scorer opt;

        CoordinatingConjunctionScorer(Weight weight, float[] coords, Scorer req, int reqCount, Scorer opt) {
            super(weight, Arrays.asList(req, opt), Arrays.asList(req, opt), 1.0f);
            this.coords = coords;
            this.req = req;
            this.reqCount = reqCount;
            this.opt = opt;
        }

        @Override
        public float score() throws IOException {
            return (this.req.score() + this.opt.score()) * this.coords[this.reqCount + this.opt.freq()];
        }
    }

    static class BoostedBulkScorer
    extends BulkScorer {
        final BulkScorer in;
        final float boost;

        BoostedBulkScorer(BulkScorer scorer, float boost) {
            this.in = scorer;
            this.boost = boost;
        }

        @Override
        public int score(LeafCollector collector, Bits acceptDocs, int min2, int max) throws IOException {
            FilterLeafCollector wrapped = new FilterLeafCollector(collector){

                @Override
                public void setScorer(Scorer scorer) throws IOException {
                    super.setScorer(new BoostedScorer(scorer, boost));
                }
            };
            return this.in.score(wrapped, acceptDocs, min2, max);
        }

        @Override
        public long cost() {
            return this.in.cost();
        }
    }

    static class BoostedScorer
    extends FilterScorer {
        final float boost;

        BoostedScorer(Scorer in, float boost) {
            super(in);
            this.boost = boost;
        }

        @Override
        public float score() throws IOException {
            return this.in.score() * this.boost;
        }

        @Override
        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.in, "BOOSTED"));
        }
    }
}

