/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.StringHelper;

abstract class RangeFieldQuery
extends Query {
    final String field;
    final QueryType queryType;
    final int numDims;
    final byte[] ranges;
    final int bytesPerDim;

    RangeFieldQuery(String field, byte[] ranges, int numDims, QueryType queryType) {
        RangeFieldQuery.checkArgs(field, ranges, numDims);
        if (queryType == null) {
            throw new IllegalArgumentException("Query type cannot be null");
        }
        this.field = field;
        this.queryType = queryType;
        this.numDims = numDims;
        this.ranges = ranges;
        this.bytesPerDim = ranges.length / (2 * numDims);
    }

    private static void checkArgs(String field, byte[] ranges, int numDims) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (numDims > 4) {
            throw new IllegalArgumentException("dimension size cannot be greater than 4");
        }
        if (ranges == null || ranges.length == 0) {
            throw new IllegalArgumentException("encoded ranges cannot be null or empty");
        }
    }

    private void checkFieldInfo(FieldInfo fieldInfo) {
        if (fieldInfo.getPointDimensionCount() / 2 != this.numDims) {
            throw new IllegalArgumentException("field=\"" + this.field + "\" was indexed with numDims=" + fieldInfo.getPointDimensionCount() / 2 + " but this query has numDims=" + this.numDims);
        }
    }

    @Override
    public final Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){
            final RangeFieldComparator target;
            {
                this.target = new RangeFieldComparator();
            }

            private DocIdSet buildMatchingDocIdSet(LeafReader reader, PointValues values) throws IOException {
                final DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values, RangeFieldQuery.this.field);
                values.intersect(RangeFieldQuery.this.field, new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    @Override
                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    @Override
                    public void visit(int docID) throws IOException {
                        this.adder.add(docID);
                    }

                    @Override
                    public void visit(int docID, byte[] leaf) throws IOException {
                        if (target.matches(leaf)) {
                            this.adder.add(docID);
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        byte[] node = this.getInternalRange(minPackedValue, maxPackedValue);
                        if (!target.intersects(node)) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        if (target.within(node)) {
                            return PointValues.Relation.CELL_CROSSES_QUERY;
                        }
                        if (target.contains(node)) {
                            return RangeFieldQuery.this.queryType == QueryType.CONTAINS || RangeFieldQuery.this.queryType == QueryType.CROSSES ? PointValues.Relation.CELL_OUTSIDE_QUERY : PointValues.Relation.CELL_INSIDE_QUERY;
                        }
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                });
                return result.build();
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                PointValues values = reader.getPointValues();
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(RangeFieldQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                RangeFieldQuery.this.checkFieldInfo(fieldInfo);
                boolean allDocsMatch = true;
                if (values.getDocCount(RangeFieldQuery.this.field) == reader.maxDoc()) {
                    byte[] range = this.getInternalRange(values.getMinPackedValue(RangeFieldQuery.this.field), values.getMaxPackedValue(RangeFieldQuery.this.field));
                    if (RangeFieldQuery.this.queryType == QueryType.CROSSES || !Arrays.equals(RangeFieldQuery.this.ranges, range) && (!this.target.contains(range) || RangeFieldQuery.this.queryType != QueryType.WITHIN)) {
                        allDocsMatch = false;
                    }
                } else {
                    allDocsMatch = false;
                }
                DocIdSetIterator iterator = allDocsMatch ? DocIdSetIterator.all(reader.maxDoc()) : this.buildMatchingDocIdSet(reader, values).iterator();
                return new ConstantScoreScorer((Weight)this, this.score(), iterator);
            }

            private byte[] getInternalRange(byte[] min2, byte[] max) {
                byte[] range = new byte[min2.length];
                int dimSize = RangeFieldQuery.this.numDims * RangeFieldQuery.this.bytesPerDim;
                System.arraycopy(min2, 0, range, 0, dimSize);
                System.arraycopy(max, dimSize, range, dimSize, dimSize);
                return range;
            }
        };
    }

    @Override
    public int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + this.numDims;
        hash = 31 * hash + this.queryType.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.ranges);
        return hash;
    }

    @Override
    public final boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((RangeFieldQuery)this.getClass().cast(o));
    }

    protected boolean equalsTo(RangeFieldQuery other) {
        return Objects.equals(this.field, other.field) && this.numDims == other.numDims && Arrays.equals(this.ranges, other.ranges) && other.queryType == this.queryType;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("<ranges:");
        sb.append(this.toString(this.ranges, 0));
        for (int d = 1; d < this.numDims; ++d) {
            sb.append(' ');
            sb.append(this.toString(this.ranges, d));
        }
        sb.append('>');
        return sb.toString();
    }

    protected abstract String toString(byte[] var1, int var2);

    class RangeFieldComparator {
        final Predicate<byte[]> predicate;

        RangeFieldComparator() {
            switch (RangeFieldQuery.this.queryType) {
                case INTERSECTS: {
                    this.predicate = this::intersects;
                    break;
                }
                case WITHIN: {
                    this.predicate = this::contains;
                    break;
                }
                case CONTAINS: {
                    this.predicate = this::within;
                    break;
                }
                case CROSSES: {
                    this.predicate = leaf -> this.intersects((byte[])leaf) && !this.contains((byte[])leaf);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid queryType [" + (Object)((Object)RangeFieldQuery.this.queryType) + "] found.");
                }
            }
        }

        private boolean matches(byte[] candidate) {
            return Arrays.equals(RangeFieldQuery.this.ranges, candidate) && RangeFieldQuery.this.queryType != QueryType.CROSSES || this.predicate.test(candidate);
        }

        private boolean intersects(byte[] candidate) {
            return this.relate(d -> this.compareMinMax(candidate, d) > 0 || this.compareMaxMin(candidate, d) < 0);
        }

        private boolean within(byte[] candidate) {
            return this.relate(d -> this.compareMinMin(candidate, d) < 0 || this.compareMaxMax(candidate, d) > 0);
        }

        private boolean contains(byte[] candidate) {
            return this.relate(d -> this.compareMinMin(candidate, d) > 0 || this.compareMaxMax(candidate, d) < 0);
        }

        private boolean relate(IntPredicate predicate) {
            for (int d = 0; d < RangeFieldQuery.this.numDims; ++d) {
                if (!predicate.test(d)) continue;
                return false;
            }
            return true;
        }

        private int compareMinMin(byte[] b, int dimension) {
            return StringHelper.compare(RangeFieldQuery.this.bytesPerDim, RangeFieldQuery.this.ranges, dimension *= RangeFieldQuery.this.bytesPerDim, b, dimension);
        }

        private int compareMinMax(byte[] b, int dimension) {
            return StringHelper.compare(RangeFieldQuery.this.bytesPerDim, RangeFieldQuery.this.ranges, dimension *= RangeFieldQuery.this.bytesPerDim, b, RangeFieldQuery.this.numDims * RangeFieldQuery.this.bytesPerDim + dimension);
        }

        private int compareMaxMin(byte[] b, int dimension) {
            return StringHelper.compare(RangeFieldQuery.this.bytesPerDim, RangeFieldQuery.this.ranges, RangeFieldQuery.this.numDims * RangeFieldQuery.this.bytesPerDim + (dimension *= RangeFieldQuery.this.bytesPerDim), b, dimension);
        }

        private int compareMaxMax(byte[] b, int dimension) {
            dimension = RangeFieldQuery.this.numDims * RangeFieldQuery.this.bytesPerDim + dimension * RangeFieldQuery.this.bytesPerDim;
            return StringHelper.compare(RangeFieldQuery.this.bytesPerDim, RangeFieldQuery.this.ranges, dimension, b, dimension);
        }
    }

    static enum QueryType {
        INTERSECTS,
        WITHIN,
        CONTAINS,
        CROSSES;

    }
}

