/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import com.ximpleware.extended.IByteBuffer;
import com.ximpleware.extended.ParseExceptionHuge;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.Pipe;

public class JulieXMLMemMappedBuffer
implements IByteBuffer {
    MappedByteBuffer[] input;
    FileChannel fc;
    RandomAccessFile raf;
    String fn;
    long length;

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte byteAt(long index) {
        return this.input[(int)(index >> 30)].get((int)(index & 0x3FFFFFFFL));
    }

    public void readFile(String fileName) throws IOException, ParseExceptionHuge {
        long l;
        File f = new File(fileName);
        this.fn = fileName;
        this.length = l = f.length();
        if (l >= 0x4000000000L) {
            throw new ParseExceptionHuge("document too big > 256 Gbyte");
        }
        this.raf = new RandomAccessFile(fileName, "r");
        this.fc = this.raf.getChannel();
        int pageNumber = (int)(l >> 30) + ((l & 0x3FFFFFFFL) == 0L ? 0 : 1);
        this.input = new MappedByteBuffer[pageNumber];
        long l2 = 0L;
        for (int i = 0; i < pageNumber; ++i) {
            if (i < pageNumber - 1) {
                this.input[i] = this.fc.map(FileChannel.MapMode.READ_ONLY, l2, 0x40000000L);
                l2 += 0x40000000L;
                continue;
            }
            this.input[i] = this.fc.map(FileChannel.MapMode.READ_ONLY, l2, l - ((long)i << 30));
        }
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    @Override
    public byte[] getBytes(int offset, int len) {
        return null;
    }

    @Override
    public void writeToFileOutputStream(FileOutputStream ost, long os, long len) throws IOException {
        FileChannel ostChannel = ost.getChannel();
        this.fc.transferTo(os, len, ostChannel);
    }

    public void writeToPipe(Pipe pipe, long os, long len) throws IOException {
        Pipe.SinkChannel sinkChannel = pipe.sink();
        this.fc.transferTo(os, len, sinkChannel);
    }

    @Override
    public void close() {
    }
}

