/*
 * Decompiled with CFR 0.152.
 */
package org.tartarus.snowball;

import org.apache.lucene.util.ArrayUtil;
import org.tartarus.snowball.Among;

public abstract class SnowballProgram {
    private char[] current = new char[8];
    protected int cursor;
    protected int limit;
    protected int limit_backward;
    protected int bra;
    protected int ket;

    protected SnowballProgram() {
        this.setCurrent("");
    }

    public abstract boolean stem();

    public void setCurrent(String value) {
        this.current = value.toCharArray();
        this.cursor = 0;
        this.limit = value.length();
        this.limit_backward = 0;
        this.bra = this.cursor;
        this.ket = this.limit;
    }

    public String getCurrent() {
        return new String(this.current, 0, this.limit);
    }

    public void setCurrent(char[] text, int length) {
        this.current = text;
        this.cursor = 0;
        this.limit = length;
        this.limit_backward = 0;
        this.bra = this.cursor;
        this.ket = this.limit;
    }

    public char[] getCurrentBuffer() {
        return this.current;
    }

    public int getCurrentBufferLength() {
        return this.limit;
    }

    protected void copy_from(SnowballProgram other) {
        this.current = other.current;
        this.cursor = other.cursor;
        this.limit = other.limit;
        this.limit_backward = other.limit_backward;
        this.bra = other.bra;
        this.ket = other.ket;
    }

    protected boolean in_grouping(char[] s2, int min2, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.current[this.cursor];
        if (ch > max || ch < min2) {
            return false;
        }
        if ((s2[(ch = (char)(ch - min2)) >> 3] & 1 << (ch & 7)) == 0) {
            return false;
        }
        ++this.cursor;
        return true;
    }

    protected boolean in_grouping_b(char[] s2, int min2, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.current[this.cursor - 1];
        if (ch > max || ch < min2) {
            return false;
        }
        if ((s2[(ch = (char)(ch - min2)) >> 3] & 1 << (ch & 7)) == 0) {
            return false;
        }
        --this.cursor;
        return true;
    }

    protected boolean out_grouping(char[] s2, int min2, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.current[this.cursor];
        if (ch > max || ch < min2) {
            ++this.cursor;
            return true;
        }
        if ((s2[(ch = (char)(ch - min2)) >> 3] & 1 << (ch & 7)) == 0) {
            ++this.cursor;
            return true;
        }
        return false;
    }

    protected boolean out_grouping_b(char[] s2, int min2, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.current[this.cursor - 1];
        if (ch > max || ch < min2) {
            --this.cursor;
            return true;
        }
        if ((s2[(ch = (char)(ch - min2)) >> 3] & 1 << (ch & 7)) == 0) {
            --this.cursor;
            return true;
        }
        return false;
    }

    protected boolean in_range(int min2, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.current[this.cursor];
        if (ch > max || ch < min2) {
            return false;
        }
        ++this.cursor;
        return true;
    }

    protected boolean in_range_b(int min2, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.current[this.cursor - 1];
        if (ch > max || ch < min2) {
            return false;
        }
        --this.cursor;
        return true;
    }

    protected boolean out_range(int min2, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.current[this.cursor];
        if (ch <= max && ch >= min2) {
            return false;
        }
        ++this.cursor;
        return true;
    }

    protected boolean out_range_b(int min2, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.current[this.cursor - 1];
        if (ch <= max && ch >= min2) {
            return false;
        }
        --this.cursor;
        return true;
    }

    protected boolean eq_s(int s_size, CharSequence s2) {
        if (this.limit - this.cursor < s_size) {
            return false;
        }
        for (int i = 0; i != s_size; ++i) {
            if (this.current[this.cursor + i] == s2.charAt(i)) continue;
            return false;
        }
        this.cursor += s_size;
        return true;
    }

    protected boolean eq_s_b(int s_size, CharSequence s2) {
        if (this.cursor - this.limit_backward < s_size) {
            return false;
        }
        for (int i = 0; i != s_size; ++i) {
            if (this.current[this.cursor - s_size + i] == s2.charAt(i)) continue;
            return false;
        }
        this.cursor -= s_size;
        return true;
    }

    protected boolean eq_v(CharSequence s2) {
        return this.eq_s(s2.length(), s2);
    }

    protected boolean eq_v_b(CharSequence s2) {
        return this.eq_s_b(s2.length(), s2);
    }

    protected int find_among(Among[] v, int v_size) {
        Among w;
        int i = 0;
        int j = v_size;
        int c = this.cursor;
        int l = this.limit;
        int common_i = 0;
        int common_j = 0;
        boolean first_key_inspected = false;
        while (true) {
            int k = i + (j - i >> 1);
            int diff = 0;
            int common = common_i < common_j ? common_i : common_j;
            Among w2 = v[k];
            for (int i2 = common; i2 < w2.s_size; ++i2) {
                if (c + common == l) {
                    diff = -1;
                    break;
                }
                diff = this.current[c + common] - w2.s[i2];
                if (diff != 0) break;
                ++common;
            }
            if (diff < 0) {
                j = k;
                common_j = common;
            } else {
                i = k;
                common_i = common;
            }
            if (j - i > 1) continue;
            if (i > 0 || j == i || first_key_inspected) break;
            first_key_inspected = true;
        }
        do {
            w = v[i];
            if (common_i < w.s_size) continue;
            this.cursor = c + w.s_size;
            if (w.method == null) {
                return w.result;
            }
            boolean res = false;
            try {
                res = w.method.invokeExact(this);
            }
            catch (Throwable e) {
                SnowballProgram.rethrow(e);
            }
            this.cursor = c + w.s_size;
            if (!res) continue;
            return w.result;
        } while ((i = w.substring_i) >= 0);
        return 0;
    }

    protected int find_among_b(Among[] v, int v_size) {
        Among w;
        int i = 0;
        int j = v_size;
        int c = this.cursor;
        int lb = this.limit_backward;
        int common_i = 0;
        int common_j = 0;
        boolean first_key_inspected = false;
        while (true) {
            int k = i + (j - i >> 1);
            int diff = 0;
            int common = common_i < common_j ? common_i : common_j;
            Among w2 = v[k];
            for (int i2 = w2.s_size - 1 - common; i2 >= 0; --i2) {
                if (c - common == lb) {
                    diff = -1;
                    break;
                }
                diff = this.current[c - 1 - common] - w2.s[i2];
                if (diff != 0) break;
                ++common;
            }
            if (diff < 0) {
                j = k;
                common_j = common;
            } else {
                i = k;
                common_i = common;
            }
            if (j - i > 1) continue;
            if (i > 0 || j == i || first_key_inspected) break;
            first_key_inspected = true;
        }
        do {
            w = v[i];
            if (common_i < w.s_size) continue;
            this.cursor = c - w.s_size;
            if (w.method == null) {
                return w.result;
            }
            boolean res = false;
            try {
                res = w.method.invokeExact(this);
            }
            catch (Throwable e) {
                SnowballProgram.rethrow(e);
            }
            this.cursor = c - w.s_size;
            if (!res) continue;
            return w.result;
        } while ((i = w.substring_i) >= 0);
        return 0;
    }

    protected int replace_s(int c_bra, int c_ket, CharSequence s2) {
        int adjustment = s2.length() - (c_ket - c_bra);
        int newLength = this.limit + adjustment;
        if (newLength > this.current.length) {
            char[] newBuffer = new char[ArrayUtil.oversize(newLength, 2)];
            System.arraycopy(this.current, 0, newBuffer, 0, this.limit);
            this.current = newBuffer;
        }
        if (adjustment != 0 && c_ket < this.limit) {
            System.arraycopy(this.current, c_ket, this.current, c_bra + s2.length(), this.limit - c_ket);
        }
        for (int i = 0; i < s2.length(); ++i) {
            this.current[c_bra + i] = s2.charAt(i);
        }
        this.limit += adjustment;
        if (this.cursor >= c_ket) {
            this.cursor += adjustment;
        } else if (this.cursor > c_bra) {
            this.cursor = c_bra;
        }
        return adjustment;
    }

    protected void slice_check() {
        if (this.bra < 0 || this.bra > this.ket || this.ket > this.limit) {
            throw new IllegalArgumentException("faulty slice operation: bra=" + this.bra + ",ket=" + this.ket + ",limit=" + this.limit);
        }
    }

    protected void slice_from(CharSequence s2) {
        this.slice_check();
        this.replace_s(this.bra, this.ket, s2);
    }

    protected void slice_del() {
        this.slice_from("");
    }

    protected void insert(int c_bra, int c_ket, CharSequence s2) {
        int adjustment = this.replace_s(c_bra, c_ket, s2);
        if (c_bra <= this.bra) {
            this.bra += adjustment;
        }
        if (c_bra <= this.ket) {
            this.ket += adjustment;
        }
    }

    protected StringBuilder slice_to(StringBuilder s2) {
        this.slice_check();
        int len = this.ket - this.bra;
        s2.setLength(0);
        s2.append(this.current, this.bra, len);
        return s2;
    }

    protected StringBuilder assign_to(StringBuilder s2) {
        s2.setLength(0);
        s2.append(this.current, 0, this.limit);
        return s2;
    }

    private static void rethrow(Throwable t) {
        SnowballProgram.rethrow0(t);
    }

    private static <T extends Throwable> void rethrow0(Throwable t) throws T {
        throw t;
    }
}

